/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db.imp;

import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.core.util.MessageLogger;
import oracle.dbtools.plusplus.connections.db.imp.BaseOracleConverter;
import oracle.dbtools.plusplus.connections.db.imp.ConnectionsConverter;
import oracle.dbtools.plusplus.connections.db.imp.ConnectionsConverterFactory;

public class AdvancedConverterFactory
implements ConnectionsConverterFactory {
    @Override
    public boolean canConvert(DatabaseProvider provider) {
        return "oraJDBC".equals(provider.getProperty("subtype")) && "ADVANCED".equals(provider.getProperty("OracleConnectionType"));
    }

    @Override
    public ConnectionsConverter createConverter(DatabaseProvider provider, MessageLogger logger) {
        return new AdvancedConverter(provider, logger);
    }

    private static class AdvancedConverter
    extends BaseOracleConverter {
        AdvancedConverter(DatabaseProvider provider, MessageLogger logger) {
            super(provider, logger);
        }

        @Override
        protected String processConnectionSpec() {
            this.addDBToolsProperty("type", "ORACLE_DATABASE");
            return this.processCustomURL();
        }
    }
}

