/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.awrash.core;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Optional;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.SQLPLUSCmdFormatter;
import oracle.dbtools.extension.awrash.command.AWRMessages;
import oracle.dbtools.extension.awrash.command.Mode;
import oracle.dbtools.extension.awrash.exception.CanNotListSnapShotException;
import oracle.dbtools.extension.awrash.exception.NoPrivilegesAvailableException;
import oracle.dbtools.extension.awrash.utility.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class AWREngine {
    private final ScriptRunnerContext ctx;
    private final Connection conn;
    private final DBUtil dbUtil;

    public AWREngine(ScriptRunnerContext ctx, Connection conn) {
        this.ctx = ctx;
        this.conn = conn;
        this.dbUtil = DBUtil.getInstance((Connection)conn);
    }

    public void createReport(String beginSnapId, String endSnapId, Mode mode) throws NoPrivilegesAvailableException, SQLException, IllegalArgumentException {
        if (this.hasNotAWRPrivileges(this.dbUtil)) {
            throw new NoPrivilegesAvailableException(AWRMessages.getString("AWR_NO_EXEC_PRIVILEGES"));
        }
        if (null == mode) {
            mode = Mode.HTML;
        }
        if (null == beginSnapId) {
            beginSnapId = this.getSecondLastSnapshotId();
        } else if (this.snapshotDoesNotExist(beginSnapId) || this.isNotValidInteger(beginSnapId)) {
            throw new IllegalArgumentException(MessageFormat.format(AWRMessages.getString("AWR_NO_SNAPSHOT_ID"), beginSnapId));
        }
        if (null == endSnapId) {
            endSnapId = this.getLastSnapshotId();
        } else if (this.snapshotDoesNotExist(endSnapId) || this.isNotValidInteger(endSnapId)) {
            throw new IllegalArgumentException(MessageFormat.format(AWRMessages.getString("AWR_NO_SNAPSHOT_ID"), endSnapId));
        }
        String queryType = "get" + mode.toString() + "Report";
        String sqlQuery = QueryUtils.getXmlQueries().getQuery(queryType, this.conn).getSql();
        Map<String, String> binds = Map.of("beginSnapId", beginSnapId, "endSnapId", endSnapId);
        try (ResultSet rs = this.dbUtil.executeOracleQuery(sqlQuery, binds);){
            if (null == rs) {
                throw new SQLException(MessageFormat.format(AWRMessages.getString("AWR_ERROR_GENERATE_REPORT"), mode.toString(), this.dbUtil.getLastException().getMessage()));
            }
            this.generateReportFile(rs, beginSnapId, endSnapId, mode);
        }
    }

    private boolean snapshotDoesNotExist(String snapshotId) {
        String sqlQuery = QueryUtils.getXmlQueries().getQuery("snapShotExists", this.conn).getSql();
        return !"valid_id".equals(this.dbUtil.executeReturnOneCol(sqlQuery, Map.of("snapId", snapshotId)));
    }

    private boolean isNotValidInteger(String integer) {
        try {
            Integer.valueOf(integer);
            return false;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    private void generateReportFile(ResultSet rs, String beginSnapId, String endSnapId, Mode mode) {
        String fileName = String.format("awr_%s_%s_%s.%s", this.getDbContainerName(), this.getSnapBeginIntervalTime(beginSnapId), this.getSnapEndIntervalTime(endSnapId), this.getFileExtension(mode));
        String fileFullPath = this.getReportFileFullPah(fileName);
        try (BufferedWriter awr_file = new BufferedWriter(new FileWriter(fileFullPath));){
            while (rs.next()) {
                String line = rs.getString(1);
                if (null == line) {
                    line = "";
                }
                awr_file.write(line);
                awr_file.write(System.lineSeparator());
            }
            rs.close();
            this.ctx.writeln(MessageFormat.format(AWRMessages.getString("AWR_REPORT_GENERATED"), fileName));
        }
        catch (IOException | SQLException e) {
            this.ctx.writeln(String.format("Cannot write output file: %s", e.getMessage()));
        }
    }

    private String getDbContainerName() {
        String sqlQuery = QueryUtils.getXmlQueries().getQuery("getDbContainerName", this.conn).getSql();
        return this.dbUtil.executeReturnOneCol(sqlQuery);
    }

    private String getSnapBeginIntervalTime(String beginSnapId) {
        String sqlQuery = QueryUtils.getXmlQueries().getQuery("getSnapBeginIntervalTime", this.conn).getSql();
        return this.dbUtil.executeReturnOneCol(sqlQuery, Map.of("begin_snap_id", beginSnapId));
    }

    private String getSnapEndIntervalTime(String endSnapId) {
        String sqlQuery = QueryUtils.getXmlQueries().getQuery("getSnapEndIntervalTime", this.conn).getSql();
        return this.dbUtil.executeReturnOneCol(sqlQuery, Map.of("end_snap_id", endSnapId));
    }

    private String getLastSnapshotId() {
        String sqlQuery = QueryUtils.getXmlQueries().getQuery("getLastSnapShotId", this.conn).getSql();
        return this.dbUtil.executeReturnOneCol(sqlQuery);
    }

    private String getSecondLastSnapshotId() {
        String sqlQuery = QueryUtils.getXmlQueries().getQuery("getSecondLastSnapShotId", this.conn).getSql();
        return this.dbUtil.executeReturnOneCol(sqlQuery);
    }

    private String getFileExtension(Mode mode) {
        String extension = mode == Mode.TEXT ? mode.toString().toLowerCase().replace("e", "") : mode.toString().toLowerCase();
        return extension;
    }

    private String getReportFileFullPah(String fileName) {
        String currentDir = (String)this.ctx.getMap().get(ScriptRunnerContext.SqlplusVariable._PWD.toString());
        String filePathSep = FileSystems.getDefault().getSeparator();
        return currentDir + filePathSep + fileName;
    }

    public Optional<String> createSnapshot(String flushLevel) throws NoPrivilegesAvailableException {
        if (this.hasNotAWRPrivileges(this.dbUtil)) {
            throw new NoPrivilegesAvailableException(AWRMessages.getString("AWR_NO_SELECT_PRIVILEGES"));
        }
        String sqlQuery = QueryUtils.getXmlQueries().getQuery("createSnapShot", this.conn).getSql();
        String snapId = flushLevel.isBlank() ? this.createDefaultSnapshot() : this.dbUtil.executeReturnOneCol(sqlQuery, Map.of("FLUSH_LEVEL", flushLevel));
        if (null == snapId) {
            return Optional.empty();
        }
        return Optional.of(snapId);
    }

    private String createDefaultSnapshot() {
        String sqlQuery = QueryUtils.getXmlQueries().getQuery("createDefaultSnapShot", this.conn).getSql();
        return this.dbUtil.executeReturnOneCol(sqlQuery);
    }

    private boolean hasNotAWRPrivileges(DBUtil dbUtil) {
        String sqlQuery = QueryUtils.getXmlQueries().getQuery("hasAwrPrivileges", this.conn).getSql();
        return null == dbUtil.executeReturnOneCol(sqlQuery);
    }

    public void listSnapshots() throws CanNotListSnapShotException, NoPrivilegesAvailableException {
        if (!this.hasSnapshotPrivileges(this.dbUtil)) {
            throw new NoPrivilegesAvailableException(AWRMessages.getString("AWR_NO_SELECT_PRIVILEGES"));
        }
        String sql = QueryUtils.getXmlQueries().getQuery("listSnapshots", this.conn).getSql();
        ResultSet rs = this.dbUtil.executeOracleQuery(sql, null);
        if (null == rs) {
            throw new CanNotListSnapShotException(MessageFormat.format(AWRMessages.getString("AWR_CANT_LIST_SNAPSHOT"), this.dbUtil.getLastException().getMessage()));
        }
        this.writeResultSet(rs, sql);
    }

    private boolean hasSnapshotPrivileges(DBUtil dbUtil) {
        String sql = QueryUtils.getXmlQueries().getQuery("hasSnapShotPrivileges", this.conn).getSql();
        String result = dbUtil.executeReturnOneCol(sql);
        return "exists".equals(result);
    }

    private void writeResultSet(ResultSet rs, String sql) {
        String optionalHeader = (String)this.ctx.getProperty("script.runner.optional_show_header");
        if (optionalHeader != null && !optionalHeader.isEmpty()) {
            this.ctx.write(optionalHeader);
        }
        SQLPLUSCmdFormatter rFormat = new SQLPLUSCmdFormatter(this.ctx);
        try {
            rFormat.formatResults((BufferedOutputStream)this.ctx.getOutputStream(), rs, sql);
        }
        catch (IOException | SQLException e) {
            this.ctx.writeln(MessageFormat.format(AWRMessages.getString("AWR_ERROR_PRINTING_RESULTS"), e.getMessage()));
        }
    }
}

