/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.xml.report;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.xml.report.DisplayElement;
import oracle.dbtools.xml.report.ReportXmlElements;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;

public class FolderElement
implements ReportXmlElements {
    private final String id;
    private final String name;
    private final String tooltip;
    private final String description;
    private final List<DisplayElement> displays = new ArrayList<DisplayElement>();
    private final List<FolderElement> folders = new ArrayList<FolderElement>();
    private final String globalResource;

    public FolderElement(XMLNode node, String globalResource) {
        XMLNode[] foldersElements;
        this.globalResource = globalResource;
        this.name = XMLHelper.getNodeValue((Node)node, "name");
        this.tooltip = XMLHelper.getNodeValue((Node)node, "tooltip");
        this.description = XMLHelper.getNodeValue((Node)node, "description");
        this.id = XMLHelper.getAttributeNode((Node)node, "id");
        XMLNode[] displaysElements = XMLHelper.getChildNodes((Node)node, "display");
        if (displaysElements != null) {
            for (XMLNode displayElement : displaysElements) {
                ObjectQueries queries = new ObjectQueries(displayElement);
                this.displays.add(new DisplayElement(displayElement, queries, globalResource));
            }
        }
        if ((foldersElements = XMLHelper.getChildNodes((Node)node, "folder")) != null) {
            for (XMLNode folderElement : foldersElements) {
                this.folders.add(new FolderElement(folderElement, globalResource));
            }
        }
    }

    public FolderElement(XMLNode node) {
        this(node, "");
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getDescription() {
        return this.description;
    }

    public List<DisplayElement> getDisplays() {
        return this.displays;
    }

    public List<FolderElement> getFolders() {
        return this.folders;
    }

    public String globalResource() {
        return this.globalResource;
    }
}

