/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.xml.report;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.xml.actions.ItemElement;
import oracle.dbtools.xml.report.ReportXmlElements;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;

public class DisplayElement
implements ReportXmlElements {
    private final String id;
    private final String type;
    private final String style;
    private final String enable;
    private final String name;
    private final String description;
    private final String tooltip;
    private final String drillClass;
    private final List<ItemElement> items = new ArrayList<ItemElement>();
    private ObjectQueries queries;
    private final String globalResource;
    private final List<DisplayElement> displayChildren = new ArrayList<DisplayElement>();

    public DisplayElement(XMLNode node, ObjectQueries queries, String globalResource) {
        this(node, globalResource);
        this.queries = queries;
    }

    public DisplayElement(XMLNode node) {
        this(node, "");
    }

    public DisplayElement(XMLNode node, String globalResource) {
        this.globalResource = globalResource;
        this.id = XMLHelper.getAttributeNode((Node)node, "id");
        this.type = XMLHelper.getAttributeNode((Node)node, "type");
        this.style = XMLHelper.getAttributeNode((Node)node, "style");
        this.enable = XMLHelper.getAttributeNode((Node)node, "enable");
        this.name = XMLHelper.getNodeValue((Node)node, "name");
        this.description = XMLHelper.getNodeValue((Node)node, "description");
        this.tooltip = XMLHelper.getNodeValue((Node)node, "tooltip");
        this.drillClass = XMLHelper.getNodeValue((Node)node, "drillclass");
        XMLNode[] itemsElements = XMLHelper.getChildNodes((Node)node, "item");
        XMLNode[] displayChildrenElements = XMLHelper.getChildNodes((Node)node, "display");
        if (itemsElements != null) {
            for (XMLNode itemElement : itemsElements) {
                this.items.add(new ItemElement(itemElement, globalResource));
            }
        }
        if (displayChildrenElements != null) {
            for (XMLNode displayChildElement : displayChildrenElements) {
                ObjectQueries queries = new ObjectQueries(displayChildElement);
                this.displayChildren.add(new DisplayElement(displayChildElement, queries, globalResource));
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getStyle() {
        return this.style;
    }

    public String getEnable() {
        return this.enable;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getDrillClass() {
        return this.drillClass;
    }

    public ObjectQueries queries() {
        return this.queries;
    }

    public List<ItemElement> items() {
        return this.items;
    }

    public String globalResource() {
        return this.globalResource;
    }

    public List<DisplayElement> displayChildren() {
        return this.displayChildren;
    }
}

