/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import oracle.dbtools.util.encoding.Decoder;
import oracle.dbtools.util.encoding.Encoder;
import oracle.dbtools.util.encoding.Encoding;
import oracle.dbtools.util.encoding.EncodingType;
import oracle.dbtools.util.encoding.MimeType;

public class NullEncoding
extends Encoding
implements Decoder,
Encoder {
    public NullEncoding(EncodingType encodingType, MimeType mimeType) {
        super(encodingType, mimeType);
    }

    public void copyReader(Reader in, Writer out) throws IOException {
        int c = in.read();
        while (c != -1) {
            out.write(c);
            c = in.read();
        }
        out.flush();
    }

    public void copyStream(InputStream in, OutputStream out) throws IOException {
        int c = in.read();
        while (c != -1) {
            out.write(c);
            c = in.read();
        }
        out.flush();
    }

    @Override
    public void decodeStream(Object in, Object out) throws IOException {
        if (in instanceof InputStream) {
            this.copyStream((InputStream)in, (OutputStream)out);
        } else {
            this.copyReader((Reader)in, (Writer)out);
        }
    }

    @Override
    public void encodeStream(Object in, Object out) throws IOException {
        this.decodeStream(in, out);
    }

    @Override
    public long getDecodeLength(long len) {
        return len;
    }

    @Override
    public long getEncodeLength(long len) {
        return len;
    }

    @Override
    public int getDecodeBlocksize() {
        return 1;
    }

    @Override
    public int getEncodeBlocksize() {
        return 1;
    }
}

