/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.util.Service;

public class HtmlTreeTableWidget {
    public String[] columnNames;
    private List<Row> data = new ArrayList<Row>();
    private List<String> nodeEncodings = new ArrayList<String>();
    private List<String> images = new ArrayList<String>();
    public String formName;
    private static final String defaultName = "";
    public String widgetName = "";

    public void append(String longLabel, String[] row, int level, String img) {
        this.append(longLabel, row, level, img, null);
    }

    public void append(String longLabel, String[] row, int level, String img, String color) {
        this.data.add(new Row(longLabel, row, color));
        if (this.nodeEncodings.size() == 0) {
            this.nodeEncodings.add("0");
        } else {
            long priorLevel = this.getLevel(this.nodeEncodings.size() - 1);
            String priorEncoding = this.nodeEncodings.get(this.nodeEncodings.size() - 1);
            if (priorLevel == (long)level) {
                int indexOfDot = priorEncoding.lastIndexOf(46);
                int siblingNo = Integer.parseInt(priorEncoding.substring(indexOfDot + 1));
                this.nodeEncodings.add(priorEncoding.substring(0, indexOfDot) + "." + (siblingNo + 1));
            } else {
                this.nodeEncodings.add(priorEncoding + ".0");
            }
        }
        this.images.add(img);
    }

    public void append(String longLabel, String[] row, String path, String img, String color) {
        this.data.add(new Row(longLabel, row, color));
        this.nodeEncodings.add(path);
        this.images.add(img);
    }

    private long getLevel(int row) {
        String path = this.nodeEncodings.get(row);
        return path.chars().filter(ch -> ch == 46).count() - 1L;
    }

    public boolean isLeaf(int row) {
        long thisLevel;
        long nextLevel = thisLevel = this.getLevel(row);
        if (row + 1 < this.nodeEncodings.size()) {
            nextLevel = this.getLevel(row + 1);
        }
        return thisLevel >= nextLevel;
    }

    public void concat(String moreLabel, String[] moreRow) {
        int idx = this.data.size();
        Row last = this.data.get(idx - 1);
        if (moreLabel != null) {
            last.label = last.label + moreLabel;
        }
        for (int i = 0; i < last.fields.length; ++i) {
            int n = i;
            last.fields[n] = last.fields[n] + moreRow[i];
        }
    }

    public String dataAt(int row, int col) {
        Row rowObj = this.data.get(row);
        if (rowObj.label != null) {
            return rowObj.label;
        }
        return rowObj.fields[col];
    }

    public String render() throws IOException {
        StringBuilder ret = new StringBuilder();
        if (this.columnNames.length == 0) {
            return defaultName;
        }
        String inlineCSS = Service.readFile(HtmlTreeTableWidget.class, (String)"TreeTable.css");
        int width0 = 45;
        int width1 = (100 - width0) / this.columnNames.length;
        inlineCSS = inlineCSS.replace("width0var", defaultName + width0);
        inlineCSS = inlineCSS.replace("width1var", defaultName + width1);
        String inlineJS = Service.readFile(HtmlTreeTableWidget.class, (String)"TreeTable.js");
        ret.append("<!DOCTYPE html>\n<html>\n<head>\n<meta http-equiv=\"Content-Security-Policy\" content=\"default-src gap://ready file://* *; style-src 'self' http://* https://* 'unsafe-inline'; script-src 'self' http://* https://* 'unsafe-inline' 'unsafe-eval';\">\n<style>\n" + inlineCSS);
        for (int i = 0; i < this.data.size(); ++i) {
            ret.append(".level" + i + " td:first-child {\n    padding-left: " + 15 * i + "px;\n}\n");
        }
        ret.append("</style>\n<link href=\"codiconsUriVar\" rel=\"stylesheet\" />\n<script>\n" + inlineJS + "</script>\n</head>\n<body>");
        ret.append(this.renderData());
        return ret.toString();
    }

    public String renderData() {
        StringBuilder ret = new StringBuilder();
        ret.append("\n <!-- ..........................data begin...........................  -->\n");
        ret.append("\n    <TABLE id=\"treeTableWidget\"/> \n");
        ret.append("    <tr class=\"Header\">\n");
        boolean isEvenCol = true;
        for (int i = 0; i < this.columnNames.length; ++i) {
            ret.append("\n     <th class=\"" + (isEvenCol ? "even-header-col" : "odd-header-col") + "\">&nbsp;");
            ret.append(i == 0 ? "OPERATION" : this.columnNames[i]);
            ret.append("&nbsp;</th>\n");
            isEvenCol = !isEvenCol;
        }
        ret.append("\n    </tr>\n");
        boolean evenRow = true;
        for (int row = 0; row < this.data.size(); ++row) {
            boolean rowSpans;
            ret.append("\n   <tr class=\"level" + this.getLevel(row) + "\" id=\"" + this.nodeEncodings.get(row) + "\">");
            boolean bl = rowSpans = this.data.get((int)row).label != null;
            if (!rowSpans) {
                evenRow = !evenRow;
            }
            boolean evenCol = true;
            int decrFontSize1 = this.columnNames.length > 6 ? -1 : 0;
            boolean firstCol = true;
            for (int col = 0; col < this.columnNames.length; ++col) {
                boolean isHtml;
                String cell;
                if (rowSpans && !firstCol) continue;
                evenCol = !evenCol;
                ret.append("\n      <td");
                if (!firstCol) {
                    ret.append(" class=\"");
                    if (evenRow && evenCol) {
                        ret.append("cell00");
                    } else if (evenRow && !evenCol) {
                        ret.append("cell01");
                    } else if (!evenRow && evenCol) {
                        ret.append("cell10");
                    } else {
                        ret.append("cell11");
                    }
                    ret.append("\"");
                }
                ret.append(">");
                if (firstCol) {
                    ret.append("<i class=\"codicon codicon-chevron-down");
                    if (this.isLeaf(row)) {
                        ret.append(" hide-icon");
                    }
                    ret.append("\" onclick=\"toggleBranch(this)\"></i>");
                }
                if ((cell = this.dataAt(row, rowSpans ? 0 : col)) == null) {
                    cell = "&nbsp";
                }
                ret.append(((isHtml = cell.startsWith("<")) ? defaultName : "&nbsp;") + cell + (isHtml ? defaultName : "&nbsp;"));
                ret.append("</td>");
                firstCol = false;
            }
            ret.append("\n   </tr>");
        }
        ret.append("\n</table>\n");
        ret.append("\n <!-- ..........................data end...........................  -->\n\n");
        return ret.toString();
    }

    private static class Row {
        String label = null;
        String color = null;
        String[] fields;

        public Row(String longLabel, String[] row, String color) {
            this.label = longLabel;
            this.fields = row;
            this.color = color;
        }
    }
}

