/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.jdbc.OracleArray;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.OPAQUE;
import oracle.xdb.XMLType;

public abstract class Closeables {
    public static <T> void close(T closeable) {
        if (closeable instanceof Flushable) {
            try {
                ((Flushable)closeable).flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (closeable instanceof Closeable) {
            try {
                ((Closeable)closeable).close();
            }
            catch (Throwable throwable) {}
        } else if (closeable instanceof ResultSet) {
            try {
                ResultSet target = (ResultSet)closeable;
                target.close();
            }
            catch (SQLException target) {}
        } else if (closeable instanceof Statement) {
            try {
                Statement target = (Statement)closeable;
                target.close();
            }
            catch (SQLException target) {}
        } else if (closeable instanceof Connection) {
            try {
                Connection target = (Connection)closeable;
                target.close();
            }
            catch (SQLException target) {}
        } else if (closeable instanceof BLOB) {
            try {
                BLOB target = (BLOB)closeable;
                target.close();
            }
            catch (SQLException target) {}
        } else if (closeable instanceof BFILE) {
            try {
                BFILE target = (BFILE)closeable;
                target.close();
            }
            catch (SQLException target) {}
        } else if (closeable instanceof SQLXML) {
            try {
                SQLXML target = (SQLXML)closeable;
                DataTypesUtil.freeSQLXML(target);
            }
            catch (Throwable target) {}
        } else if (closeable instanceof OPAQUE) {
            try {
                OPAQUE target = (OPAQUE)closeable;
                DataTypesUtil.freeSQLXML(target);
            }
            catch (Throwable target) {}
        } else if (closeable instanceof XMLType) {
            try {
                XMLType target = (XMLType)closeable;
                target.close();
            }
            catch (Throwable target) {}
        } else if (closeable instanceof OracleArray) {
            try {
                OracleArray target = (OracleArray)closeable;
                target.free();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static <T> void close(T ... closeables) {
        for (T closeable : closeables) {
            Closeables.close(closeable);
        }
    }

    public static InputStream alsoClose(InputStream inputStream, final Object ... dependents) {
        return new FilterInputStream(inputStream){

            @Override
            public void close() throws IOException {
                Closeables.close(dependents);
            }
        };
    }
}

