/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.swagger;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.rest.RestMessages;
import oracle.dbtools.rest.model.RestHandlerParameter;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestTemplate;
import oracle.dbtools.rest.swagger.ParserBase;

public class OpenAPIParser
extends ParserBase {
    private static final String SUPPORTED_VERSION_PREFIX = "3.0";

    @Override
    public RestModule read(JsonObject root) {
        RestModule module = null;
        if (this.isValidVersion(root)) {
            module = new RestModule();
            module.setName(this.getModuleName(root));
            module.setURIPrefix(this.getModuleBasePath(root));
            module.setTemplates(this.getTemplates(root));
            module.setPublished(true);
            module.setPaginationSize(25L);
            module.setComments(this.getModuleComments(root));
        }
        return module;
    }

    @Override
    protected String getModuleBasePath(JsonObject object) {
        JsonArray servers = object.getJsonArray("servers");
        JsonObject firstServer = (JsonObject)servers.get(0);
        String basePath = firstServer.getString("url");
        int lastSlash = basePath.lastIndexOf("/");
        int length = basePath.length();
        if (lastSlash == basePath.length() - 1 && length > 2) {
            lastSlash = basePath.substring(0, length - 1).lastIndexOf("/");
        }
        return basePath.substring(lastSlash + 1, length);
    }

    @Override
    protected String getModuleComments(JsonObject root) {
        StringBuilder comments = new StringBuilder();
        JsonObject info = this.getOptionalProperty("info", root);
        if (info != null && info.containsKey((Object)"title")) {
            String title = info.getString("title");
            comments.append(title);
        }
        return comments.toString();
    }

    @Override
    protected String getModuleName(JsonObject node) {
        String basePath = this.getModuleBasePath(node);
        if (basePath.startsWith("/") && basePath.length() > 1) {
            basePath = basePath.substring(1);
        }
        if (basePath.endsWith("/") && basePath.length() > 1) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        return basePath.replace("/", "_");
    }

    @Override
    protected List<RestTemplate> getTemplates(JsonObject rootNode) {
        ArrayList<RestTemplate> templates = new ArrayList<RestTemplate>();
        JsonObject pathsObject = rootNode.getJsonObject("paths");
        for (String property : pathsObject.keySet()) {
            JsonObject templateObject = pathsObject.getJsonObject(property);
            RestTemplate template = new RestTemplate();
            template.setURIPattern(this.transformURIParameters(property));
            template.setPriority(1);
            template.setResourceHandlers(this.getHandlers(templateObject));
            template.setEntityTag("HASH");
            template.setComments("");
            templates.add(template);
        }
        return templates;
    }

    @Override
    protected List<RestHandlerParameter> getParameters(JsonObject object, String method) {
        ArrayList<RestHandlerParameter> parameters = new ArrayList<RestHandlerParameter>();
        JsonArray array = object.getJsonArray("parameters");
        if (array != null) {
            for (JsonObject jsonParameter : array.getValuesAs(JsonObject.class)) {
                String name = this.getOptionalStringProperty("name", jsonParameter);
                String in = this.getOptionalStringProperty("in", jsonParameter);
                JsonObject schema = this.getOptionalProperty("schema", jsonParameter);
                String type = null;
                String format = null;
                String reference = null;
                if (schema != null) {
                    type = this.getOptionalStringProperty("type", schema);
                    format = this.getOptionalStringProperty("format", schema);
                    reference = this.getOptionalStringProperty("$ref", schema);
                }
                if (name == null || "".equals(name)) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, RestMessages.format("SWAGGER_PROPERTY_EMPTY", "name", name));
                }
                if (in == null || "".equals(in)) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, RestMessages.format("SWAGGER_PROPERTY_EMPTY", "in", name));
                }
                RestHandlerParameter param = new RestHandlerParameter();
                param.setName(name);
                param.setBindVariable(name);
                param.setDataType(this.transformSwaggerType(type, format));
                param.setComments("");
                String sourceType = this.transformSwaggerIN(in);
                if ("implicit".equals(sourceType)) {
                    param.setComments("implicit");
                } else {
                    param.setSourceType(sourceType);
                    param.setAccessMethod("IN");
                }
                if (reference != null) continue;
                parameters.add(param);
            }
        }
        this.addDefaultOUTParameters(parameters, method);
        return parameters;
    }

    @Override
    protected boolean isValidVersion(JsonObject node) {
        String version = node.getString("openapi");
        return version.startsWith(SUPPORTED_VERSION_PREFIX);
    }
}

