/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import oracle.dbtools.core.jdbc.tns.TNSNames;
import oracle.dbtools.core.jdbc.tns.TnsLocation;
import oracle.dbtools.core.system.SystemContext;
import oracle.dbtools.raptor.utils.WindowsRegistry;

public class Tns {
    private static final String ORACLE_REGISTRY_KEY = "SOFTWARE\\ORACLE";
    public static final String ORACLE_HOME = "ORACLE_HOME";
    public static final String TNS_ADMIN = "TNS_ADMIN";
    private static final TnsLocation.Resolver TNS_ADMIN_REGISTRY = RegistryResolver.builder().name("TNS_ADMIN").path("SOFTWARE\\ORACLE").build();
    private static final TnsLocation.Resolver ORACLE_HOME_REGISTRY = RegistryResolver.builder().name("ORACLE_HOME").path("SOFTWARE\\ORACLE").relativePath("network", "admin").build();
    private static final List<TnsLocation.Resolver> REGISTRY_RESOLVERS = List.of(TNS_ADMIN_REGISTRY, ORACLE_HOME_REGISTRY);
    private static final Tns GLOBAL = Tns.builder().systemContext(SystemContext.global()).build();
    private final TnsLocation tnsLocation;

    private Tns(Builder builder) {
        this.tnsLocation = builder.tnsLocation;
    }

    public static void main(String ... args) throws Exception {
        PrintStream out = System.out;
        Tns tns = Tns.global();
        Path folder = tns.folder();
        Path file = tns.file();
        Map<String, Path> candidates = tns.candidates();
        TNSNames tnsNames = tns.read();
        if (folder == null) {
            out.println("No TNS configuration found");
        } else {
            out.println("TNS Configuration");
            out.println("=================");
            tnsNames.nsNames().forEach(name -> out.println(name + ": " + tnsNames.getTNSEntry(name).getConnectionDescriptor()));
            out.println();
            out.println("TNS Chosen Location");
            out.println("===================");
            out.println("TNS folder: " + String.valueOf(folder));
            out.println("TNS file  : " + String.valueOf(file));
            out.println();
            out.println("TNS Search Locations");
            out.println("====================");
            candidates.forEach((name, location) -> out.println(name + ": " + String.valueOf(location)));
            out.println();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Tns global() {
        return GLOBAL;
    }

    public Builder modify() {
        return Tns.builder().tnsLocation(this.tnsLocation);
    }

    public Path folder() {
        return this.tnsLocation.folder();
    }

    public Path file() {
        return this.tnsLocation.file();
    }

    public Map<String, Path> candidates() {
        return this.tnsLocation.candidates();
    }

    public TNSNames read(Path path) throws IOException {
        Path resolved = this.tnsLocation.file(path);
        if (resolved == null) {
            return null;
        }
        try (InputStream content = Files.newInputStream(resolved, new OpenOption[0]);){
            TNSNames tNSNames = this.read(content);
            return tNSNames;
        }
    }

    public TNSNames read(InputStream content) throws IOException {
        return TNSNames.read((InputStream)content);
    }

    public TNSNames read() throws IOException {
        Path folder = this.folder();
        if (folder == null) {
            return null;
        }
        return this.read(this.folder());
    }

    public static List<TnsLocation.Resolver> registryResolvers() {
        return REGISTRY_RESOLVERS;
    }

    public static final class Builder {
        private TnsLocation tnsLocation;

        private Builder() {
        }

        public Builder systemContext(SystemContext systemContext) {
            TnsLocation tnsLocation = TnsLocation.of((SystemContext)systemContext);
            TnsLocation withRegistryTnsResolver = tnsLocation.modify().resolvers(Tns.registryResolvers()).build();
            return this.tnsLocation(withRegistryTnsResolver);
        }

        public Builder tnsLocation(TnsLocation tnsLocation) {
            this.tnsLocation = tnsLocation;
            return this;
        }

        public Tns build() {
            return new Tns(this);
        }
    }

    static class RegistryResolver
    extends TnsLocation.Resolver.Base {
        private final WindowsRegistry.Node node;
        private final String[] relativePath;

        private RegistryResolver(Builder builder) {
            super((CharSequence)builder.name);
            this.node = builder.node;
            this.relativePath = builder.relativePath;
        }

        public static Builder builder() {
            return new Builder();
        }

        private boolean isWindows(SystemContext systemContext) {
            FileSystem fileSystem = systemContext.fileSystem();
            return fileSystem != null && "\\".equals(fileSystem.getSeparator());
        }

        private Path pathOf(SystemContext systemContext, WindowsRegistry.Node node, String key, String ... relativePath) {
            Path path;
            String location = node.textValue(key);
            if (location != null && TnsLocation.hasTns((Path)(path = systemContext.getPath(location, relativePath)))) {
                return path;
            }
            return null;
        }

        protected Stream<Path> searchLocations(SystemContext systemContext) {
            if (this.isWindows(systemContext)) {
                ArrayList<Path> matches = new ArrayList<Path>();
                Set<String> children = this.node.keys();
                for (String childKey : children) {
                    WindowsRegistry.Node child = this.node.node(childKey);
                    Path path = this.pathOf(systemContext, child, this.name(), this.relativePath);
                    if (path == null) continue;
                    matches.add(path);
                }
                return matches.stream();
            }
            return Stream.empty();
        }

        public static final class Builder {
            private WindowsRegistry registry = WindowsRegistry.instance();
            private WindowsRegistry.KeyHandle keyHandle = WindowsRegistry.StandardKeyHandle.LOCAL_MACHINE;
            private WindowsRegistry.Node node;
            private String name = "ORACLE_HOME";
            private String[] relativePath = new String[0];

            private Builder() {
            }

            public Builder keyHandle(WindowsRegistry.KeyHandle keyHandle) {
                this.keyHandle = keyHandle;
                return this;
            }

            public Builder path(CharSequence path) {
                WindowsRegistry.Node node = this.registry.node(this.keyHandle, path.toString());
                return this.node(node);
            }

            public Builder relativePath(String ... relativePath) {
                this.relativePath = relativePath;
                return this;
            }

            public Builder registry(WindowsRegistry registry) {
                this.registry = registry;
                return this;
            }

            public Builder node(WindowsRegistry.Node node) {
                this.node = node;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public RegistryResolver build() {
                return new RegistryResolver(this);
            }
        }
    }
}

