/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.transformer.basic;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.Transformer;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.basic.Messages;

public class PrimitiveTransformers {
    private static final Map<Class<?>, Transformer<String, ?>> TRANSFORMER_MAP = new HashMap();

    public static <T> Transformer<String, T> get(Class<T> cls) {
        Transformer<String, ?> result = TRANSFORMER_MAP.get(cls);
        if (result == null) {
            throw new IllegalArgumentException(cls.getSimpleName());
        }
        return result;
    }

    private PrimitiveTransformers() {
    }

    static {
        TRANSFORMER_MAP.put(Boolean.class, (rawValue, context, environment) -> {
            Boolean value = null;
            if ("true".equalsIgnoreCase((String)rawValue) || "yes".equalsIgnoreCase((String)rawValue) || "y".equalsIgnoreCase((String)rawValue)) {
                value = true;
            } else if ("false".equalsIgnoreCase((String)rawValue) || "no".equalsIgnoreCase((String)rawValue) || "n".equalsIgnoreCase((String)rawValue)) {
                value = false;
            } else {
                context.addError(Messages.getString(Messages.Key.FORMAT_ERROR, environment.getLocale()));
            }
            return value;
        });
        TRANSFORMER_MAP.put(String.class, (rawValue, context, environment) -> rawValue);
        TRANSFORMER_MAP.put(Byte.class, (rawValue, context, environment) -> {
            Byte value = null;
            try {
                value = Byte.valueOf(rawValue);
            }
            catch (NumberFormatException ex) {
                context.addError(Messages.getString(Messages.Key.FORMAT_ERROR, environment.getLocale()));
            }
            return value;
        });
        TRANSFORMER_MAP.put(Short.class, (rawValue, context, environment) -> {
            Short value = null;
            try {
                value = Short.valueOf(rawValue);
            }
            catch (NumberFormatException ex) {
                context.addError(Messages.getString(Messages.Key.FORMAT_ERROR, environment.getLocale()));
            }
            return value;
        });
        TRANSFORMER_MAP.put(Integer.class, (rawValue, context, environment) -> {
            Integer value = null;
            try {
                value = Integer.valueOf(rawValue);
            }
            catch (NumberFormatException ex) {
                context.addError(Messages.getString(Messages.Key.FORMAT_ERROR, environment.getLocale()));
            }
            return value;
        });
        TRANSFORMER_MAP.put(Long.class, (rawValue, context, environment) -> {
            Long value = null;
            try {
                value = Long.valueOf(rawValue);
            }
            catch (NumberFormatException ex) {
                context.addError(Messages.getString(Messages.Key.FORMAT_ERROR, environment.getLocale()));
            }
            return value;
        });
        TRANSFORMER_MAP.put(Float.class, (rawValue, context, environment) -> {
            Float value = null;
            try {
                value = Float.valueOf(rawValue);
            }
            catch (NumberFormatException ex) {
                context.addError(Messages.getString(Messages.Key.FORMAT_ERROR, environment.getLocale()));
            }
            return value;
        });
        TRANSFORMER_MAP.put(Double.class, (rawValue, context, environment) -> {
            Double value = null;
            try {
                value = Double.valueOf(rawValue);
            }
            catch (NumberFormatException ex) {
                context.addError(Messages.getString(Messages.Key.FORMAT_ERROR, environment.getLocale()));
            }
            return value;
        });
        TRANSFORMER_MAP.put(Character.class, (rawValue, context, environment) -> {
            Character value = null;
            if (rawValue.length() == 1) {
                value = Character.valueOf(rawValue.charAt(0));
            } else {
                context.addError(Messages.getString(Messages.Key.FORMAT_ERROR, environment.getLocale()));
            }
            return value;
        });
    }
}

