/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Syntax;

public class Synonyms {
    private final String name;
    private final List<String> abbrevs;
    private final String nameRoot;
    private final Set<String> nameSynonyms;

    public boolean matches(String token) {
        return this.nameSynonyms.contains(token.toUpperCase());
    }

    public boolean startsWith(String token) {
        String upperToken = token.toUpperCase();
        for (String nameSynonym : this.nameSynonyms) {
            if (!nameSynonym.startsWith(upperToken)) continue;
            return true;
        }
        return false;
    }

    public Set<String> get() {
        return this.nameSynonyms;
    }

    public String getPrimaryName() {
        return this.name;
    }

    public List<String> getAbbrevs() {
        return this.abbrevs;
    }

    public Optional<String> getNameRoot() {
        return Optional.ofNullable(this.nameRoot);
    }

    public Syntax getNameSyntax() {
        boolean bracketIfNested = false;
        StringBuilder buff = new StringBuilder();
        if (this.nameRoot != null) {
            buff.append(this.nameRoot).append("[").append(this.name.substring(this.nameRoot.length())).append("]");
        } else {
            buff.append(this.name);
        }
        if (!this.abbrevs.isEmpty()) {
            bracketIfNested = true;
            for (String abbrev : this.abbrevs) {
                buff.append('|').append(abbrev);
            }
        }
        return new Syntax(buff.toString().toLowerCase(), bracketIfNested);
    }

    Synonyms(String name, String nameRoot, List<String> abbrevs) {
        this.nameRoot = nameRoot;
        this.name = name;
        this.abbrevs = abbrevs;
        this.nameSynonyms = Collections.unmodifiableSet(this.calculateNameSynonyms());
    }

    private Set<String> calculateNameSynonyms() {
        HashSet<String> result = new HashSet<String>();
        result.add(this.name);
        if (this.nameRoot != null) {
            for (int c = this.nameRoot.length(); c < this.name.length(); ++c) {
                result.add(this.name.substring(0, c));
            }
        }
        for (String abbreviation : this.abbrevs) {
            result.add(abbreviation);
        }
        return result;
    }
}

