/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import oracle.dbtools.raptor.newscriptrunner.util.help.AbstractPageAssembler;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpContainer;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpStringExtension;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpStrings;
import oracle.dbtools.raptor.newscriptrunner.util.help.PageAssembler;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Grammar;
import oracle.dbtools.raptor.newscriptrunner.util.parser.HelpMessages;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamedItem;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Option;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parameter;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Rule;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

public class CommandPageAssemblers
implements Iterable<PageAssembler> {
    private final Type rootType;
    private final Set<Type> excludedTypes;
    private List<PageAssembler> pages;

    public CommandPageAssemblers(Type rootType, Type ... excludeTypes) {
        this.rootType = rootType;
        this.excludedTypes = new HashSet<Type>(Arrays.asList(excludeTypes));
    }

    @Override
    public Iterator<PageAssembler> iterator() {
        return this.getPages().iterator();
    }

    private List<PageAssembler> getPages() {
        if (this.pages == null) {
            this.pages = new ArrayList<PageAssembler>();
            this.addPages(Collections.singletonList(this.rootType), this.pages);
        }
        return this.pages;
    }

    private void addPages(List<Type> typePath, List<PageAssembler> helpAssemblers) {
        Type type = typePath.get(typePath.size() - 1);
        if (type.getHelpId().isPresent() && !this.excludedTypes.contains(type)) {
            helpAssemblers.add(new CommandPageAssembler(typePath));
            helpAssemblers.add(new ExamplesPageAssembler(typePath));
            helpAssemblers.add(new SyntaxPageAssembler(typePath));
        }
        for (Type nestedType : type.getNestedTypes()) {
            ArrayList<Type> nestedTypePath = new ArrayList<Type>(typePath);
            nestedTypePath.add(nestedType);
            this.addPages(nestedTypePath, helpAssemblers);
        }
    }

    private static <T extends NamedItem> Collection<T> sortItemList(boolean alphaSort, Collection<T> items) {
        return alphaSort ? (Collection)items.stream().sorted((left, right) -> left.getName().compareTo(right.getName())).collect(Collectors.toList()) : items;
    }

    private static void appendGrammarRules(Grammar<?> grammar, StringBuilder buff) {
        boolean first = true;
        for (Rule rule : grammar.getRules()) {
            if (rule.isFlattened()) continue;
            if (first) {
                buff.append(' ');
                first = false;
            } else {
                buff.append("\n\t\t");
            }
            buff.append(rule.asBNF());
        }
    }

    private static class CommandPageAssembler
    extends AbstractPageAssembler {
        private final List<Type> typePath;

        private CommandPageAssembler(List<Type> typePath) {
            this.typePath = typePath;
        }

        @Override
        public List<HelpContainer> getHelpContainers() {
            ArrayList<HelpContainer> helpContainers = new ArrayList<HelpContainer>();
            int t = this.typePath.size();
            while (t-- > 0) {
                helpContainers.addAll(this.typePath.get(t).getHelpContainers());
            }
            return helpContainers;
        }

        @Override
        public String getPagePath() {
            StringBuilder buff = new StringBuilder();
            for (Type type : this.typePath) {
                if (buff.length() > 0) {
                    buff.append('/');
                }
                buff.append(type.getName());
            }
            return buff.toString();
        }

        @Override
        protected String getRawPage(boolean alphaSort, Locale locale, HelpStrings helpStrings, List<String> moreHelpTopics) {
            Type type = this.typePath.get(this.typePath.size() - 1);
            StringBuilder buff = new StringBuilder();
            buff.append(helpStrings.get(type.getHelpId().get()));
            if (!type.isBase()) {
                this.appendUsage(buff, locale);
            }
            this.appendGrammarItems(alphaSort, helpStrings, buff);
            if (!type.getNestedTypes().isEmpty()) {
                this.appendNestedTypes(alphaSort, helpStrings, buff, locale);
            }
            if (!type.getOptions().isEmpty()) {
                this.appendOptions(alphaSort, helpStrings, buff, locale);
            }
            if (!type.getParameters().isEmpty()) {
                this.appendParameters(alphaSort, helpStrings, buff, locale);
            }
            if (!moreHelpTopics.isEmpty()) {
                this.appendMoreTopics(alphaSort, moreHelpTopics, buff, locale);
            }
            return buff.toString();
        }

        private void appendUsage(StringBuilder buff, Locale locale) {
            Grammar<?> grammar;
            buff.append("\n\n").append(HelpMessages.getString(HelpMessages.Key.USAGE_TITLE, locale)).append('\n');
            boolean first = true;
            for (Type type : this.typePath) {
                if (first) {
                    buff.append("\t");
                } else {
                    buff.append(" ");
                }
                buff.append('$').append(type.getSyntax().get()).append('$');
            }
            Type type = this.typePath.get(this.typePath.size() - 1);
            if (!type.getNestedTypes().isEmpty()) {
                buff.append(" {SUBCOMMAND}");
            }
            if (!type.getOptions().isEmpty()) {
                buff.append(" {OPTIONS}");
            }
            if (!type.getParameters().isEmpty()) {
                buff.append(" {PARAMETERS}");
            }
            if ((grammar = type.getGrammar()) != null) {
                CommandPageAssemblers.appendGrammarRules(grammar, buff);
            }
        }

        private void appendGrammarItems(boolean alphaSort, HelpStrings helpStrings, StringBuilder buff) {
            Type type = this.typePath.get(this.typePath.size() - 1);
            Grammar<?> grammar = type.getGrammar();
            if (grammar != null) {
                AbstractMap helpIdMap = alphaSort ? new TreeMap() : new LinkedHashMap();
                for (Rule rule : grammar.getRules()) {
                    Optional<String> helpIdOptional = rule.getHelpId();
                    if (helpIdOptional.isPresent()) {
                        helpIdMap.put(rule.getSyntax().get(), helpIdOptional.get());
                    }
                    rule.getExpression().visitNamedExpressions(expression -> {
                        Optional<String> helpIdOptional = expression.getHelpId();
                        if (helpIdOptional.isPresent()) {
                            helpIdMap.put(expression.getSyntax().get(), helpIdOptional.get());
                        }
                    });
                }
                for (String syntax : helpIdMap.keySet()) {
                    buff.append("\n\n\t$").append(syntax).append("$");
                    buff.append("\n\t").append(helpStrings.get(HelpPagesBuilder.Extensions.SUMMARY, (String)helpIdMap.get(syntax)));
                }
            }
        }

        private void appendNestedTypes(boolean alphaSort, HelpStrings helpStrings, StringBuilder buff, Locale locale) {
            Type type = this.typePath.get(this.typePath.size() - 1);
            buff.append("\n\n").append(HelpMessages.getString(HelpMessages.Key.SUBCOMMANDS_TITLE, locale));
            boolean first = true;
            for (Type nestedType : CommandPageAssemblers.sortItemList(alphaSort, type.getNestedTypes())) {
                if (!nestedType.getHelpId().isPresent()) continue;
                if (first) {
                    first = false;
                } else {
                    buff.append('\n');
                }
                buff.append("\n\t$").append(nestedType.getSyntax().get().replace("|", "$|$")).append('$');
                buff.append("\n\t").append(helpStrings.get(HelpPagesBuilder.Extensions.SUMMARY, nestedType.getHelpId().get()));
            }
        }

        private void appendOptions(boolean alphaSort, HelpStrings helpStrings, StringBuilder buff, Locale locale) {
            Type type = this.typePath.get(this.typePath.size() - 1);
            buff.append("\n\n").append(HelpMessages.getString(HelpMessages.Key.OPTIONS_TITLE, locale));
            boolean first = true;
            for (Option<?> option : CommandPageAssemblers.sortItemList(alphaSort, type.getOptions())) {
                if (!option.getHelpId().isPresent()) continue;
                if (first) {
                    first = false;
                } else {
                    buff.append('\n');
                }
                buff.append("\n\t$").append(option.getSyntax().get().replace("|", "$|$-")).append('$');
                if (!option.isFlag()) {
                    buff.append(" <").append(option.getName().toLowerCase()).append(">");
                }
                if (option.getTransformer() != null && option.getTransformer().getFormat(locale) != null) {
                    buff.append(" {").append(option.getTransformer().getFormat(locale)).append("}");
                }
                if (!option.isFlag() && option.getDefaultValue() != null) {
                    buff.append(" (").append(option.getDefaultValueAsString()).append(")");
                }
                if (option.isRequired()) {
                    buff.append(" [").append(HelpMessages.getString(HelpMessages.Key.REQUIRED, locale)).append("]");
                }
                buff.append("\n\t").append(helpStrings.get(HelpPagesBuilder.Extensions.SUMMARY, option.getHelpId().get()).replace("\\n", "\\\\n").replace("\n", "\\n"));
            }
        }

        private void appendParameters(boolean alphaSort, HelpStrings helpStrings, StringBuilder buff, Locale locale) {
            Type type = this.typePath.get(this.typePath.size() - 1);
            buff.append("\n\n").append(HelpMessages.getString(HelpMessages.Key.PARAMETERS_TITLE, locale));
            boolean first = true;
            for (Parameter<?> parameter : CommandPageAssemblers.sortItemList(alphaSort, type.getParameters())) {
                if (!parameter.getHelpId().isPresent()) continue;
                if (first) {
                    first = false;
                } else {
                    buff.append('\n');
                }
                buff.append("\n\t$").append(parameter.getSyntax().get()).append('$');
                if (parameter.getTransformer() != null && parameter.getTransformer().getFormat(locale) != null) {
                    buff.append(" {").append(parameter.getTransformer().getFormat(locale)).append("}");
                }
                if (parameter.getDefaultValue() != null) {
                    buff.append(" (").append(parameter.getDefaultValue()).append(")");
                }
                if (parameter.isRequired()) {
                    buff.append(" [").append(HelpMessages.getString(HelpMessages.Key.REQUIRED, locale)).append("]");
                }
                buff.append("\n\t").append(helpStrings.get(HelpPagesBuilder.Extensions.SUMMARY, parameter.getHelpId().get()).replace("\\n", "\\\\n").replace("\n", "\\n"));
            }
        }

        private void appendMoreTopics(boolean alphaSort, List<String> moreHelpCommands, StringBuilder buff, Locale locale) {
            buff.append("\n\n").append(HelpMessages.getString(HelpMessages.Key.MORE_TITLE, locale));
            for (String moreHelpCommand : this.sortStringList(alphaSort, moreHelpCommands)) {
                buff.append("\n\t").append(moreHelpCommand);
            }
        }

        private List<String> sortStringList(boolean alphaSort, List<String> items) {
            return alphaSort ? items.stream().sorted((left, right) -> left.compareTo((String)right)).collect(Collectors.toList()) : items;
        }
    }

    private static class ExamplesPageAssembler
    extends AbstractPageAssembler {
        private final List<Type> typePath;

        private ExamplesPageAssembler(List<Type> typePath) {
            this.typePath = typePath;
        }

        @Override
        public String getPagePath() {
            StringBuilder buff = new StringBuilder();
            for (Type type : this.typePath) {
                if (buff.length() > 0) {
                    buff.append('/');
                }
                buff.append(type.getName());
            }
            buff.append("/EXAMPLES");
            return buff.toString();
        }

        @Override
        protected String getRawPage(boolean alphaSort, Locale locale, HelpStrings helpStrings, List<String> moreHelpTopics) {
            Type type = this.typePath.get(this.typePath.size() - 1);
            StringBuilder buff = new StringBuilder();
            buff.append(helpStrings.get(Extensions.EXAMPLES, type.getHelpId().get()));
            return buff.toString();
        }
    }

    private static class SyntaxPageAssembler
    extends AbstractPageAssembler {
        private final List<Type> typePath;

        private SyntaxPageAssembler(List<Type> typePath) {
            this.typePath = typePath;
        }

        @Override
        public String getPagePath() {
            StringBuilder buff = new StringBuilder();
            for (Type type : this.typePath) {
                if (buff.length() > 0) {
                    buff.append('/');
                }
                buff.append(type.getName());
            }
            buff.append("/SYNTAX");
            return buff.toString();
        }

        @Override
        protected String getRawPage(boolean alphaSort, Locale locale, HelpStrings helpStrings, List<String> moreHelpTopics) {
            StringBuilder buff = new StringBuilder();
            SyntaxPageAssembler.appendSyntax(this.typePath, alphaSort, buff, locale);
            return buff.toString();
        }

        private static void appendSyntax(List<Type> typePath, boolean alphaSort, StringBuilder buff, Locale locale) {
            Grammar<?> grammar;
            boolean first = true;
            for (Type type : typePath) {
                if (first) {
                    buff.append("\t");
                    first = false;
                } else {
                    buff.append(" ");
                }
                buff.append('$').append(type.getSyntax().get().replace("|", "$|$")).append('$');
            }
            Type type = typePath.get(typePath.size() - 1);
            if (!type.getNestedTypes().isEmpty()) {
                if (!type.isBase()) {
                    buff.append(" [");
                }
                boolean firstType = true;
                for (Type nestedType : CommandPageAssemblers.sortItemList(alphaSort, type.getNestedTypes())) {
                    if (firstType) {
                        firstType = false;
                    } else {
                        buff.append(" |");
                    }
                    buff.append(" ");
                    if (nestedType.getSyntax().get().contains("|")) {
                        buff.append("[");
                    }
                    buff.append("$").append(nestedType.getSyntax().get().replace("|", "$|$")).append("$");
                    if (!nestedType.getSyntax().get().contains("|")) continue;
                    buff.append("]");
                }
                if (!type.isBase()) {
                    buff.append(" ] | [");
                }
            }
            if (!type.getOptions().isEmpty()) {
                for (Option<?> option : CommandPageAssemblers.sortItemList(alphaSort, type.getOptions())) {
                    buff.append(" ");
                    if (!option.isRequired()) {
                        buff.append("[");
                    }
                    buff.append("$").append(option.getSyntax().get().replace("|", "$|$-")).append("$");
                    if (!option.isFlag()) {
                        buff.append(" <").append(option.getName().toLowerCase()).append(">");
                    }
                    if (option.isRequired()) continue;
                    buff.append("]");
                }
            }
            if (!type.getParameters().isEmpty()) {
                for (Parameter<?> parameter : CommandPageAssemblers.sortItemList(alphaSort, type.getParameters())) {
                    buff.append(" ");
                    if (!parameter.isRequired()) {
                        buff.append("[");
                    }
                    buff.append("<").append(parameter.getName().toLowerCase()).append(">");
                    if (parameter.isRequired()) continue;
                    buff.append("]");
                }
            }
            if ((grammar = type.getGrammar()) != null) {
                CommandPageAssemblers.appendGrammarRules(grammar, buff);
            }
            if (!type.getNestedTypes().isEmpty() && !type.isBase()) {
                buff.append(" ]");
            }
        }
    }

    public static enum Extensions implements HelpStringExtension
    {
        EXAMPLES{

            @Override
            public String getDefault() {
                return "EX";
            }
        };

    }
}

