/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Optional;
import oracle.dbtools.core.connections.folder.Folder;
import oracle.dbtools.core.connections.folder.FolderOperationException;
import oracle.dbtools.core.connections.folder.FolderSerializationException;
import oracle.dbtools.core.connections.folder.utils.FolderUtils;
import oracle.dbtools.db.LockManager;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.PropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.save.ConnectionsFolderManager;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.NamedConnectionProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.dbtools.raptor.newscriptrunner.commands.show.Messages;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;
import oracle.jdbc.OracleConnection;

@Restricted(level=Restricted.Level.R4)
public class ShowConnection
implements IShowCommand,
IShowPrefixNameNewline {
    private static final String[] SHOWCONNECTION = new String[]{"connection", "conn"};

    @Override
    public String[] getShowAliases() {
        return SHOWCONNECTION;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        Connection currConn = ctx.getCurrentConnection();
        if (currConn == null || this.isOracleConnection(currConn) || this.isRestConnection(currConn)) {
            return this.doShowConnection(conn, ctx, cmd, false);
        }
        if (currConn.getClass().getName().equals("oracle.nucleo.jdbc.impl.NucleoConnectionImpl")) {
            return this.doShowConnection(conn, ctx, cmd, true);
        }
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doShowConnection(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, boolean isNucleo) {
        StringBuffer sb;
        block13: {
            sb = new StringBuffer();
            try {
                if (conn == null || !LockManager.lock(conn)) break block13;
                ConnectionContext connectionContext = ctx.getService(ConnectionContext.class);
                ConnectorType connectorType = connectionContext.getCurrentConnectorType();
                PropertyValues propertyValues = connectionContext.getCurrentPropertyValues();
                ctx.write("COMMAND_PROPERTIES:\n ");
                ctx.write(propertyValues.asStringFor(connectorType, "\n ") + "\n");
                String connName = propertyValues.getValueOf(NamedConnectionProperty.NAME);
                if (connName != null) {
                    try {
                        Folder root = new ConnectionsFolderManager().getRootFolder();
                        Optional path = FolderUtils.findConnectionPath((Folder)root, (String)connName);
                        path.ifPresent(p -> ctx.writeln(" path: " + p));
                    }
                    catch (FolderOperationException | FolderSerializationException e) {
                        sb.append("\n").append(MessageFormat.format(Messages.getString("CONNECTION_FOLDER_ERROR"), e.getLocalizedMessage())).append("\n");
                    }
                }
                try {
                    DatabaseMetaData dbmd = conn.getMetaData();
                    String url = null;
                    String user = null;
                    if (!isNucleo) {
                        url = dbmd.getURL();
                        user = dbmd.getUserName();
                    }
                    String role = ctx.getPrivilege(ScriptRunnerContext.SqlplusVariable._PRIVILEGE.toString());
                    String conid = ctx.getConnectionID(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString());
                    String version = dbmd.getDatabaseProductVersion();
                    ctx.write("CONNECTION:\n " + user + "@" + url + " " + role + "\n");
                    if (conid != null && !conid.equals("")) {
                        ctx.write("CONNECTION_IDENTIFIER:\n " + conid + "\n");
                    }
                    if (!(version == null || version.equals("") || ctx.getProperty("script.runner.PRELIM_AUTH") != null && Boolean.valueOf(ctx.getProperty("script.runner.PRELIM_AUTH").equals(Boolean.TRUE)).booleanValue())) {
                        ctx.write("CONNECTION_DB_VERSION:\n " + version.replace("\n", "\n ") + "\n");
                    }
                    Boolean nologBool = (Boolean)ctx.getProperty("script.runner.sqlplus.nolog");
                    String nologReport = "false";
                    if (nologBool != null && nologBool.equals(Boolean.TRUE)) {
                        nologReport = "true";
                    }
                    ctx.write("NOLOG:\n " + nologReport);
                    Boolean prelimAuth = (Boolean)ctx.getProperty("script.runner.PRELIM_AUTH");
                    String prelimAuthReport = "false";
                    if (prelimAuth != null && prelimAuth.equals(Boolean.TRUE)) {
                        prelimAuthReport = "true";
                    }
                    ctx.write("\nPRELIMAUTH:\n " + prelimAuthReport + "\n");
                }
                finally {
                    LockManager.unlock(conn);
                }
            }
            catch (SQLException e) {
                sb.append("\nUnable to gather information\n");
            }
        }
        ctx.write(sb.toString());
        return true;
    }

    private boolean isOracleConnection(Connection conn) {
        return conn instanceof OracleConnection;
    }

    private boolean isRestConnection(Connection conn) {
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            if (metaData != null) {
                String driverName = metaData.getDriverName();
                return "Oracle REST JDBC driver".equals(driverName);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }
}

