/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.R4)
public class ShowAutocommit
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWAUTOCOMMIT = new String[]{"auto", "autoc", "autoco", "autocom", "autocomm", "autocommi", "autocommit"};

    @Override
    public String[] getShowAliases() {
        return SHOWAUTOCOMMIT;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return this.doShowAutocommit(conn, ctx, cmd);
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowAutocommit(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        Long autocommit = (Long)ctx.getProperty("script.runner.autocommit.setting");
        if (autocommit == 1L || autocommit == ScriptRunnerContext.AUTOCOMMITON) {
            ctx.write("autocommit IMMEDIATE\n");
        } else if (autocommit == ScriptRunnerContext.AUTOCOMMITOFF || autocommit.equals(new Long(0L))) {
            ctx.write("autocommit OFF\n");
        } else {
            ctx.write(MessageFormat.format(Messages.getString("SHOWAUTOCOMMITEVERYN"), "AUTOCOMMIT ON", autocommit));
        }
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        Long autocommit = (Long)ctx.getProperty("script.runner.autocommit.setting");
        if (autocommit == 1L || autocommit == ScriptRunnerContext.AUTOCOMMITON) {
            return StoreRegistry.getCommand("autocommit", "ON");
        }
        if (autocommit == ScriptRunnerContext.AUTOCOMMITOFF || autocommit.equals(new Long(0L))) {
            return StoreRegistry.getCommand("autocommit", "OFF");
        }
        return StoreRegistry.getCommand("autocommit", String.valueOf(autocommit));
    }
}

