/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.sql.DataSource;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.core.jdbc.DataSourceBuilder;
import oracle.dbtools.core.jdbc.OracleDataSources;
import oracle.dbtools.core.jdbc.tns.TNSEntry;
import oracle.dbtools.core.jdbc.wallet.DatabaseToolsProperties;
import oracle.dbtools.core.jdbc.wallet.OracleWalletArchive;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.PropertyValues;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.ProxyProperty;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;
import oracle.dbtools.util.Logger;
import oracle.jdbc.datasource.OracleDataSource;

public class WalletValue {
    private OracleWalletArchive walletArchive;
    private final String walletLocation;
    private static final Pattern PORT_PATTERN = Pattern.compile("\\(\\s*PORT\\s*=\\s*([^\\s)]+)\\s*\\)");
    private static final Pattern HOST_PATTERN = Pattern.compile("\\(\\s*HOST\\s*=\\s*([^\\s)]+)\\s*\\)");

    public static WalletValue create(ScriptRunnerContext ctx, String walletLocation, InputStream contents, Consumer<String> errorConsumer) {
        OracleWalletArchive walletArchive;
        if (WalletValue.testJCE()) {
            try {
                walletArchive = OracleWalletArchive.read((InputStream)contents);
            }
            catch (IOException e) {
                errorConsumer.accept(MessageFormat.format(Messages.getString(Messages.Key.CLOUD_INVALID), walletLocation));
                return null;
            }
        } else {
            errorConsumer.accept(MessageFormat.format(Messages.getString(Messages.Key.JCE_NOT_INSTALLED), System.getProperty("java.home"), "http://www.oracle.com/technetwork/java/javase/downloads/jce8-download-2133166.html"));
            return null;
        }
        return new WalletValue(walletLocation, walletArchive);
    }

    public String toString() {
        return this.walletLocation;
    }

    public OracleWalletArchive getArchive() {
        return this.walletArchive;
    }

    public String getLocation() {
        return this.walletLocation;
    }

    public String getCloudServiceAlias(String connectDB) {
        if (this.walletArchive != null) {
            if (connectDB == null || connectDB.length() == 0) {
                return this.walletArchive.getDatabaseToolsProperties().serviceAlias();
            }
            String serviceAlias = connectDB;
            if (serviceAlias.startsWith("jdbc:oracle:thin:@")) {
                serviceAlias = serviceAlias.substring("jdbc:oracle:thin:@".length());
            }
            if (serviceAlias != null && serviceAlias.length() > 0 && !SQLPLUSUtil.hasUrlStub(serviceAlias) && this.walletArchive.getTNSNames().getTNSEntry(serviceAlias) != null) {
                return serviceAlias;
            }
        }
        return null;
    }

    public void configureDataSource(OracleDataSource datasource, String url, Properties filteredProps, PropertyValues propertyValues) throws SQLException {
        String user = (String)filteredProps.get("user");
        String password = (String)filteredProps.get("password");
        String serviceAlias = this.getCloudServiceAlias(url);
        if (this.walletArchive != null) {
            URI proxy = propertyValues.getValueOf(ProxyProperty.PROXY);
            if (proxy != null) {
                String nonProxyHosts = System.getProperty("dbtools.system_http_non_proxy_hosts");
                if (serviceAlias != null && nonProxyHosts != null && !nonProxyHosts.isEmpty()) {
                    HostPort hp = this.scanHostPort(this.walletArchive.getTNSNames().getTNSEntry(serviceAlias));
                    for (String host : nonProxyHosts.split("\\s*\\|\\s*")) {
                        if (!host.equals(hp.host)) continue;
                        proxy = null;
                        break;
                    }
                }
            } else if (serviceAlias != null) {
                proxy = this.determineProxy(this.scanHostPort(this.walletArchive.getTNSNames().getTNSEntry(serviceAlias)));
            }
            if (proxy != null) {
                DatabaseToolsProperties oldProperties = this.walletArchive.getDatabaseToolsProperties();
                DatabaseToolsProperties.Builder propBuilder = oldProperties.modify();
                propBuilder.httpsProxy(proxy);
                DatabaseToolsProperties newProperties = propBuilder.build();
                OracleWalletArchive.Builder archiveBuilder = this.walletArchive.modify();
                archiveBuilder.databaseToolsProperties(newProperties);
                this.walletArchive = archiveBuilder.build();
            }
            try {
                if (!this.walletArchive.isConfigurable()) {
                    throw new SQLException(MessageFormat.format(Messages.getString(Messages.Key.CLOUD_ARCHIVE_INVALID), this.walletLocation));
                }
                OracleDataSources.Builder builder = OracleDataSources.instance().builder();
                if (serviceAlias != null) {
                    builder.serviceAlias(serviceAlias);
                } else {
                    builder.serviceAlias("@");
                }
                this.walletArchive.configure((DataSourceBuilder)builder);
                builder.configure((DataSource)datasource);
                if (serviceAlias != null && serviceAlias.length() > 0) {
                    filteredProps.remove("oracle.net.tns_admin");
                    filteredProps.remove("oracle.net.wallet_location");
                    filteredProps.remove("oracle.net.ssl_server_dn_match");
                    filteredProps.putAll((Map<?, ?>)datasource.getConnectionProperties());
                    if (user != null && user.length() > 0) {
                        builder.user(user);
                    }
                    if (password != null && password.length() > 0) {
                        builder.password(password);
                    }
                }
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        if (serviceAlias == null || serviceAlias.length() == 0) {
            datasource.setURL(url);
        }
        datasource.setConnectionProperties(filteredProps);
    }

    private HostPort scanHostPort(TNSEntry entry) {
        String copy;
        Matcher matcher;
        String desc;
        String hostname = null;
        String port = null;
        if (entry != null && (desc = entry.getConnectionDescriptor()) != null && (matcher = HOST_PATTERN.matcher(copy = desc.toUpperCase())).find()) {
            hostname = desc.substring(matcher.start(1), matcher.end(1));
            matcher = PORT_PATTERN.matcher(copy);
            if (matcher.find()) {
                port = desc.substring(matcher.start(1), matcher.end(1));
            }
        }
        return new HostPort(hostname, port);
    }

    private URI determineProxy(HostPort hostPort) {
        URI proxy;
        block4: {
            proxy = null;
            if (ModelUtil.hasLength(hostPort.host) && ModelUtil.hasLength(hostPort.port)) {
                try {
                    URI uri = new URI("https://" + hostPort.host + ":" + hostPort.port);
                    ProxySelector ps = ProxySelector.getDefault();
                    List<Proxy> proxies = ps.select(uri);
                    if (proxies == null) break block4;
                    for (Proxy p : proxies) {
                        SocketAddress address;
                        if (p.type() != Proxy.Type.HTTP || !((address = p.address()) instanceof InetSocketAddress)) continue;
                        String proxyHost = ((InetSocketAddress)address).getHostString();
                        int proxyPort = ((InetSocketAddress)address).getPort();
                        if (proxyHost == null || proxyPort <= 0) continue;
                        proxy = URI.create("https://" + proxyHost + ":" + proxyPort);
                        break;
                    }
                }
                catch (URISyntaxException e) {
                    Logger.warn(WalletValue.class, e.getLocalizedMessage(), e);
                }
            }
        }
        return proxy;
    }

    private static boolean testJCE() {
        int maxKeySize = 0;
        try {
            maxKeySize = Cipher.getMaxAllowedKeyLength("AES");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return maxKeySize > 128;
    }

    private WalletValue(String walletLocation, OracleWalletArchive walletArchive) {
        this.walletLocation = walletLocation;
        this.walletArchive = walletArchive;
    }

    private class HostPort {
        String host;
        String port;

        HostPort(String host, String port) {
            this.host = host;
            this.port = port;
        }
    }
}

