/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.ICommandHistory;
import oracle.dbtools.raptor.newscriptrunner.Messages;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.AbstractConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.EditionProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.PasswordProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.RoleProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.StandardFormConnectorType;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.URLProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.UserProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.net.NetCommand;
import oracle.dbtools.raptor.nls.NLSLang;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;

public abstract class StandardFormConnector
extends AbstractConnector {
    protected StandardFormConnector(ConnectorArgs args) {
        super(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Connection connect() {
        Connection newConnection;
        ConnectionDetails cd;
        ArrayList<String> urlMessage;
        block40: {
            TextSecret passwd;
            Connection oldConnection = this.ctx.getCurrentConnection();
            urlMessage = new ArrayList<String>();
            cd = this.createConnectionsDetails();
            if (System.getProperty("dev.flag") == null && StandardFormConnectorType.isNotEmpty(passwd = cd.getConnectPassword())) {
                String localSql = this.cmd.getSql().trim();
                String redactedLocalSql = this.redact(localSql, (String)passwd.map(String::new));
                ICommandHistory history = (ICommandHistory)this.ctx.getProperty("sqlcl.ihistorycommand");
                if (this.ctx.getTopLevel() && history != null && !history.isDisabled()) {
                    this.ctx.getProperties().put("sqlcl.history.modified.line", redactedLocalSql);
                }
            }
            if (cd.getCallUsage()) {
                Boolean inSQLCLLogin = (Boolean)this.ctx.getProperty("sqlcl.script.ininitialconnect");
                SQLPLUSUtil.report(this.ctx, "SP2-0306: Invalid option.");
                Object toReport = "";
                if (inSQLCLLogin == null || inSQLCLLogin.equals(Boolean.FALSE)) {
                    toReport = Messages.getString("SQLPLUS.1") + "\n" + Messages.getString("SQLPLUS.LOGON_PROXY");
                }
                SQLPLUSUtil.report(this.ctx, (String)toReport);
                return null;
            }
            newConnection = null;
            try {
                String passwd2;
                boolean complete = this.completeConnectionDetails(oldConnection, cd);
                String userName = this.stringify(this.properties.getValueOf(UserProperty.USER));
                if (userName.isEmpty()) {
                    String newUserName = cd.getConnectName();
                    this.properties.setValueOf(UserProperty.USER, newUserName);
                }
                if ((passwd2 = this.stringify(this.properties.getValueOf(PasswordProperty.PASSWORD))).isEmpty()) {
                    TextSecret newPassword = cd.getConnectPassword();
                    this.properties.setValueOf(PasswordProperty.PASSWORD, newPassword);
                }
                if (!this.ctx.getExited() && complete) {
                    if (cd.getConnection() != null) {
                        newConnection = cd.getConnection();
                        cd.setConnection(null);
                    } else {
                        newConnection = this.getNewConnection(urlMessage, cd.getConnectName(), cd.getConnectPassword(), cd.getConnectDB(), cd.getRole());
                    }
                }
                if (cd.getConnection() == null) break block40;
            }
            catch (Throwable throwable) {
                if (cd.getConnection() != null) {
                    try {
                        cd.getConnection().close();
                    }
                    catch (SQLException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                    }
                }
                if (newConnection == null) throw throwable;
                String url = (String)this.ctx.getProperty("cli.conn.url");
                ScriptUtils.setHttpCon(newConnection, this.ctx, (String)this.ctx.getProperty("cli.conn.url") != null && (url.startsWith("http:") || url.startsWith("https:")));
                if (cd.getEdition() == null || cd.getEdition().trim().length() <= 0) throw throwable;
                try {
                    newConnection.createStatement().execute(MessageFormat.format("alter session set edition={0}", cd.getEdition()));
                    throw throwable;
                }
                catch (SQLException e) {
                    try {
                        newConnection.close();
                        newConnection = null;
                    }
                    catch (SQLException e2) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e2.getStackTrace()[0].toString(), e2);
                    }
                    this.ctx.write(e.getLocalizedMessage() + "\n");
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
                throw throwable;
            }
            try {
                cd.getConnection().close();
            }
            catch (SQLException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
        if (newConnection != null) {
            String url = (String)this.ctx.getProperty("cli.conn.url");
            ScriptUtils.setHttpCon(newConnection, this.ctx, (String)this.ctx.getProperty("cli.conn.url") != null && (url.startsWith("http:") || url.startsWith("https:")));
            if (cd.getEdition() != null && cd.getEdition().trim().length() > 0) {
                try {
                    newConnection.createStatement().execute(MessageFormat.format("alter session set edition={0}", cd.getEdition()));
                }
                catch (SQLException e) {
                    try {
                        newConnection.close();
                        newConnection = null;
                    }
                    catch (SQLException e2) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e2.getStackTrace()[0].toString(), e2);
                    }
                    this.ctx.write(e.getLocalizedMessage() + "\n");
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
            }
        }
        if (this.ctx.getExited()) return newConnection;
        if (newConnection != null) {
            String cleanRole;
            this.prepareConnection(newConnection);
            String connectIdent = cd.getConnectDB();
            if (connectIdent == null || connectIdent.equals("")) {
                connectIdent = System.getProperty("os.name").startsWith("Windows") ? System.getenv("LOCAL") : System.getenv("TWO_TASK");
            }
            if ((cleanRole = cd.getRole()) == null) {
                cleanRole = "NOTSYSDBA";
            }
            if ((cleanRole = cleanRole.trim().toUpperCase()).equals("")) {
                cleanRole = "NOTSYSDBA";
            }
            this.propertyConsumer.accept(ConnectionProperty.DEF_PRIVILEGE, cleanRole);
            if (connectIdent != null && connectIdent.length() > 1 && connectIdent.length() < 81) {
                this.propertyConsumer.accept(ConnectionProperty.DEF_CONNECT_IDENTIFIER, connectIdent);
            }
            if (this.ctx.getProperty("script.runner.PRELIM_AUTH") != null && this.ctx.getProperty("script.runner.PRELIM_AUTH").equals(Boolean.TRUE) && this.ctx.getProperty("script.runner.sqlplus.silent") == null) {
                if (this.ctx.isSQLPlusClassic()) {
                    SQLPLUSUtil.report(this.ctx, ScriptRunnerDbArb.getString("CONNECTIDLECLASSIC"));
                } else {
                    SQLPLUSUtil.report(this.ctx, ScriptRunnerDbArb.getString("CONNECTIDLE"));
                }
            }
            Boolean oldEcho = this.ctx.isEchoOn();
            try {
                if (!NLSLang.isNLSLANGSet()) return newConnection;
                NLSLang.setupNLSSession(this.ctx, newConnection);
                return newConnection;
            }
            finally {
                SQLPLUSUtil.forceEcho(this.ctx, oldEcho, true);
            }
        } else {
            Object failed = Messages.getString("CONNECTION_FAILED") + "\n";
            LinkedHashSet<String> hashset = new LinkedHashSet<String>(urlMessage);
            for (String outln : hashset) {
                if (this.ctx.isSQLPlusClassic()) {
                    if (outln == null || outln.equals("")) continue;
                    failed = outln;
                    break;
                }
                failed = (String)failed + outln;
            }
            this.propertyConsumer.accept(ConnectionProperty.ERROR_MESSAGE, failed);
        }
        return newConnection;
    }

    protected boolean completeConnectionDetails(Connection conn, ConnectionDetails cd) {
        return true;
    }

    protected abstract ConnectionRec createConnection(List<String> var1, String var2, TextSecret var3, String var4, String var5);

    protected void prepareConnection(Connection newConnection) {
    }

    protected Connection getNewConnection(ArrayList<String> urlMessage, String connectName, TextSecret connectPassword, String connectDB, String role) {
        ConnectionRec connectionRec = this.createConnection(urlMessage, connectName, connectPassword, connectDB, role);
        if (connectionRec == null || connectionRec.connection == null) {
            return null;
        }
        Boolean prelim = (Boolean)this.ctx.getProperty("script.runner.PRELIM_AUTH");
        if (prelim == null || prelim.equals(Boolean.FALSE)) {
            SQLPLUSUtil.setupNLS(connectionRec.connection, this.ctx);
        }
        if (connectionRec.url != null && this.ctx.isCommandLine() && (this.ctx.getProperty("script.runner.setnet") == null || (String)this.ctx.getProperty("script.runner.setnet") != null && !((String)this.ctx.getProperty("script.runner.setnet")).equals("READONLY"))) {
            NetCommand.add(this.ctx, (String)this.ctx.getProperty("script.runner.setnetoverwrite"), connectionRec.url, connectionRec.url, false);
        }
        this.ctx.putProperty("sqldev.last.err.message.forsqlcode", null);
        return connectionRec.connection;
    }

    private ConnectionDetails createConnectionsDetails() {
        int at;
        int slash;
        ConnectionDetails cd = ScriptUtils.getConnectionDetails("connect " + this.stringify(this.connectionSpec));
        String url = this.stringify(this.properties.getValueOf(URLProperty.URL));
        String user = this.stringify(this.properties.getValueOf(UserProperty.USER));
        TextSecret password = this.properties.getValueOf(PasswordProperty.PASSWORD);
        Object role = this.stringify(this.properties.getValueOf(RoleProperty.ROLE));
        if (!((String)role).equals("")) {
            role = "as " + (String)role;
        }
        String edition = this.stringify(this.properties.getValueOf(EditionProperty.EDITION));
        StringBuilder buff = new StringBuilder();
        buff.append(user);
        if (cd.getSlash() != -1) {
            slash = buff.length();
            if (StandardFormConnectorType.isNotEmpty(password)) {
                buff.append('/').append((String)password.map(String::new));
            }
        } else {
            slash = -1;
        }
        if (cd.getAt() != -1 || !url.isEmpty()) {
            at = buff.length();
            buff.append('@').append(url);
        } else {
            at = -1;
        }
        if (!((String)role).isEmpty()) {
            buff.append(' ').append((String)role);
        }
        if (!edition.isEmpty()) {
            buff.append(' ').append("edition=").append(edition);
        }
        return new ConnectionDetails(buff.toString(), cd.isCallDialog(), user, password, url, (String)role, cd.getRoleBad(), at, slash, null, edition);
    }

    private String redact(String sql, String passwd) {
        String quotedPasswd = Pattern.quote(passwd);
        sql = sql.replaceAll("\\-(?i)" + PasswordProperty.PASSWORD.getName() + "(?-i)(?:\\s|=|:)" + quotedPasswd + "\\s+", "");
        sql = sql.replaceAll("\\-(?i)" + PasswordProperty.PASSWORD.getShortName() + "(?-i)(?:\\s|=|:)" + quotedPasswd + "\\s+", "");
        sql = sql.replaceAll("/" + quotedPasswd + "@", "@");
        sql = sql.replaceAll("/" + quotedPasswd + "\\s*$", "");
        return sql;
    }

    private String stringify(Object value) {
        return value != null ? value.toString() : "";
    }

    protected class ConnectionRec {
        Connection connection;
        String url;

        public ConnectionRec(Connection connection) {
            this(connection, null);
        }

        public ConnectionRec(Connection connection, String url) {
            this.connection = connection;
            this.url = url;
        }
    }
}

