/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ConnectionDetails;
import oracle.dbtools.raptor.newscriptrunner.IGetPromptedPasswordFieldsProvider;
import oracle.dbtools.raptor.newscriptrunner.ResetPasswordHelper;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerDbArb;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectPlugin;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.StandardFormConnector;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.dbtools.util.Pair;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.datasource.impl.OracleDataSource;

public abstract class OracleStandardFormConnector
extends StandardFormConnector {
    private ConnectPlugin authPlugin;
    private static final Set<String> ADMIN_ROLES = Set.of("SYSASM", "SYSBACKUP", "SYSDBA", "SYSDG", "SYSKM", "SYSOPER");
    private static final String AS = "as";

    protected OracleStandardFormConnector(ConnectorArgs args) {
        super(args);
    }

    protected final void installPlugin(ConnectPlugin addin) {
        this.authPlugin = addin;
    }

    protected abstract StandardFormConnector.ConnectionRec createOracleStandardFormConnection(List<String> var1, String var2, Properties var3);

    protected abstract void configureDataSource(oracle.jdbc.datasource.OracleDataSource var1, String var2, Properties var3) throws SQLException;

    @Override
    protected StandardFormConnector.ConnectionRec createConnection(List<String> urlMessage, String connectName, TextSecret connectPassword, String connectDB, String role) {
        Properties props = new Properties();
        props.setProperty("v$session.program", SQLPLUSUtil.getProductName());
        Properties globalProps = (Properties)this.ctx.getProperty("sqlcl.global.conn.props");
        if (globalProps != null) {
            for (String key : globalProps.stringPropertyNames()) {
                props.setProperty(key, globalProps.getProperty(key));
            }
        }
        this.processAuthentication(connectName, connectPassword, role, props);
        String tnsnamesDir = TNSHelper.getTnsnamesDir();
        if (tnsnamesDir != null) {
            props.setProperty("oracle.net.tns_admin", tnsnamesDir);
        }
        return this.createOracleStandardFormConnection(urlMessage, connectDB, props);
    }

    private void processAuthentication(String connectName, TextSecret connectPassword, String role, Properties props) {
        if (connectPassword != null && connectPassword.isPresent()) {
            props.setProperty("password", (String)connectPassword.map(String::new));
        }
        if (connectName != null && connectName.length() > 0) {
            Object altered = connectName;
            if (role != null && role.length() > 1) {
                String[] retVal = SQLPLUSUtil.nextWordAndRest(role);
                String asVal = retVal[0].trim();
                String roleVal = retVal[1].trim();
                if (AS.equalsIgnoreCase(asVal) && !ADMIN_ROLES.contains(roleVal.toUpperCase())) {
                    altered = (String)altered + " as " + roleVal.toLowerCase();
                }
            }
            props.setProperty("user", (String)altered);
        }
        if (role != null && role.length() > 1) {
            String[] retVal = SQLPLUSUtil.nextWordAndRest(role);
            String asVal = retVal[0].trim();
            String roleVal = retVal[1].trim().toUpperCase();
            if (AS.equalsIgnoreCase(asVal) && ADMIN_ROLES.contains(roleVal)) {
                props.setProperty("internal_logon", roleVal);
            }
            if (retVal[0].trim().equalsIgnoreCase(AS) && retVal[1].trim().equalsIgnoreCase("sysbackup")) {
                props.setProperty("internal_logon", "SYSBACKUP");
            }
            if (retVal[0].trim().equalsIgnoreCase(AS) && retVal[1].trim().equalsIgnoreCase("sysdg")) {
                props.setProperty("internal_logon", "SYSDG");
            }
            if (retVal[0].trim().equalsIgnoreCase(AS) && retVal[1].trim().equalsIgnoreCase("syskm")) {
                props.setProperty("internal_logon", "SYSKM");
            }
        }
        if (this.authPlugin != null) {
            Properties additionalProperties = this.authPlugin.getAdditionalProperties();
            for (String key : additionalProperties.stringPropertyNames()) {
                props.setProperty(key, additionalProperties.getProperty(key));
            }
        }
    }

    @Override
    protected void prepareConnection(Connection newConnection) {
        if (newConnection instanceof OracleConnection) {
            if (this.supportsDefaultRowPrefetch()) {
                try {
                    int pref = 0;
                    try {
                        pref = Integer.valueOf((String)this.ctx.getProperty("script.runner.arraysize"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ((OracleConnection)newConnection).setDefaultRowPrefetch(Math.max(pref, 50));
                }
                catch (SQLException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                }
            }
            String lastLoginTime = DBUtil.getInstance(newConnection).executeReturnOneCol("select INITCAP(TO_CHAR(last_login ,'DY MON DD YYYY HH24:MI:SS TZH:TZM')) from dba_users where username=USER");
            this.propertyConsumer.accept(ConnectionProperty.LAST_LOGIN_TIME, lastLoginTime);
        }
    }

    @Override
    protected boolean completeConnectionDetails(Connection conn, ConnectionDetails cd) {
        if (cd == null) {
            return true;
        }
        for (int ii = 0; ii < 3; ++ii) {
            if (ii != 0 || cd.getSlash() == -1 || cd.getConnectName() == null || cd.getConnectPassword() == null || cd.getConnectDB() == null) {
                ConnectionDetails threeFields = this.ctx.getConnectFieldsProvider().get3Fields(this.ctx, cd, ii > 0);
                if (threeFields == null) {
                    return false;
                }
                cd.cloneFrom(threeFields);
            }
            Object totalErrors = "";
            ArrayList<String> urlMessage = new ArrayList<String>();
            Boolean threeTimes = (Boolean)this.ctx.getProperty("script.runner.threetimes");
            if (threeTimes == null) {
                threeTimes = Boolean.FALSE;
            }
            if (ii == 2 || threeTimes.equals(Boolean.FALSE)) break;
            Connection myconn = this.getNewConnection(urlMessage, cd.getConnectName(), cd.getConnectPassword(), cd.getConnectDB(), cd.getRole());
            if (myconn != null) {
                cd.setConnection(myconn);
                break;
            }
            for (String outln : urlMessage) {
                if (this.ctx.isSQLPlusClassic()) {
                    if (outln == null || outln.equals("")) continue;
                    totalErrors = outln;
                    break;
                }
                totalErrors = (String)totalErrors + outln;
            }
            SQLPLUSUtil.doWhenever(this.ctx, this.cmd, conn, true);
            if (this.ctx.getExited()) break;
            if (this.ctx.isCommandLine() && this.ctx.getTopLevel()) {
                SQLPLUSUtil.report(this.ctx, ("Z" + (String)totalErrors).trim().substring(1));
                continue;
            }
            SQLPLUSUtil.report(this.ctx, ScriptRunnerContext.lineErr(this.cmd.getStartLine() + 1, this.cmd.getSQLOrig(), ScriptRunnerDbArb.format("CONNECTION_FAILED_RETRY_ARG", ("Z" + (String)totalErrors).trim().substring(1)), this.ctx).trim());
        }
        return true;
    }

    protected boolean supportsDefaultRowPrefetch() {
        return true;
    }

    protected Connection logConnectionURL(List<String> urlMessage, String username, String URLString, Properties props, boolean tryPrelim) throws Throwable {
        return this.logConnectionURL(urlMessage, username, URLString, props, tryPrelim, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Connection logConnectionURL(List<String> urlMessage, String username, String URLString, Properties props, boolean tryPrelim, boolean doLog) throws Throwable {
        Object user = "";
        boolean prelimAuthThrown = false;
        Connection conn = null;
        if (doLog) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, ScriptRunnerDbArb.format("CONNECTING", URLString));
        }
        String feedback = ScriptRunnerDbArb.getString("NO_ERROR");
        try {
            block29: {
                try {
                    conn = this.lowLevelConnect(URLString, props);
                }
                catch (SQLException e) {
                    if (e.getErrorCode() != 28001) throw e;
                    SQLPLUSUtil.report(this.ctx, e.getLocalizedMessage());
                    IGetPromptedPasswordFieldsProvider passProvider = this.ctx.getPasswordFieldsProvider();
                    if (passProvider == null) break block29;
                    Pair<String, String> passPair = passProvider.passwordGetPassword(this.ctx, username + "donotdisplay", username);
                    if (passPair == null || passPair.first() == null) throw e;
                    conn = new ResetPasswordHelper().resetAndReconnect(this.ctx, username, URLString, props, passPair.first(), e, (u, p) -> this.createDataSource(u, p).getConnection());
                }
            }
            this.ctx.putProperty("script.runner.PRELIM_AUTH", Boolean.FALSE);
            return conn;
        }
        catch (Throwable e) {
            block30: {
                feedback = e.getLocalizedMessage();
                if (feedback == null) {
                    feedback = e.getMessage();
                }
                feedback = feedback != null ? feedback.trim() : "";
                user = props.getProperty("user");
                if (user == null) {
                    user = "";
                }
                try {
                    if (!tryPrelim || !this.ctx.isCommandLine() || !this.cmd.getStmtSubType().equals((Object)SQLCommand.StmtSubType.G_S_CONNECT)) throw e;
                    String internalLogin = props.getProperty("internal_logon");
                    boolean usePrelimAuth = false;
                    if (e instanceof SQLException) {
                        int errCode = ((SQLException)e).getErrorCode();
                        boolean checkErrCode = errCode == 1033 || errCode == 1034 || errCode == 1090;
                        boolean hasAdminRole = internalLogin != null && ADMIN_ROLES.contains(internalLogin);
                        boolean bl = usePrelimAuth = checkErrCode && hasAdminRole;
                    }
                    if (usePrelimAuth) {
                        String password;
                        Properties duplicateProperties = new Properties();
                        String userName = props.getProperty("user");
                        if (userName != null) {
                            duplicateProperties.setProperty("user", userName);
                        }
                        if ((password = props.getProperty("password")) != null) {
                            duplicateProperties.setProperty("password", password);
                        }
                        duplicateProperties.setProperty("prelim_auth", "true");
                        duplicateProperties.setProperty("internal_logon", internalLogin);
                        try {
                            conn = DriverManager.getConnection(URLString, duplicateProperties);
                            try {
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "(prelim auth) conn.isClosed()=" + conn.isClosed());
                            }
                            catch (SQLException ee) {
                                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "(prelim auth) conn.isClosed()_exception", ee);
                            }
                            this.ctx.putProperty("script.runner.PRELIM_AUTH", Boolean.TRUE);
                            this.ctx.putProperty("PRELIMAUTHPREERROR", ((SQLException)e).getErrorCode());
                            if (this.ctx != null) {
                                this.ctx.putProperty("cli.conn.url", URLString);
                                this.ctx.putProperty("cli.conn.props", props);
                            }
                        }
                        catch (Throwable t2) {
                            if (doLog) {
                                if (!this.ctx.isSQLPlusClassic()) {
                                    urlMessage.add(ScriptRunnerDbArb.format("URL_MESSAGE", user, URLString, feedback));
                                } else {
                                    SQLPLUSUtil.classicUrlMessageAdd(urlMessage, (String)user, URLString, feedback);
                                }
                            }
                            feedback = "";
                            feedback = t2.getLocalizedMessage();
                            if (feedback == null) {
                                feedback = e.getMessage();
                            }
                            feedback = feedback != null ? feedback.trim() : "";
                            prelimAuthThrown = true;
                            throw t2;
                        }
                    }
                    if (feedback == null || feedback.equals("")) return conn;
                    user = props.getProperty("user");
                    if (user == null) {
                        user = "";
                    }
                    if (!prelimAuthThrown) break block30;
                }
                catch (Throwable throwable) {
                    if (feedback == null || feedback.equals("")) throw throwable;
                    user = props.getProperty("user");
                    if (user == null) {
                        user = "";
                    }
                    if (prelimAuthThrown) {
                        user = (String)user + " prelim_auth";
                    }
                    if (!doLog) throw throwable;
                    if (!this.ctx.isSQLPlusClassic()) {
                        urlMessage.add(ScriptRunnerDbArb.format("URL_MESSAGE", user, URLString, feedback));
                        throw throwable;
                    } else {
                        SQLPLUSUtil.classicUrlMessageAdd(urlMessage, (String)user, URLString, feedback);
                    }
                    throw throwable;
                }
                user = (String)user + " prelim_auth";
            }
            if (!doLog) return conn;
            if (!this.ctx.isSQLPlusClassic()) {
                urlMessage.add(ScriptRunnerDbArb.format("URL_MESSAGE", user, URLString, feedback));
                return conn;
            } else {
                SQLPLUSUtil.classicUrlMessageAdd(urlMessage, (String)user, URLString, feedback);
            }
            return conn;
        }
    }

    private Connection lowLevelConnect(String urlin, Properties props) throws SQLException {
        Connection forReturn;
        Object url = urlin;
        if (this.ctx.getProperty("script.runner.jline") != null && url != null && (((String)url).startsWith("http:") || ((String)url).startsWith("https:"))) {
            url = "jdbc:oracle:orest@" + (String)url;
        }
        if (url != null && (((String)url).startsWith("http:") || ((String)url).startsWith("https:") || ((String)url).startsWith("jdbc:oracle:orest")) && !((String)url).endsWith("/") && ((String)url).indexOf(63) == -1) {
            url = (String)url + "/";
        }
        if (this.ctx != null) {
            this.ctx.putProperty("cli.conn.url", url);
            this.ctx.putProperty("cli.conn.props", props);
        }
        boolean doDebug = false;
        if (url != null && (((String)url).startsWith("http:") || ((String)url).startsWith("https:") || ((String)url).startsWith("jdbc:oracle:orest"))) {
            doDebug = true;
        }
        if (!doDebug || ((String)url).startsWith("jdbc:oracle:orest")) {
            // empty if block
        }
        Connection connection = forReturn = ((String)url).startsWith("jdbc:oracle:orest") || ((String)url).startsWith("jdbc:oracle:nucleo") ? DriverManager.getConnection((String)url, props) : this.createDataSource((String)url, props).getConnection();
        if (doDebug) {
            oracle.dbtools.util.Logger.info(this.getClass(), "Connection got, class:" + String.valueOf(forReturn.getClass()));
        }
        return forReturn;
    }

    private oracle.jdbc.datasource.OracleDataSource createDataSource(String url, Properties props) throws SQLException {
        OracleDataSource dataSource = new OracleDataSource();
        Properties filteredProps = new Properties();
        filteredProps.putAll((Map<?, ?>)props);
        this.configureDataSource((oracle.jdbc.datasource.OracleDataSource)dataSource, url, filteredProps);
        return dataSource;
    }
}

