/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.raptor.newscriptrunner.SqlnetInstance;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.OracleStandardFormConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.StandardFormConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.URLProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.net.NetEntries;
import oracle.dbtools.raptor.utils.SQLPLUSUtil;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.jdbc.datasource.OracleDataSource;

public class OracleConnector
extends OracleStandardFormConnector {
    private static final String ENTRY = "#ENTRY#";
    private static final String LDAPCON = "LDAPCON";

    public OracleConnector(ConnectorArgs args) {
        super(args);
        String url = this.properties.getValueOf(URLProperty.URL);
        if (url == null) {
            this.properties.setValueOf(URLProperty.URL, this.ctx.getService(ConnectionContext.class).getCurrentPropertyValues().getValueOf(URLProperty.URL));
        }
    }

    @Override
    protected StandardFormConnector.ConnectionRec createOracleStandardFormConnection(List<String> urlMessage, String connectDB, Properties props) {
        String successfulAttempt;
        Connection myconn;
        block35: {
            String connectName = props.getProperty("user");
            myconn = null;
            successfulAttempt = null;
            if ((connectDB == null || connectDB.isEmpty()) && this.ctx.getProperty("script.runner.jline") != null) {
                String envValue;
                String envToCheck = "TWO_TASK";
                if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
                    envToCheck = "LOCAL";
                }
                if ((envValue = System.getenv(envToCheck)) != null && !envValue.isEmpty()) {
                    connectDB = envValue;
                }
            }
            if (connectDB != null && !connectDB.isEmpty()) {
                int match = -1;
                ArrayList<TCPTNSEntry> myTCPEntry = null;
                String preExpand = null;
                String tryLDAP = null;
                if (this.ctx.getProperty("script.runner.ldapcon") != null && ((String)this.ctx.getProperty("script.runner.ldapcon")).contains(ENTRY)) {
                    tryLDAP = ((String)this.ctx.getProperty("script.runner.ldapcon")).replace(ENTRY, connectDB);
                }
                if (tryLDAP == null && System.getenv(LDAPCON) != null && System.getenv(LDAPCON).contains(ENTRY)) {
                    tryLDAP = System.getenv(LDAPCON).replace(ENTRY, connectDB);
                }
                if (tryLDAP != null) {
                    try {
                        myconn = this.logConnectionURL(urlMessage, connectName, tryLDAP, props, true);
                    }
                    catch (ThreadDeath t) {
                        throw t;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (myconn == null) {
                    String netVal;
                    myTCPEntry = TNSHelper.getTNSEntries();
                    if (myTCPEntry != null) {
                        for (int i = 0; i < myTCPEntry.size(); ++i) {
                            if (!myTCPEntry.get(i).getName().equalsIgnoreCase(connectDB)) continue;
                            preExpand = connectDB;
                            match = i;
                            break;
                        }
                    }
                    if (!(match != -1 || connectDB.contains("/") || connectDB.contains("\\") || connectDB.contains(":"))) {
                        String connectDBnoDot = connectDB;
                        int indexdot = connectDBnoDot.indexOf(".");
                        if (indexdot != -1) {
                            connectDBnoDot = connectDBnoDot.substring(0, indexdot);
                        }
                        if (myTCPEntry != null) {
                            for (int i = 0; i < myTCPEntry.size(); ++i) {
                                String theEntry = myTCPEntry.get(i).getName();
                                int indexdot2 = theEntry.indexOf(".");
                                if (indexdot2 != -1) {
                                    theEntry = theEntry.substring(0, indexdot2);
                                }
                                if (!theEntry.equalsIgnoreCase(connectDBnoDot)) continue;
                                match = i;
                                break;
                            }
                        }
                    }
                    if (match == -1 && this.ctx.isCommandLine() && (this.ctx.getProperty("script.runner.setnet") == null || this.ctx.getProperty("script.runner.setnet") != null && !this.ctx.getProperty("script.runner.setnet").equals("OFF")) && (netVal = NetEntries.getInstance().get(connectDB)) != null) {
                        myconn = this.getConnection(urlMessage, props, netVal, connectName, true);
                    }
                }
                if (myconn == null) {
                    if (match == -1) {
                        myconn = this.getConnection(urlMessage, props, connectDB, connectName, true);
                    } else {
                        String specUrl = myTCPEntry.get(match).getSpecUrl();
                        myconn = this.getConnection(urlMessage, props, specUrl, connectName, preExpand == null || preExpand.isEmpty());
                    }
                }
            } else {
                try {
                    try {
                        if (Boolean.TRUE.equals(this.ctx.getProperty("DBConfig.USE_THICK_DRIVER"))) {
                            String url = "jdbc:oracle:oci8:@";
                            myconn = this.logConnectionURL(urlMessage, connectName, url, props, true, true);
                        }
                    }
                    catch (ThreadDeath t) {
                        throw t;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    if (myconn != null) break block35;
                    try {
                        String oracleSid = System.getProperty("ORACLE_SID");
                        if (oracleSid == null && (oracleSid = System.getenv("ORACLE_SID")) != null) {
                            System.setProperty("ORACLE_SID", oracleSid);
                        }
                        if (oracleSid != null && !oracleSid.isEmpty()) {
                            String url = "jdbc:oracle:thin:@127.0.0.1:1521:" + oracleSid;
                            myconn = this.logConnectionURL(urlMessage, connectName, url, props, true);
                        }
                    }
                    catch (ThreadDeath t) {
                        throw t;
                    }
                    catch (Throwable t) {
                    }
                }
                catch (ThreadDeath t) {
                    throw t;
                }
                catch (Throwable e) {
                    myconn = null;
                }
            }
        }
        return new StandardFormConnector.ConnectionRec(this, myconn, successfulAttempt);
    }

    private Connection getConnection(List<String> urlMessage, Properties props, String spec, String connectName, boolean expand) {
        Connection myconn;
        if (SQLPLUSUtil.hasUrlStub(spec)) {
            try {
                myconn = this.logConnectionURL(urlMessage, connectName, spec, props, true);
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable ee) {
                myconn = null;
                this.ctx.putProperty("sqldev.last.err.message.forsqlcode", ee.getMessage());
            }
        } else {
            try {
                String url = this.getConnectURL(spec, expand);
                myconn = this.logConnectionURL(urlMessage, connectName, url, props, true);
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable e) {
                myconn = null;
                this.ctx.putProperty("sqldev.last.err.message.forsqlcode", e.getMessage());
            }
        }
        return myconn;
    }

    private String getConnectURL(String spec, boolean expand) {
        StringBuilder sb = new StringBuilder();
        boolean useOci = Boolean.TRUE.equals(this.ctx.getProperty("DBConfig.USE_THICK_DRIVER"));
        sb.append(useOci ? "jdbc:oracle:oci8:@" : "jdbc:oracle:thin:@");
        sb.append(expand ? SqlnetInstance.expandForInstance(spec) : spec);
        return sb.toString();
    }

    @Override
    protected void configureDataSource(OracleDataSource datasource, String url, Properties filteredProps) throws SQLException {
        datasource.setURL(url);
        datasource.setConnectionProperties(filteredProps);
    }
}

