/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connect.save;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import oracle.dbtools.connections.ConnectionsResources;
import oracle.dbtools.core.connections.ConnectionIdentifiers;
import oracle.dbtools.core.connections.api.Connections;
import oracle.dbtools.core.connections.folder.Folder;
import oracle.dbtools.core.connections.folder.FolderOperationException;
import oracle.dbtools.core.connections.folder.utils.FolderUtils;
import oracle.dbtools.core.connections.folder.utils.PathsUtils;
import oracle.dbtools.core.connections.storage.ConnectionDefinition;
import oracle.dbtools.core.connections.storage.ConnectionStorage;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.NoSuchConnectionFolderException;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.save.FolderSerializer;

public class ConnectionsFolderManager {
    private final FolderSerializer serializer;
    private final Folder rootFolder;
    private final Map<String, Connections.Identifier> identifiers = new ConcurrentHashMap<String, Connections.Identifier>();
    private final Set<Connections.Identifier> connectionsRegistry = ConcurrentHashMap.newKeySet();

    public ConnectionsFolderManager() {
        this(FolderSerializer.create());
    }

    public ConnectionsFolderManager(FolderSerializer serializer) {
        this.serializer = serializer;
        this.rootFolder = this.serializer.getRootFolder();
        this.validateConnectionsUniqueness(this.rootFolder);
        this.loadStoreConnections();
    }

    private void validateConnectionsUniqueness(Folder root) throws FolderOperationException {
        List connections = root.getConnections();
        for (Connections.Identifier connection : connections) {
            if (this.connectionsRegistry.add(connection)) continue;
            throw new FolderOperationException(ConnectionsResources.getString("DUPLICATED_CONNECTION_NAME"));
        }
        for (Folder subFolder : root.getSubFolders().values()) {
            this.validateConnectionsUniqueness(subFolder);
        }
    }

    private void loadStoreConnections() {
        this.identifiers.clear();
        ConnectionStorage.instance().listConnectionDirectories().forEach(dir -> {
            ConnectionDefinition def = ConnectionStorage.instance().loadConnection(dir);
            this.identifiers.put(def.getConnectionName(), def.getIdentifier());
        });
    }

    public void addConnection(String path, String connName) throws FolderOperationException {
        if (connName == null || connName.isBlank()) {
            return;
        }
        Connections.Identifier identifier = this.identifiers.getOrDefault(connName, ConnectionIdentifiers.createIdentifier((CharSequence)connName));
        if (!this.connectionsRegistry.add(identifier)) {
            throw new IllegalArgumentException(ConnectionsResources.getString("DUPLICATED_CONNECTION_NAME"));
        }
        Folder folder = FolderUtils.findFolder((Folder)this.rootFolder, (String)path).orElseGet(() -> this.addFolder(path));
        folder.addConnection(identifier);
        this.serializer.persist(this.rootFolder);
    }

    public void moveConnection(String connName, String destFolderPath) throws FolderOperationException {
        Folder destFolder = this.findOrElseThrowNotuchFolder(this.rootFolder, destFolderPath);
        Connections.Identifier identifier = this.identifiers.getOrDefault(connName, ConnectionIdentifiers.createIdentifier((CharSequence)connName));
        Folder sourceFolder = (Folder)FolderUtils.findFolderByConnection((Folder)this.rootFolder, (Connections.Identifier)identifier).orElseThrow(() -> new NoSuchConnectionFolderException(oracle.dbtools.core.connections.ConnectionsResources.format((String)"NO_SUCH_CONNECTION", (Object[])new Object[]{connName})));
        destFolder.addConnection(identifier);
        sourceFolder.deleteConnection(identifier);
        this.serializer.persist(this.rootFolder);
    }

    public void renameConnection(String oldName, String newName) throws FolderOperationException {
        Connections.Identifier oldIdentifier = this.identifiers.getOrDefault(oldName, ConnectionIdentifiers.createIdentifier((CharSequence)oldName));
        if (!this.connectionsRegistry.add(ConnectionIdentifiers.createIdentifier((CharSequence)newName)) || this.identifiers.containsKey(newName)) {
            throw new IllegalArgumentException(oracle.dbtools.core.connections.ConnectionsResources.format((String)"CONNECTION_NAME_ALREADY_EXISTS", (Object[])new Object[]{newName}));
        }
        ConnectionStorage.instance().renameConnection(oldName, newName);
        this.loadStoreConnections();
        Connections.Identifier newIdentifier = this.identifiers.getOrDefault(newName, ConnectionIdentifiers.createIdentifier((CharSequence)newName));
        Folder connectionFolder = (Folder)FolderUtils.findFolderByConnection((Folder)this.rootFolder, (Connections.Identifier)oldIdentifier).orElseThrow(() -> new NoSuchConnectionFolderException(oracle.dbtools.core.connections.ConnectionsResources.format((String)"NO_SUCH_CONNECTION", (Object[])new Object[]{oldName})));
        connectionFolder.deleteConnection(oldIdentifier);
        connectionFolder.addConnection(newIdentifier);
        this.connectionsRegistry.remove(oldIdentifier);
        this.serializer.persist(this.rootFolder);
    }

    public void deleteConnection(String connName) {
        Connections.Identifier identifier = this.identifiers.getOrDefault(connName, ConnectionIdentifiers.createIdentifier((CharSequence)connName));
        Folder connectionFolder = (Folder)FolderUtils.findFolderByConnection((Folder)this.rootFolder, (Connections.Identifier)identifier).orElseThrow(() -> new NoSuchConnectionFolderException(oracle.dbtools.core.connections.ConnectionsResources.format((String)"NO_SUCH_CONNECTION", (Object[])new Object[]{connName})));
        ConnectionStorage.instance().deleteConnection(connName);
        this.connectionsRegistry.remove(identifier);
        connectionFolder.deleteConnection(identifier);
        this.serializer.persist(this.rootFolder);
    }

    public Folder addFolder(String path) {
        String[] pathSegments = PathsUtils.getPathSegments((String)path);
        Folder currentFolder = this.rootFolder;
        if (PathsUtils.isRoot((String)path)) {
            throw new FolderOperationException(oracle.dbtools.core.connections.ConnectionsResources.format((String)"CANT_PERFORM_THIS_ACTION_ON_ROOT", (Object[])new Object[]{path, path}));
        }
        for (int i = 0; i < pathSegments.length; ++i) {
            boolean isLast;
            String current = pathSegments[i];
            if (FolderUtils.isNotValidName((String)current)) {
                throw new FolderOperationException(oracle.dbtools.core.connections.ConnectionsResources.format((String)"INVALID_FOLDER_NAME", (Object[])new Object[]{current}));
            }
            boolean bl = isLast = i == pathSegments.length - 1;
            if (isLast && currentFolder.getSubFolder(current) != null) {
                throw new FolderOperationException(oracle.dbtools.core.connections.ConnectionsResources.format((String)"FOLDER_ALREADY_EXISTS", (Object[])new Object[]{current, path}));
            }
            currentFolder = currentFolder.getSubFolders().computeIfAbsent(current, fn -> Folder.builder((String)fn).build());
        }
        this.serializer.persist(this.rootFolder);
        return currentFolder;
    }

    public void moveFolder(String srcPath, String destPath) throws FolderOperationException {
        String srcFolderName;
        Folder srcFolder = this.findOrElseThrowNotuchFolder(this.rootFolder, srcPath);
        Folder destFolder = this.findOrElseThrowNotuchFolder(this.rootFolder, destPath);
        if (destFolder.getSubFolder(srcFolderName = PathsUtils.getLastElement((String)srcPath)) != null) {
            throw new FolderOperationException(oracle.dbtools.core.connections.ConnectionsResources.format((String)"FOLDER_ALREADY_EXISTS", (Object[])new Object[]{srcFolderName, destPath}));
        }
        destFolder.addSubFolder(srcFolder);
        Folder srcParentFolder = this.findOrElseThrowNotuchFolder(this.rootFolder, PathsUtils.getParentPath((String)srcPath));
        srcParentFolder.deleteSubFolder(srcFolder);
        this.serializer.persist(this.rootFolder);
    }

    public void deleteFolder(String path, boolean forceDelete) {
        String folderName = PathsUtils.getLastElement((String)path);
        if (PathsUtils.isRoot((String)folderName)) {
            throw new FolderOperationException(oracle.dbtools.core.connections.ConnectionsResources.format((String)"CANT_PERFORM_THIS_ACTION_ON_ROOT", (Object[])new Object[]{"delete"}));
        }
        String parentPath = PathsUtils.getParentPath((String)path);
        Folder parentFolder = this.findOrElseThrowNotuchFolder(this.rootFolder, parentPath);
        Folder folderToBeDeleted = parentFolder.getSubFolder(folderName);
        if (this.notNullOrEmpty(folderToBeDeleted) && !forceDelete) {
            throw new FolderOperationException(oracle.dbtools.core.connections.ConnectionsResources.getString((String)"FOLDER_NOT_EMPTY"));
        }
        if (folderToBeDeleted != null) {
            Set connectionsToBeDeleted = folderToBeDeleted.getAllNestedConnections();
            ConnectionStorage.instance().listConnectionDirectories().stream().filter(connectionsToBeDeleted::contains).map(arg_0 -> ((ConnectionStorage)ConnectionStorage.instance()).loadConnection(arg_0)).map(ConnectionDefinition::getConnectionName).forEach(arg_0 -> ((ConnectionStorage)ConnectionStorage.instance()).deleteConnection(arg_0));
            parentFolder.deleteSubFolder(folderToBeDeleted);
            this.serializer.persist(this.rootFolder);
        }
    }

    public void renameFolder(String folderPath, String newName) throws FolderOperationException {
        if (FolderUtils.isNotValidName((String)newName)) {
            throw new FolderOperationException(oracle.dbtools.core.connections.ConnectionsResources.format((String)"INVALID_FOLDER_NAME", (Object[])new Object[]{newName}));
        }
        String oldFolderName = PathsUtils.getLastElement((String)folderPath);
        String parentFolderPath = PathsUtils.getParentPath((String)folderPath);
        Folder parentFolder = this.findOrElseThrowNotuchFolder(this.rootFolder, parentFolderPath);
        Folder oldFolder = this.findOrElseThrowNotuchFolder(parentFolder, oldFolderName);
        if (parentFolder.getSubFolder(newName) != null) {
            throw new FolderOperationException(oracle.dbtools.core.connections.ConnectionsResources.format((String)"FOLDER_ALREADY_EXISTS", (Object[])new Object[]{newName, parentFolderPath}));
        }
        Folder newFolder = Folder.builder((String)newName).subFolders(oldFolder.getSubFolders()).connections(oldFolder.getConnections()).build();
        parentFolder.deleteSubFolder(oldFolder);
        parentFolder.addSubFolder(newFolder);
        this.serializer.persist(this.rootFolder);
    }

    public Folder getRootFolder() {
        return this.rootFolder;
    }

    private Folder findOrElseThrowNotuchFolder(Folder rootFolder, String path) {
        return (Folder)FolderUtils.findFolder((Folder)rootFolder, (String)path).orElseThrow(() -> new NoSuchConnectionFolderException(oracle.dbtools.core.connections.ConnectionsResources.format((String)"NO_SUCH_FOLDER", (Object[])new Object[]{path})));
    }

    private boolean notNullOrEmpty(Folder folder) {
        return folder != null && (!folder.getSubFolders().isEmpty() || !folder.getConnections().isEmpty());
    }
}

