/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.alias;

import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptParser;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Alias;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Aliases;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Messages;
import oracle.dbtools.raptor.newscriptrunner.util.command.ParsedCommandListener;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Factory;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Node;
import oracle.dbtools.raptor.newscriptrunner.util.parser.OptionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParameterBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;
import oracle.dbtools.raptor.newscriptrunner.util.transformer.TransformContext;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Parser;
import oracle.dbtools.raptor.query.Query;

public class AliasCommand
extends ParsedCommandListener
implements IHelp {
    @Override
    protected Type createType() {
        return Factory.type(Symbol.ALIAS).add(Factory.type(Symbol.DETAILS).add(((ParameterBuilder)((ParameterBuilder)Factory.parameter(Symbol.NAME).required()).transformer(this::nameCompletion)).build()).build()).add(Factory.type(Symbol.DROP).add(Factory.option(Symbol.SILENT).flag().build()).add(((ParameterBuilder)((ParameterBuilder)Factory.parameter(Symbol.NAME).required()).transformer(this::nameCompletion)).build()).build()).add(Factory.type(Symbol.GROUPS).build()).add(Factory.type(Symbol.LIST).add(((ParameterBuilder)Factory.parameter(Symbol.GROUP).transformer(this::groupCompletion)).build()).build()).add(Factory.type(Symbol.SEARCH).add(((ParameterBuilder)Factory.parameter(Symbol.SEARCHSTRING).required()).build()).build()).add(Factory.type(Symbol.LOAD).add(Factory.parameter(Symbol.FILENAME).build()).build()).add(Factory.type(Symbol.SAVE).add(Factory.parameter(Symbol.FILENAME).build()).build()).add(Factory.option(Symbol.SILENT).flag().build()).add(Factory.option(Symbol.NULLDEFAULTS).flag().build()).add(((OptionBuilder)Factory.option(Symbol.GROUP).transformer(this::groupNewCompletion)).helpId("GROUP_NEW").build()).add(Factory.option(Symbol.DESC).build()).set(Factory.grammar().dataType(AliasCmdVal.class).add(Factory.rule(GrammarSymbol.AliasCmdRule).helpId().eq(Factory.choice(AliasCmdVal::new, Factory.seq(AliasVal::new, Factory.var("NAME").helpId("NAME_NEW"), Factory.word("=").helpId(), Factory.literal("QUERY")), Factory.var("LIST_GROUP", this::groupCompletion).helpId("GROUP")))).build()).build();
    }

    @Override
    protected String adjustCmdSql(String cmdSql) {
        String[] parts = cmdSql.split("=");
        Object result = null;
        String lastPart = null;
        for (String p : parts) {
            if (lastPart != null && (lastPart.toUpperCase().endsWith("-GROUP") || lastPart.toUpperCase().endsWith("-DESC"))) {
                result = (String)result + "=";
            } else if (result != null) {
                result = result + " = ";
            }
            result = result == null ? p : (String)result + p;
            lastPart = p;
        }
        return result;
    }

    @Override
    protected boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        if (!ctx.isProductNameSQLDeveloper() && !ctx.isProductNameSQLcl()) {
            ctx.writeln(Messages.getString("AliasCommand.35"));
            return true;
        }
        Id command = parsedCommand.getType().getId();
        if (command == Symbol.ALIAS) {
            String group = (String)parsedCommand.getOptionValue(Symbol.GROUP);
            String desc = (String)parsedCommand.getOptionValue(Symbol.DESC);
            boolean nulldefaults = parsedCommand.isFlagSet(Symbol.NULLDEFAULTS);
            boolean silent = parsedCommand.isFlagSet(Symbol.SILENT);
            AliasCmdVal aliasVal = (AliasCmdVal)parsedCommand.getGrammarValue();
            this.handleAlias(ctx, aliasVal, group, desc, nulldefaults, silent);
        } else if (command == Symbol.LIST) {
            String group = (String)parsedCommand.getParameterValue(Symbol.GROUP);
            this.handleList(ctx, group);
        } else if (command == Symbol.DETAILS) {
            String alias = (String)parsedCommand.getParameterValue(Symbol.NAME);
            this.handleDetails(conn, ctx, alias);
        } else if (command == Symbol.SEARCH) {
            String searchstring = (String)parsedCommand.getParameterValue(Symbol.SEARCHSTRING);
            this.handleSearch(conn, ctx, searchstring);
        } else if (command == Symbol.GROUPS) {
            this.handleGroups(ctx);
        } else if (command == Symbol.DROP) {
            String aliasName = (String)parsedCommand.getParameterValue(Symbol.NAME);
            boolean silent = parsedCommand.isFlagSet(Symbol.SILENT);
            this.handleDrop(ctx, aliasName, silent);
        } else if (command == Symbol.SAVE) {
            String alt = (String)parsedCommand.getParameterValue(Symbol.FILENAME);
            this.handleSave(ctx, alt);
        } else if (command == Symbol.LOAD) {
            String alt = (String)parsedCommand.getParameterValue(Symbol.FILENAME);
            this.handleLoad(conn, ctx, alt);
        }
        return true;
    }

    private String nameCompletion(String rawValue, TransformContext context, Environment environment) {
        for (String alias : Aliases.getInstance().getAliases()) {
            if (!alias.toUpperCase().startsWith(rawValue.toUpperCase())) continue;
            context.addCompletion(alias);
        }
        return rawValue;
    }

    private String groupCompletion(String rawValue, TransformContext context, Environment environment) {
        ArrayList<String> groups = new ArrayList<String>();
        for (String alias : Aliases.getInstance().getAliases()) {
            Alias al = Aliases.getInstance().get(alias);
            if (al.getGroup() == null || !al.getGroup().toUpperCase().startsWith(rawValue.toUpperCase()) || groups.contains(al.getGroup())) continue;
            groups.add(al.getGroup());
        }
        groups.sort(null);
        for (String group : groups) {
            context.addCompletion(group);
        }
        return rawValue;
    }

    private String groupNewCompletion(String rawValue, TransformContext context, Environment environment) {
        ArrayList<String> groups = new ArrayList<String>();
        for (String alias : Aliases.getInstance().getAliases()) {
            Alias al = Aliases.getInstance().get(alias);
            if (al.isPredefined() || al.getGroup() == null || !al.getGroup().toUpperCase().startsWith(rawValue.toUpperCase()) || groups.contains(al.getGroup())) continue;
            groups.add(al.getGroup());
        }
        groups.sort(null);
        for (String group : groups) {
            context.addCompletion(group);
        }
        return rawValue;
    }

    private void handleAdd(ScriptRunnerContext ctx, String group, String alias, boolean nulldefaults, String payload, String desc, boolean silent) {
        Alias existing;
        if ("ALIAS".equalsIgnoreCase(alias)) {
            if (!silent) {
                ctx.writeln(Messages.getString("AliasCommand.10"));
            }
            return;
        }
        String query = null;
        if (payload.startsWith(":")) {
            if (payload.length() > 1) {
                payload = payload.substring(1);
                Bind b = ctx.getVarMap().get(payload.toUpperCase());
                if (b != null) {
                    query = b.getValue();
                }
            }
            if (query == null || query.equals("")) {
                if (!silent) {
                    ctx.writeln(Messages.getString("AliasCommand.16"));
                }
                return;
            }
        } else {
            String payloadUpper = payload.toUpperCase();
            if (payload.length() > 5 && payloadUpper.startsWith("Q'") && payload.endsWith(ScriptParser.getEndQuoteString(payload.substring(2, 3)) + "'")) {
                payload = payload.substring(3, payload.length() - 2);
            } else if (payload == null || payload.equals("")) {
                if (!silent) {
                    ctx.writeln(Messages.getString("AliasCommand.20"));
                }
                return;
            }
            query = payload;
        }
        if ((existing = Aliases.getInstance().get(alias)) != null && existing.isPredefined()) {
            if (!silent) {
                ctx.writeln(MessageFormat.format(Messages.getString("AliasCommand.36"), alias));
            }
            return;
        }
        if (Alias.isPredefinedGroup(group)) {
            if (!silent) {
                ctx.writeln(MessageFormat.format(Messages.getString("AliasCommand.37"), group));
            }
            return;
        }
        List<Bind> binds = this.parseBinds(ctx, query);
        Aliases.getInstance().add(alias, query, desc, nulldefaults, group, binds);
        if (!silent) {
            ctx.writeln(MessageFormat.format(Messages.getString("AliasCommand.38"), alias));
        }
    }

    private void handleLoad(Connection conn, ScriptRunnerContext ctx, String alt) {
        if (ctx.getProperty("script.runner.jline") != null) {
            if (alt != null && !alt.isBlank()) {
                if (!(alt.startsWith("http://") || alt.startsWith("https://") || alt.startsWith("ftp://"))) {
                    alt = ctx.prependCD(alt);
                }
                ctx.writeln(Aliases.getInstance().load(ctx.prependCD(alt)));
            } else {
                ctx.writeln(Aliases.getInstance().load());
            }
            for (String alias : Aliases.getInstance().getAliases()) {
                Alias aliasObj = Aliases.getInstance().get(alias);
                Query query = this.getQuery(aliasObj, conn);
                if (aliasObj.isPredefined() || query == null || query.getBinds() == null || query.getBinds().size() != 0 || query.getSql() == null || !query.getSql().contains(":")) continue;
                List<Bind> binds = this.parseBinds(ctx, query.getSql());
                binds.forEach(bind -> query.addBind((Bind)bind));
            }
        } else {
            ctx.writeln(Messages.getString("AliasCommand.30"));
        }
    }

    private void handleSave(ScriptRunnerContext ctx, String alt) {
        if (ctx.getProperty("script.runner.jline") != null) {
            if (alt != null && !alt.isBlank()) {
                if (!(alt.startsWith("http://") || alt.startsWith("https://") || alt.startsWith("ftp://"))) {
                    alt = ctx.prependCD(alt);
                }
                ctx.writeln(Aliases.getInstance().save(alt));
            } else {
                ctx.writeln(Aliases.getInstance().save());
            }
        } else {
            ctx.writeln(Messages.getString("AliasCommand.29"));
        }
    }

    private void handleDrop(ScriptRunnerContext ctx, String aliasName, boolean silent) {
        String message = Aliases.getInstance().drop(aliasName);
        if (!silent) {
            ctx.writeln(message);
        }
    }

    private void handleGroups(ScriptRunnerContext ctx) {
        ArrayList<String> aliases = Aliases.getInstance().getAliases();
        ArrayList<String> groups = new ArrayList<String>();
        HashSet<String> dedup = new HashSet<String>();
        for (String alias : aliases) {
            Alias current = Aliases.getInstance().get(alias);
            if (current.getGroup() == null || !dedup.add(current.getGroup())) continue;
            groups.add(current.getGroup());
        }
        groups.sort(null);
        try {
            ctx.writeln(this.printColumns(groups, ctx));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleSearch(Connection conn, ScriptRunnerContext ctx, String searchstring) {
        Object searchstring1 = searchstring.toUpperCase();
        searchstring1 = ((String)searchstring1).contains("*") ? ((String)searchstring1).replace("*", ".*") : ".*" + (String)searchstring1 + ".*";
        ArrayList<String> aliases = Aliases.getInstance().getAliases();
        ArrayList<String> searchResult = new ArrayList<String>();
        for (String alias : aliases) {
            Query query;
            Alias a = Aliases.getInstance().get(alias);
            if (alias.toUpperCase().matches((String)searchstring1) || a.getDesc() != null && a.getDesc().toUpperCase().matches((String)searchstring1)) {
                searchResult.add(alias);
                continue;
            }
            if (a.getQueries() == null || (query = this.getQuery(a, conn)) == null || query.getSql() == null || !query.getSql().toUpperCase().matches((String)searchstring1)) continue;
            searchResult.add(alias);
            break;
        }
        if (searchResult.isEmpty()) {
            ctx.writeln(MessageFormat.format(Messages.getString("AliasCommand.39"), searchstring));
            return;
        }
        try {
            ctx.writeln(this.printColumns(searchResult, ctx));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void handleDetails(Connection conn, ScriptRunnerContext ctx, String alias) {
        ArrayList<String> aliases = Aliases.getInstance().getAliases();
        if (aliases.contains(alias)) {
            Query query;
            String desc;
            Alias withProperties = Aliases.getInstance().get(alias);
            Object withProp = alias;
            if (withProperties.isNullDefaults()) {
                withProp = alias + " NULLDEFAULTS";
            }
            Object aliasdesc = withProp;
            String group = withProperties.getGroup();
            if (group != null && !group.isBlank()) {
                aliasdesc = (String)aliasdesc + " " + group;
            }
            if ((desc = withProperties.getDesc()) != null && !desc.isBlank()) {
                aliasdesc = (String)aliasdesc + " - " + desc;
            }
            if ((query = this.getQuery(withProperties, conn)) != null) {
                String line = new String(new char[((String)aliasdesc).length()]).replace("\u0000", "-");
                Object bindsDesc = "";
                List<Bind> binds = query.getBinds();
                if (binds != null && binds.size() > 0) {
                    bindsDesc = line + "\n";
                    for (Bind bind : binds) {
                        bindsDesc = (String)bindsDesc + "  " + bind.getName() + ": " + bind.getTooltip() + "\n";
                    }
                }
                ctx.write(MessageFormat.format("{0}\n{1}{2}\n", aliasdesc, bindsDesc, line));
                ctx.write(query.getSql() + "\n\n");
            }
        } else {
            ctx.writeln(MessageFormat.format(Messages.getString("AliasCommand.27"), alias));
        }
    }

    private List<Alias> findAliases(ScriptRunnerContext ctx, String group) {
        ArrayList<Alias> result = new ArrayList<Alias>();
        ArrayList<String> aliases = Aliases.getInstance().getAliases();
        for (String x : aliases) {
            Alias a = Aliases.getInstance().get(x);
            if (!"ALL".equalsIgnoreCase(group) && (group == null || !group.equalsIgnoreCase(a.getGroup())) && (group != null || a.isPredefined())) continue;
            result.add(a);
        }
        if (result.isEmpty()) {
            if ("ALL".equalsIgnoreCase(group)) {
                ctx.writeln(Messages.getString("AliasCommand.40"));
            } else if (group != null) {
                ctx.writeln(MessageFormat.format(Messages.getString("AliasCommand.42"), group));
            } else {
                ctx.writeln(Messages.getString("AliasCommand.41"));
            }
        }
        return result;
    }

    private void handleList(ScriptRunnerContext ctx, String group) {
        List<Alias> aliases = this.findAliases(ctx, group);
        if (aliases.isEmpty()) {
            return;
        }
        ArrayList<String[]> interrumSort = new ArrayList<String[]>();
        int i = 0;
        for (Alias a : aliases) {
            String[] tosort = new String[]{a.getName(), a.getGroup(), a.getDesc()};
            interrumSort.add(tosort);
            if (a.getName().length() <= i) continue;
            i = a.getName().length();
        }
        interrumSort.sort(new Comparator<String[]>(){

            public int nullFirst(String o1, String o2) {
                if (o1 == null && o2 != null) {
                    return "a".compareTo("b");
                }
                if (o1 != null && o2 != null) {
                    return o1.compareTo(o2);
                }
                if (o1 != null && o2 == null) {
                    return "b".compareTo("a");
                }
                return 0;
            }

            @Override
            public int compare(String[] o1, String[] o2) {
                int compare = this.nullFirst(o1[1], o2[1]);
                if (compare == 0) {
                    return this.nullFirst(o1[0], o2[0]);
                }
                return compare;
            }
        });
        for (String[] sorted : interrumSort) {
            String x = sorted[0];
            String sortedGroup = sorted[1];
            String desc = sorted[2];
            x = i < 30 && i > 0 ? String.format("%1$-" + i + "s", x) : String.format("%1$-30s", x);
            String thisGroup = sortedGroup;
            Object toWrite = x;
            String padGroup = thisGroup;
            if (padGroup != null) {
                padGroup = i < 20 ? String.format("%1$-" + i + "s", padGroup) : String.format("%1$-20s", padGroup);
            }
            if (thisGroup != null) {
                toWrite = (String)toWrite + " " + padGroup;
            }
            if (desc != null && desc.length() > 0) {
                toWrite = (String)toWrite + " - " + desc;
            }
            toWrite = (String)toWrite + "\n";
            ctx.write((String)toWrite);
        }
    }

    private void handleAlias(ScriptRunnerContext ctx, AliasCmdVal aliasCmdVal, String group, String desc, boolean nulldefaults, boolean silent) {
        if (aliasCmdVal != null && aliasCmdVal.listGroup == null) {
            String name = aliasCmdVal.alias.aliasName;
            String query = aliasCmdVal.alias.aliasQuery.replace(" = ", "=");
            this.handleAdd(ctx, group, name, nulldefaults, query, desc, silent);
        } else {
            this.handleListSimple(ctx, aliasCmdVal != null ? aliasCmdVal.listGroup : null);
        }
    }

    private void handleListSimple(ScriptRunnerContext ctx, String group) {
        List<Alias> aliases = this.findAliases(ctx, group);
        if (aliases.isEmpty()) {
            return;
        }
        ArrayList<String> depdupeCommands = new ArrayList<String>();
        for (Alias a : aliases) {
            depdupeCommands.add(a.getName());
        }
        Collections.sort(depdupeCommands);
        if (depdupeCommands != null && !depdupeCommands.isEmpty()) {
            depdupeCommands.remove("\n");
            depdupeCommands.remove("\n\n");
            depdupeCommands.remove(" ");
        }
        try {
            ctx.writeln(this.printColumns(depdupeCommands, ctx));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String printColumns(Collection<? extends CharSequence> items, ScriptRunnerContext ctx) throws IOException {
        StringBuilder s = new StringBuilder();
        if (items == null || items.isEmpty()) {
            return "";
        }
        int width = 82;
        if (ctx.isCommandLine() && ctx.getSQLPlusConsoleReader().getWidth() > width) {
            width = ctx.getSQLPlusConsoleReader().getWidth();
        }
        int maxWidth = 0;
        for (CharSequence charSequence : items) {
            maxWidth = Math.max(maxWidth, charSequence.length());
        }
        StringBuilder buff = new StringBuilder();
        int n = width / (maxWidth += 3);
        int col = 0;
        for (CharSequence charSequence : items) {
            int i;
            String name = charSequence.toString();
            if (col < n) {
                buff.append(name);
                for (i = 0; i < maxWidth - charSequence.length(); ++i) {
                    buff.append(' ');
                }
                ++col;
                continue;
            }
            s.append(buff.toString() + "\n");
            buff.setLength(0);
            col = 0;
            buff.append(name);
            for (i = 0; i < maxWidth - charSequence.length(); ++i) {
                buff.append(' ');
            }
            ++col;
        }
        if (buff.length() > 0) {
            s.append(buff.toString());
        }
        return s.toString();
    }

    private List<Bind> parseBinds(ScriptRunnerContext ctx, String query) {
        ScriptParser sp = new ScriptParser(query);
        sp.setScriptRunnerContext(ctx);
        ArrayList<Bind> binds = new ArrayList<Bind>();
        try {
            ISQLCommand icmd = sp.next();
            ArrayList<Bind> parserBinds = Parser.getInstance().getBinds(icmd.getSql(), false);
            for (Bind parserBind : parserBinds) {
                if ("SPECIALBINDFORALIASNULLS".equalsIgnoreCase(parserBind.getName())) continue;
                binds.add(parserBind);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return binds;
    }

    private Query getQuery(Alias aliasObj, Connection conn) {
        if (conn != null) {
            ConnectionIdentifier connId = DefaultConnectionIdentifier.createIdentifier(conn);
            return aliasObj.getQueries().getQuery(connId);
        }
        return aliasObj.getQueries().getQuery(new Version("8"));
    }

    public static enum Symbol implements Id
    {
        ALIAS,
        LIST,
        DETAILS,
        GROUPS,
        DROP,
        SAVE,
        LOAD,
        SEARCH,
        FILENAME,
        NAME,
        GROUP,
        SILENT,
        DESC,
        NULLDEFAULTS,
        QUERY,
        SEARCHSTRING;

    }

    private static class AliasCmdVal {
        String listGroup;
        AliasVal alias;

        AliasCmdVal(Node node, TransformContext context, Environment environment) {
            Object obj = node.getValue();
            if (obj instanceof AliasVal) {
                this.alias = (AliasVal)node.getValue();
            } else {
                this.listGroup = (String)node.getValue();
            }
        }
    }

    public static enum GrammarSymbol implements Id
    {
        AliasCmdRule;

    }

    private static class AliasVal {
        String aliasName;
        String aliasQuery;

        AliasVal(List<Node> nodes, TransformContext context, Environment environment) {
            this.aliasName = (String)nodes.get(0).getValue();
            this.aliasQuery = (String)nodes.get(2).getValue();
        }
    }
}

