/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.AForAllStmtsCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class SetNewPage
extends AForAllStmtsCommand {
    private static final SQLCommand.StmtSubType m_cmdStmtSubType = SQLCommand.StmtSubType.G_S_SET_NEW_PAGE;

    public SetNewPage() {
        super(m_cmdStmtSubType);
    }

    @Override
    protected boolean doHandleCmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getProperty("prop_file_string") != null) {
            String str = cmd.getSql();
            str = str.trim().replaceAll("^(?i:set\\s+newp)(?i:|a|ag|age)\\s+", "").trim();
            if ((str = str.replaceAll("['\"]", "")).equalsIgnoreCase("NONE")) {
                ctx.putProperty("script.runner.newpage", "NONE");
                return true;
            }
            if (str.length() > 0 && str.split("\\s+").length >= 1) {
                String[] options = str.split("\\s+");
                String option1 = options[0];
                String rest = str.substring(option1.length(), str.length());
                try {
                    int x = new Integer(option1);
                    if (rest.trim().length() > 0) {
                        ctx.write(MessageFormat.format(Messages.getString("SetNewPage.6"), rest.trim()));
                        ctx.write(Messages.getString("SetNewPage.USAGE_HELP"));
                        return true;
                    }
                    if (x < 0 || x > 999) {
                        ctx.write(MessageFormat.format(Messages.getString("SetNewPage.0"), String.valueOf(x)));
                        return true;
                    }
                    ctx.putProperty("script.runner.newpage", x);
                }
                catch (NumberFormatException e) {
                    ctx.write(MessageFormat.format(Messages.getString("SetNewPage.3"), option1));
                    ctx.write(Messages.getString("SetNewPage.USAGE_HELP"));
                }
            } else {
                ctx.putProperty("script.runner.newpage", 0);
                return true;
            }
        }
        return true;
    }
}

