/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class SetCloseCursor
extends CommandListener
implements IShowCommand {
    String[] aliases = new String[]{"closecursor", "closecurso", "closecurs", "closecur"};

    @Override
    public String[] getShowAliases() {
        return this.aliases;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!ctx.isSQLPlusClassic()) {
            ctx.write(MessageFormat.format(Messages.getString("SetSecuredCol.0"), cmd.getSql()));
            return true;
        }
        if (ctx.getProperty("script.runner.set_xmlformat") != null) {
            String on = "OFF";
            boolean x = (Boolean)ctx.getProperty("script.runner.set_xmlformat");
            on = x ? "ON" : "OFF";
            ctx.write(MessageFormat.format(Messages.getString("SetCloseCursor.7"), on));
        }
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!ctx.isSQLPlusClassic()) {
            ctx.write(MessageFormat.format(Messages.getString("SetSecuredCol.0"), cmd.getSql()));
            return true;
        }
        String sql = cmd.getSql();
        String[] tokens = sql.split("\\s+");
        if (tokens.length != 3) {
            ctx.write(Messages.getString("SetCloseCursor.9"));
        } else {
            String token = tokens[2];
            if (token.toLowerCase().equals("on") || token.toLowerCase().equals("off")) {
                boolean x = token.toLowerCase().equals("on") ? Boolean.TRUE : Boolean.FALSE;
                ctx.putProperty("script.runner.set_xmlformat", x);
            } else {
                ctx.write(Messages.getString("SetCloseCursor.0"));
            }
        }
        return true;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

