/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.statement;

import java.sql.Statement;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.BindingStrategy;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypePlatformException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.PLSQLBoundBlockBuilder;
import oracle.jdbc.OracleCallableStatement;

public abstract class StatementBindingBase<S extends Statement, P extends DataBinding>
implements BindingStrategy<S, P> {
    private static final String FMT = "%1$-15s %2$-15s %3$-6s %4$-40s\n";
    private final P param;
    private final BindingMode mode;
    private final DataType dataType;
    private final BindContext<S> context;
    private String byPositionBindToken;
    private String byNameBindToken;

    protected StatementBindingBase(BindContext<S> context, P param, DataType dataType, BindingMode mode) {
        this.param = param;
        this.dataType = dataType;
        this.mode = mode;
        this.context = context;
        this.byPositionBindToken = null;
        this.byNameBindToken = null;
    }

    @Override
    public void setByNameBindToken(String bindToken) {
        this.byNameBindToken = bindToken;
    }

    @Override
    public String getByNameBindToken() {
        return this.byNameBindToken;
    }

    @Override
    public void setByPositionBindToken(String bindToken) {
        this.byPositionBindToken = bindToken;
    }

    @Override
    public String getByPositionBindToken() {
        if (this.byPositionBindToken == null) {
            this.byPositionBindToken = this.context.nextBindToken();
        }
        return this.byPositionBindToken;
    }

    protected int remapPosition(String bindToken) {
        int index = this.context.remapPosition(bindToken);
        if (index == -1) {
            index = this.context.remapPosition(this.getByPositionBindToken());
        }
        return index;
    }

    @Override
    public BindContext<S> getBindContext() {
        return this.context;
    }

    @Override
    public final P getParameter() {
        return this.param;
    }

    @Override
    public final DataType getDataType() {
        return this.dataType;
    }

    @Override
    public final BindingMode getMode() {
        return this.mode;
    }

    @Override
    public final S getStatement() {
        return this.getBindContext().getStatement();
    }

    protected final void setStatement(S stmt) {
        try {
            this.getBindContext().setStatement(stmt);
        }
        catch (ClassCastException e) {
            throw new DataTypePlatformException(OracleCallableStatement.class);
        }
    }

    @Override
    public final void reportBinding(StringBuilder buffer, DataValue value) {
        this.customReportBinding(buffer, value);
    }

    @Override
    public final void reportBinding(StringBuilder buffer, String nullToken, DataValue value) {
        this.customReportBinding(buffer, nullToken, value);
    }

    protected void customReportBinding(StringBuilder buffer, DataValue value) {
        this.customReportBinding(buffer, null, value);
    }

    protected abstract void customReportBinding(StringBuilder var1, String var2, DataValue var3);

    protected final void reportBinding(StringBuilder buffer, String nullToken, String bindToken, DataType dataType, BindingMode mode, String value) {
        String debugValue;
        String string = mode == BindingMode.OUT ? nullToken : (debugValue = value == null ? nullToken : value);
        if (bindToken != null) {
            String inOut = mode.toString();
            buffer.append(String.format(FMT, bindToken, dataType.getPlainDataTypeString(), inOut, debugValue));
        }
    }

    @Override
    public boolean isSupported(BindingMode mode) {
        return this.getDataType().isSupported();
    }

    @Override
    public final PLSQLBoundBlockBuilder getBuilder() {
        return this.getBuilder(new PLSQLBoundBlockBuilder());
    }

    @Override
    public final PLSQLBoundBlockBuilder getBuilder(PLSQLBoundBlockBuilder builder) {
        return this.customBuilder(builder);
    }

    protected abstract PLSQLBoundBlockBuilder customBuilder(PLSQLBoundBlockBuilder var1);

    @Override
    public void uncacheInput() {
        this.getBindContext().uncacheInput(this);
    }

    @Override
    public void uncacheOutput() {
        this.getBindContext().uncacheOutput(this);
    }

    @Override
    public void uncacheValues() {
        this.getBindContext().uncacheValues(this);
    }
}

