/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.callablestatement;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataTypeIOException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.objects.LongVarchar;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingDatum;
import oracle.jdbc.OracleCallableStatement;

public class CallableBindingLONGVARCHAR<S extends OracleCallableStatement, P extends DataBinding>
extends CallableBindingDatum<S, P> {
    public CallableBindingLONGVARCHAR(BindContext<S> context, P param) {
        super(context, param);
    }

    @Override
    protected void customBindIN(DataValue value, int pos) throws SQLException {
        LongVarchar longVarchar = (LongVarchar)value.getTypedValue(this.getBindContext().getDataTypeConnectionProvider(), ValueType.DEFAULT);
        if (longVarchar != null && !longVarchar.isNull()) {
            try {
                ((OracleCallableStatement)this.getStatement()).setCharacterStream(pos, longVarchar.getReader(), (int)longVarchar.getLength());
            }
            catch (IOException e) {
                throw new DataTypeIOException(e);
            }
        } else {
            ((OracleCallableStatement)this.getStatement()).setNull(pos, this.getDataType().getSqlDataType(ValueType.JDBC));
        }
    }

    @Override
    protected DataValue customOutput(int pos) throws SQLException {
        Reader reader = ((OracleCallableStatement)this.getStatement()).getCharacterStream(pos);
        return this.getDataType().getDataValue(reader);
    }
}

