/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.objects.LargeVarchar;
import oracle.sql.Datum;

public class LongVarchar
extends LargeVarchar {
    public LongVarchar() {
    }

    protected LongVarchar(LongVarchar source) {
        super(source);
    }

    protected LongVarchar(Object object) {
        super(object);
    }

    public LongVarchar(CharSequence value) {
        super(value.toString());
    }

    public LongVarchar(File value) {
        super(value);
    }

    public LongVarchar(Reader reader) throws IOException {
        new LongVarchar();
        this(LongVarchar.getBuilder().write(reader).build());
    }

    public LongVarchar(Reader reader, int cutOverLen) throws IOException {
        new LongVarchar();
        this(LongVarchar.getBuilder(cutOverLen).write(reader).build());
    }

    public static LongVarchar constructFrom(Object value) throws IOException, SQLException {
        return LongVarchar.constructFrom(value, 32768);
    }

    public static LongVarchar constructFrom(Object value, int cutOverLen) throws IOException, SQLException {
        if (value instanceof char[]) {
            return new LongVarchar(String.valueOf((char[])value));
        }
        if (value instanceof CharSequence) {
            return new LongVarchar((CharSequence)value);
        }
        if (value instanceof File) {
            return new LongVarchar((File)value);
        }
        if (value instanceof Reader) {
            return new LongVarchar((Reader)value, cutOverLen);
        }
        if (value instanceof Datum) {
            Datum datumValue = (Datum)value;
            return new LongVarchar(datumValue.stringValue());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public long getLength() throws SQLException {
        if (this.getValue() instanceof File) {
            return ((File)this.getValue()).length();
        }
        if (this.getValue() instanceof CharSequence) {
            return ((CharSequence)this.getValue()).length();
        }
        return 0L;
    }

    @Override
    public boolean equals(Object obj) {
        boolean isEqual;
        boolean bl = isEqual = this == obj;
        if (!isEqual && obj instanceof LongVarchar) {
            isEqual = super.equals(obj);
        }
        return isEqual;
    }

    @Override
    public Reader getReader() throws IOException, SQLException {
        if (this.getValue() instanceof File) {
            return new FileReader((File)this.getValue());
        }
        if (this.getValue() instanceof CharSequence) {
            return new StringReader(((CharSequence)this.getValue()).toString());
        }
        return null;
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, ValueType valueType, Object target) throws IOException, SQLException {
        switch (valueType) {
            case JDBC: {
                return this.getReader();
            }
        }
        return super.customTypedValue(connectionProvider, valueType, target);
    }

    public static LongVarcharBuilder getBuilder() {
        return LongVarchar.getBuilder(32768);
    }

    public static LongVarcharBuilder getBuilder(int cutOverLen) {
        return new LongVarchar().getBuilder0(cutOverLen);
    }

    private LongVarcharBuilder getBuilder0(int cutOverLen) {
        return new LongVarcharBuilder(cutOverLen);
    }

    @Override
    protected void customFinalize(Object value, boolean deleteOnFinalize) throws Throwable {
        try {
            if (deleteOnFinalize && value instanceof File) {
                ((File)value).delete();
            }
        }
        finally {
            super.customFinalize(value, deleteOnFinalize);
        }
    }

    public class LongVarcharBuilder
    extends LargeVarchar.LargeVarcharBuilder {
        protected LongVarcharBuilder(int cutOverLen) {
            super(new StringWriter(), cutOverLen);
        }

        @Override
        public LongVarcharBuilder write(Reader reader) throws IOException {
            return (LongVarcharBuilder)super.write(reader);
        }

        @Override
        public LongVarchar build() throws IOException {
            this.writer.flush();
            this.writer.close();
            if (LongVarchar.this.getValue() != null && LongVarchar.this.getValue() instanceof File) {
                File file = (File)LongVarchar.this.getValue();
                file.setReadOnly();
            } else {
                LongVarchar.this.setValue(this.writer.toString(), false);
            }
            this.writer = null;
            return LongVarchar.this;
        }

        @Override
        protected void cutOver() throws IOException {
            this.writer.flush();
            this.writer.close();
            StringReader sr = new StringReader(this.writer.toString());
            File tempFile = File.createTempFile("sqldev", ".tmp");
            tempFile.deleteOnExit();
            FileWriter fw = new FileWriter(tempFile);
            LargeVarchar.copyCharacters((Reader)sr, fw);
            ((Writer)fw).flush();
            LongVarchar.this.setValue(tempFile, true);
            this.writer = fw;
        }
    }
}

