/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.objects.LongVarchar;
import oracle.jdbc.OracleConnection;
import oracle.sql.CLOB;
import oracle.sql.Datum;

public class ClobDatum
extends LongVarchar {
    public ClobDatum() {
    }

    protected ClobDatum(ClobDatum source) {
        super(source);
    }

    protected ClobDatum(Object object) {
        super(object);
    }

    public ClobDatum(Clob value) throws SQLException {
        super(value);
    }

    public ClobDatum(CharSequence value) {
        super(value);
    }

    public ClobDatum(File value) {
        super(value);
    }

    public ClobDatum(Reader reader) throws IOException {
        new ClobDatum();
        this(ClobDatum.getBuilder().write(reader).build());
    }

    public ClobDatum(Reader reader, int cutOverLen) throws IOException {
        new ClobDatum();
        this(ClobDatum.getBuilder(cutOverLen).write(reader).build());
    }

    public static ClobDatum constructFrom(Object value) throws IOException, SQLException {
        if (value instanceof Clob) {
            return new ClobDatum((Clob)value);
        }
        if (value instanceof char[]) {
            return new ClobDatum(String.valueOf((char[])value));
        }
        if (value instanceof CharSequence) {
            return new ClobDatum((CharSequence)value);
        }
        if (value instanceof File) {
            return new ClobDatum((File)value);
        }
        if (value instanceof Reader) {
            return new ClobDatum((Reader)value);
        }
        if (value instanceof Datum) {
            Datum datumValue = (Datum)value;
            return new ClobDatum(datumValue.stringValue());
        }
        throw new IllegalArgumentException();
    }

    @Override
    public long getLength() throws SQLException {
        if (this.getValue() instanceof Clob) {
            Clob clob = (Clob)this.getValue();
            if (ClobDatum.isEmptyLob(clob)) {
                return 0L;
            }
            return ((Clob)this.getValue()).length();
        }
        return super.getLength();
    }

    @Override
    public boolean equals(Object obj) {
        boolean isEqual;
        boolean bl = isEqual = this == obj;
        if (!isEqual && obj instanceof ClobDatum) {
            isEqual = super.equals(obj);
        }
        return isEqual;
    }

    @Override
    public Reader getReader() throws IOException, SQLException {
        if (this.getValue() instanceof Clob) {
            Clob clob = (Clob)this.getValue();
            if (ClobDatum.isEmptyLob(clob)) {
                return new StringReader("");
            }
            return clob.getCharacterStream();
        }
        return super.getReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, ValueType valueType, Object target) throws IOException, SQLException {
        Object value = this.getValue();
        switch (valueType) {
            case DATUM: {
                if (value instanceof Clob) {
                    return value;
                }
                Clob tempClob = ClobDatum.getTemporaryClob(connectionProvider.getValidDataTypeConnection());
                ClobDatum.open(tempClob, 1);
                try {
                    Writer writer = tempClob.setCharacterStream(1L);
                    ClobDatum.copyCharacters(this.getReader(), writer);
                    writer.close();
                }
                finally {
                    try {
                        ClobDatum.close(tempClob);
                    }
                    catch (SQLException e) {
                        Logger.getLogger(ClobDatum.class.getName()).log(Level.WARNING, e.getLocalizedMessage(), e);
                    }
                }
                return tempClob;
            }
        }
        return super.customTypedValue(connectionProvider, valueType, target);
    }

    public static ClobDatumBuilder getBuilder() {
        return ClobDatum.getBuilder(32768);
    }

    private ClobDatumBuilder getBuilder0(int cutOverLen) {
        return new ClobDatumBuilder(cutOverLen);
    }

    public static ClobDatumBuilder getBuilder(int cutOverLen) {
        return new ClobDatum().getBuilder0(cutOverLen);
    }

    protected static Clob getTemporaryClob(Connection connection) throws SQLException {
        if (connection instanceof OracleConnection) {
            return CLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
        }
        return connection.createClob();
    }

    protected static Clob getEmptyClob(Connection connection) throws SQLException {
        if (connection instanceof OracleConnection) {
            return CLOB.getEmptyCLOB();
        }
        return ClobDatum.getTemporaryClob(connection);
    }

    protected static boolean isEmptyLob(Clob clob) throws SQLException {
        if (clob instanceof CLOB) {
            return ((CLOB)clob).isEmptyLob();
        }
        return false;
    }

    protected static void open(Clob clob, int mode) throws SQLException {
        CLOB oraCLOB;
        if (clob instanceof CLOB && !(oraCLOB = (CLOB)clob).isEmptyLob() && !oraCLOB.isOpen()) {
            oraCLOB.open(mode);
        }
    }

    protected static void close(Clob clob) throws SQLException {
        CLOB oraCLOB;
        if (clob instanceof CLOB && !(oraCLOB = (CLOB)clob).isEmptyLob() && oraCLOB.isOpen()) {
            oraCLOB.close();
        }
    }

    protected static void free(Clob clob) throws SQLException {
        CLOB oraCLOB;
        if (clob instanceof CLOB && (oraCLOB = (CLOB)clob).isTemporary() && !oraCLOB.isOpen()) {
            oraCLOB.freeTemporary();
        }
        clob.free();
    }

    public class ClobDatumBuilder
    extends LongVarchar.LongVarcharBuilder {
        protected ClobDatumBuilder(int cutOverLen) {
            super(ClobDatum.this, cutOverLen);
        }

        @Override
        public ClobDatumBuilder write(Reader reader) throws IOException {
            return (ClobDatumBuilder)super.write(reader);
        }

        @Override
        public ClobDatum build() throws IOException {
            super.build();
            return ClobDatum.this;
        }
    }
}

