/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.metadata;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import oracle.dbtools.raptor.datatypes.StructureType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.metadata.ArgMetadata;
import oracle.dbtools.raptor.datatypes.metadata.LoadedArgMetadata;
import oracle.dbtools.raptor.datatypes.metadata.MetadataLoader;
import oracle.dbtools.raptor.datatypes.metadata.ProgMetadata;
import oracle.dbtools.raptor.datatypes.metadata.SigMetadata;

public final class PLSQMetadataBuilder {
    final Map<ProgMetadata.ProgIdentifier, ProgMetadata> programs;
    final Deque<ArgMetadata> argStack;
    final Deque<LoadedArgMetadata> loadStack;
    final MetadataLoader loader;
    ProgMetadata program;
    SigMetadata signature;

    public PLSQMetadataBuilder(Connection conn) {
        this.loader = new MetadataLoader(conn);
        this.argStack = new LinkedList<ArgMetadata>();
        this.loadStack = new LinkedList<LoadedArgMetadata>();
        this.programs = new HashMap<ProgMetadata.ProgIdentifier, ProgMetadata>();
        this.program = null;
        this.signature = null;
    }

    public Map<ProgMetadata.ProgIdentifier, ProgMetadata> createArguments(String _objName, String _objOwner, String _objCall, Integer _objOverload) throws SQLException {
        this.loader.loadSignatureArguments(this.loadStack, _objName, _objOwner, _objCall, _objOverload);
        this.buildArguments();
        return this.programs;
    }

    private void buildArguments() throws SQLException {
        while (!this.loadStack.isEmpty() || !this.argStack.isEmpty()) {
            boolean proceed = true;
            if (!this.loadStack.isEmpty()) {
                LoadedArgMetadata loadedArgMetadata = this.loadStack.pop();
                proceed = this.pushArgMetadata(loadedArgMetadata);
                continue;
            }
            boolean bl = this.rollupProgram();
        }
        this.rollupProgram();
    }

    private boolean pushArgMetadata(LoadedArgMetadata loadedArgMetadata) throws SQLException {
        boolean proceed = true;
        proceed = this.switchTo(loadedArgMetadata);
        if (proceed) {
            proceed = this.rollupArgStack(loadedArgMetadata);
        }
        if (proceed && loadedArgMetadata.argMetadata != null) {
            this.argStack.push(loadedArgMetadata.argMetadata);
        }
        return proceed;
    }

    private boolean rollupArgStack(LoadedArgMetadata loadedArgMetadata) throws SQLException {
        Integer level = loadedArgMetadata != null && loadedArgMetadata.argMetadata != null ? loadedArgMetadata.argMetadata.identifier.getLevel() : -1;
        while (!this.argStack.isEmpty()) {
            StructureType structureType;
            boolean tryRollup;
            ArgMetadata top = this.argStack.peek();
            boolean forced = level != null && level == -1;
            boolean bl = tryRollup = forced || top.identifier.getLevel() == null || level <= top.identifier.getLevel();
            if (!tryRollup) break;
            if (!this.hasArgComponents(top) && (structureType = this.getArgStructureType(top)) != StructureType.PRIMITIVE) {
                if (loadedArgMetadata != null) {
                    this.loadStack.push(loadedArgMetadata);
                }
                int startingSize = this.loadStack.size();
                if (this.loadStack.size() > startingSize) {
                    LoadedArgMetadata parent = this.loadStack.pop();
                    this.refineDataType(top, parent);
                    return false;
                }
                if (this.loadStack.size() == startingSize && loadedArgMetadata != null) {
                    this.loadStack.pop();
                }
            }
            ArgMetadata arg = this.argStack.pop();
            if (this.argStack.isEmpty()) {
                this.signature.addArgument(arg);
                continue;
            }
            this.argStack.peek().addComponent(arg);
        }
        return true;
    }

    private boolean rollupArgStack() throws SQLException {
        return this.rollupArgStack(null);
    }

    private boolean rollupSignature() throws SQLException {
        boolean proceed = true;
        if (this.signature != null && (proceed = this.rollupArgStack())) {
            this.program.addSignature(this.signature);
            this.signature = null;
        }
        return proceed;
    }

    private boolean rollupProgram() throws SQLException {
        boolean proceed = true;
        if (this.program != null && (proceed = this.rollupSignature())) {
            this.programs.put(this.program.getIdentifier(), this.program);
            this.program = null;
        }
        return proceed;
    }

    private StructureType getArgStructureType(ArgMetadata argMetadata) {
        String dataType = (String)((Map)argMetadata.getValue()).get((Object)TypeMetadata.Attribute.DATA_TYPE);
        if (dataType != null) {
            if (dataType.equals("PL/SQL RECORD") || dataType.equals("OBJECT")) {
                return StructureType.RECORD;
            }
            if (dataType.equals("PL/SQL TABLE") || dataType.equals("PL/SQL INDEX TABLE") || dataType.equals("COLLECTION") || dataType.equals("TABLE") || dataType.equals("VARRAY")) {
                return StructureType.TABLE;
            }
        }
        return StructureType.PRIMITIVE;
    }

    private void refineDataType(ArgMetadata target, LoadedArgMetadata source) {
        String dataType = (String)((Map)source.argMetadata.getValue()).get((Object)TypeMetadata.Attribute.DATA_TYPE);
        if (dataType != null) {
            ((Map)target.getValue()).put(TypeMetadata.Attribute.DATA_TYPE, dataType);
        }
    }

    private boolean hasArgComponents(ArgMetadata argMetadata) {
        return argMetadata.hasComponents();
    }

    private SigMetadata findOrCreateSig(SigMetadata.SigIdentifier sigIdentifier, ProgMetadata program) {
        SigMetadata signature = program.getSignature(sigIdentifier.overload);
        if (signature == null) {
            signature = new SigMetadata(sigIdentifier);
        } else {
            SigMetadata.SigMatch implMatches = signature.identifiedBy(sigIdentifier);
            if (implMatches == SigMetadata.SigMatch.SOFT_MATCHED) {
                signature.identifier = sigIdentifier;
            }
        }
        return signature;
    }

    private ProgMetadata findOrCreateProg(ProgMetadata.ProgIdentifier progIdentifier) {
        ProgMetadata program = this.programs.get(progIdentifier);
        if (program == null) {
            program = new ProgMetadata(progIdentifier);
        }
        return program;
    }

    private boolean switchTo(LoadedArgMetadata loadedArgMetadata) throws SQLException {
        boolean proceed = true;
        ProgMetadata.ProgIdentifier progIdentifier = loadedArgMetadata.progIdentifier;
        SigMetadata.SigIdentifier sigIdentifier = loadedArgMetadata.sigIdentifier;
        if (sigIdentifier != null && this.signature != null && proceed) {
            SigMetadata.SigMatch implMatches = this.signature.identifiedBy(sigIdentifier);
            switch (implMatches) {
                case SOFT_MATCHED: {
                    if (sigIdentifier == null) break;
                    this.signature.identifier = sigIdentifier;
                    break;
                }
                case DIFFERENT: {
                    proceed = this.rollupSignature();
                }
            }
        }
        if (progIdentifier != null && this.program != null && proceed && !this.program.identifiedBy(progIdentifier)) {
            proceed = this.rollupProgram();
        }
        if (proceed) {
            if (this.program == null) {
                this.program = this.findOrCreateProg(progIdentifier);
            }
            if (this.signature == null) {
                this.signature = this.findOrCreateSig(sigIdentifier, this.program);
            }
        }
        return proceed;
    }
}

