/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.dictionary;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.util.Service;

public class Item
implements Comparable<Item> {
    public String name;
    public String type;
    public String owner;
    public static String LIMIT_TYPE = "LIMIT_TYPE";
    public static Item MORE = new Item("...", LIMIT_TYPE, null);
    static final Map<String, Integer> orderedTypes = new HashMap<String, Integer>();

    public Item(String name, String type, String owner) {
        this.name = LIMIT_TYPE.equals(type) ? name : Service.addDoubleQuote((String)name);
        this.type = type;
        this.owner = Service.addDoubleQuote((String)owner);
    }

    public String toString() {
        return (this.owner != null ? this.owner : "") + "." + this.type + "." + this.name;
    }

    public boolean secondClassCitizen() {
        if (orderedTypes.get(this.type) == 0) {
            return true;
        }
        return 7 < orderedTypes.get(this.type);
    }

    @Override
    public int compareTo(Item that) {
        Integer thatOrd;
        Integer thisOrd = orderedTypes.get(this.type);
        if (thisOrd == null) {
            thisOrd = 999;
        }
        if ((thatOrd = orderedTypes.get(that.type)) == null) {
            thatOrd = 999;
        }
        return thisOrd - thatOrd;
    }

    public String pluralType() {
        if ("INDEX".equalsIgnoreCase(this.type)) {
            return "INDEXES";
        }
        if ("DICTIONARY".equalsIgnoreCase(this.type)) {
            return "DICTIONARIES";
        }
        if ("PACKAGE BODY".equalsIgnoreCase(this.type)) {
            return "PACKAGE BODIES";
        }
        return this.type + "S";
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    static {
        int order = 0;
        orderedTypes.put("SYNONYM", order++);
        orderedTypes.put("TABLE", order++);
        orderedTypes.put("VIEW", order++);
        orderedTypes.put("PACKAGE", order++);
        orderedTypes.put("PACKAGE BODY", order++);
        orderedTypes.put("PROCEDURE", order++);
        orderedTypes.put("FUNCTION", order++);
        orderedTypes.put("TRIGGER", order++);
        orderedTypes.put("TYPE", order++);
        orderedTypes.put("INDEX", order++);
        orderedTypes.put("MATERIALIZED VIEW", order++);
        orderedTypes.put("MATERIALIZED VIEW LOG", order++);
        orderedTypes.put("OPERATOR", order++);
        orderedTypes.put("QUEUE", order++);
        orderedTypes.put("QUEUE TABLES", order++);
        orderedTypes.put("SEQUENCES", order++);
        orderedTypes.put("DATABASE LINKS", order++);
        orderedTypes.put("DIRECTORIES", order++);
        orderedTypes.put("EDITIONS", order++);
        orderedTypes.put("PUBLIC SYNONYMS", order++);
        orderedTypes.put(LIMIT_TYPE, 999);
    }
}

