/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.validators;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import oracle.dbtools.data.model.Column;
import oracle.dbtools.data.validators.BaseValidator;

public class NumberValidator
extends BaseValidator {
    Character _nlsDecimalSeparator;

    public void setNlsDecimalSeparator(Character nlsDecimalSeparator) {
        this._nlsDecimalSeparator = nlsDecimalSeparator;
    }

    @Override
    public boolean validateData(Column c, Object data) {
        if (data == null || data.toString().length() == 0) {
            return c.isNullable();
        }
        Object result = "";
        String dataStr = data.toString();
        DecimalFormat fmt = null;
        ParsePosition pp = new ParsePosition(0);
        fmt = this._l != null ? (DecimalFormat)DecimalFormat.getInstance(this._l) : (DecimalFormat)DecimalFormat.getInstance();
        if (this._nlsDecimalSeparator != null && fmt instanceof DecimalFormat) {
            DecimalFormatSymbols symbols = fmt.getDecimalFormatSymbols();
            symbols.setDecimalSeparator(this._nlsDecimalSeparator.charValue());
            fmt.setDecimalFormatSymbols(symbols);
        }
        try {
            fmt.setParseBigDecimal(true);
            result = ((BigDecimal)fmt.parse(dataStr, pp)).toPlainString();
        }
        catch (Exception e) {
            return false;
        }
        if (pp.getIndex() < dataStr.length()) {
            return false;
        }
        if (((String)result).length() == 0) {
            return false;
        }
        if (c.getType().equalsIgnoreCase("BINARY_DOUBLE")) {
            try {
                Double.parseDouble((String)result);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        if (c.getType().equalsIgnoreCase("BINARY_FLOAT")) {
            try {
                Float.parseFloat((String)result);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        int decPos = ((String)result).lastIndexOf(".");
        if (decPos < 0) {
            if (c.getPrecision() == 0) {
                return ((String)result).length() <= 38;
            }
            if (((String)result).length() > c.getPrecision()) {
                return false;
            }
        } else {
            try {
                int scale;
                Float floatResult;
                int intResult;
                if (c.getPrecision() == 0 && c.getScale() >= 0) {
                    return decPos <= 38;
                }
                if (c.getPrecision() > c.getScale() && c.getPrecision() - c.getScale() < decPos) {
                    return false;
                }
                if (c.getScale() <= 0 && (float)(intResult = (floatResult = Float.valueOf(Float.parseFloat((String)result))).intValue()) == floatResult.floatValue()) {
                    return true;
                }
                if (c.getScale() < 0 ? (scale = c.getScale() * -1) < ((String)result).length() - decPos - 1 : c.getScale() < ((String)result).length() - decPos - 1) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }
}

