/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections.db.ora;

import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.connections.db.ConnectionCreator;
import oracle.dbtools.connections.db.DatabaseProvider;

public class OracleConnectionUtils {
    public static String scrubOraDriverType(String url) {
        String oraDriverType = "";
        if (url != null && url.startsWith("jdbc:oracle")) {
            String[] specElements;
            int idx = url.indexOf("@");
            String spec = url.substring(0, idx);
            if (spec.endsWith("/")) {
                spec = spec.substring(0, spec.length() - 1);
            }
            if ((specElements = spec.split(":")).length == 3) {
                oraDriverType = specElements[2];
            }
        }
        return oraDriverType;
    }

    public static String getThinUrl(Properties props) throws SQLException {
        String url = props.getProperty("customUrl");
        Properties connProps = new Properties();
        connProps.putAll((Map<?, ?>)props);
        if (ModelUtil.hasLength(url)) {
            if (OracleConnectionUtils.scrubOraDriverType(url).equals("oci8")) {
                connProps.setProperty("oraDriverType", "thin");
                connProps.remove("customUrl");
                return OracleConnectionUtils.getConnectionURL(connProps);
            }
        } else {
            connProps.setProperty("oraDriverType", "thin");
            return OracleConnectionUtils.getConnectionURL(connProps);
        }
        return url;
    }

    public static String getOCIUrl(Properties props) throws SQLException {
        String url = props.getProperty("customUrl");
        Properties connProps = new Properties();
        connProps.putAll((Map<?, ?>)props);
        if (ModelUtil.hasLength(url)) {
            if (OracleConnectionUtils.scrubOraDriverType(url).equals("thin")) {
                Object retUrl = null;
                connProps.setProperty("oraDriverType", "oci8");
                connProps.remove("customUrl");
                retUrl = url.toLowerCase().replaceAll("\\s", "").matches("^[^@]*@\\(description=.*") ? "jdbc:oracle:oci8:" + url.substring(url.indexOf("@")) : OracleConnectionUtils.getConnectionURL(connProps);
                return retUrl;
            }
        } else {
            connProps.setProperty("oraDriverType", "oci8");
            return OracleConnectionUtils.getConnectionURL(connProps);
        }
        return url;
    }

    private static String getConnectionURL(Properties props) throws SQLException {
        ConnectionCreator creator = DatabaseProvider.getCreator("oraJDBC");
        return creator.getConnectionURL(props);
    }
}

