/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.dbtools.app.injection.Dotted;
import oracle.dbtools.app.injection.FuncFormal;
import oracle.dbtools.app.injection.Loc;
import oracle.dbtools.app.injection.ParmSpec;
import oracle.dbtools.app.injection.PlsqlType;
import oracle.dbtools.app.injection.RowMapper;
import oracle.dbtools.app.injection.SqlInjectionAnalysisFailure;
import oracle.dbtools.app.injection.SqlInjectionGraph;
import oracle.dbtools.app.injection.Symbol;
import oracle.dbtools.app.injection.SymbolTable;
import oracle.dbtools.db.DBUtil;

public class LoadDbRefs {
    private final Connection m_conn;
    private final DBUtil dbUtil;
    ConcurrentHashMap<TripleString, Object> searchedSymbols = new ConcurrentHashMap();
    static final String GET_CURRENT_USER = "select user from dual";
    static final String SELECT_ALL_OWNER_PACKAGE = "select distinct owner, object_name from all_procedures  order by owner, object_name";
    private static final String SELECT_FIELDS = "select distinct aa.owner, aa.package_name, aa.subprogram_id, aa.object_name, aa.overload, aa.argument_name, aa.position, aa.data_type, aa.data_length, aa.in_out, aa.type_name, aa.type_subname, aa.type_link, aa.type_object_type, aa.pls_type, aa.char_length, aa.char_used, aa.defaulted from all_procedures ap, all_arguments aa where aa.object_id = ap.object_id and ap.subprogram_id = aa.subprogram_id and aa.package_name = ap.object_name and aa.owner = :OWNER and aa.package_name = :PACKAGE ";
    private static final String SELECT_ORDER = " order by aa.owner, aa.package_name, aa.subprogram_id, aa.object_name, aa.overload, aa.position ";
    private static final String SELECT_ALL_PACKAGE_FUNCS = "select distinct aa.owner, aa.package_name, aa.subprogram_id, aa.object_name, aa.overload, aa.argument_name, aa.position, aa.data_type, aa.data_length, aa.in_out, aa.type_name, aa.type_subname, aa.type_link, aa.type_object_type, aa.pls_type, aa.char_length, aa.char_used, aa.defaulted from all_procedures ap, all_arguments aa where aa.object_id = ap.object_id and ap.subprogram_id = aa.subprogram_id and aa.package_name = ap.object_name and aa.owner = :OWNER and aa.package_name = :PACKAGE  order by aa.owner, aa.package_name, aa.subprogram_id, aa.object_name, aa.overload, aa.position ";
    private static final String SELECT_SINGLE_FUNCTION = "select distinct aa.owner, aa.package_name, aa.subprogram_id, aa.object_name, aa.overload, aa.argument_name, aa.position, aa.data_type, aa.data_length, aa.in_out, aa.type_name, aa.type_subname, aa.type_link, aa.type_object_type, aa.pls_type, aa.char_length, aa.char_used, aa.defaulted from all_procedures ap, all_arguments aa where aa.object_id = ap.object_id and ap.subprogram_id = aa.subprogram_id and aa.package_name = ap.object_name and aa.owner = :OWNER and aa.package_name = :PACKAGE  and aa.object_name = :OBJECT  order by aa.owner, aa.package_name, aa.subprogram_id, aa.object_name, aa.overload, aa.position ";
    private static final String SELECT_TYPE_ATTRIBUTES = "select attributes from all_plsql_types where owner = :OWNER and package_name = :PACKAGE and type_name = :OBJECT";
    private static final String SELECT_RECORD_FIELDS = "select attr_type_owner, attr_type_package, attr_name, attr_no, attr_type_name from all_plsql_type_attrs where owner = :OWNER and package_name = :PACKAGE and type_name = :OBJECT order by attr_no";
    private static final String SELECT_COLLECTION_TYPE = "select elem_type_owner, elem_type_package, elem_type_name, coll_type from ALL_PLSQL_COLL_TYPES where owner = :OWNER and package_name = :PACKAGE and type_name = :OBJECT";
    private static final String SELECT_TYPE = "select distinct aa.owner, aa.package_name, aa.subprogram_id, aa.object_name, aa.overload, aa.argument_name, aa.position, aa.data_type, aa.data_length, aa.in_out, aa.type_name, aa.type_subname, aa.type_link, aa.type_object_type, aa.pls_type, aa.char_length, aa.char_used, aa.defaulted from all_plsql_types at, all_arguments aa where aa.object_id = ap.object_id and ap.subprogram_id = aa.subprogram_id and aa.package_name = ap.object_name and aa.owner = :OWNER and aa.package_name = :PACKAGE ";

    LoadDbRefs(Connection connection) throws SQLException {
        this.m_conn = connection;
        this.dbUtil = DBUtil.getInstance(this.m_conn);
    }

    String getCurrentUser() {
        return this.dbUtil.executeReturnOneCol(GET_CURRENT_USER, Collections.emptyMap());
    }

    void loadAllPackages(SymbolTable symbols) throws SQLException {
        List<Map<String, ?>> rslt = this.dbUtil.executeReturnList(SELECT_ALL_OWNER_PACKAGE, Collections.emptyMap());
        for (Map<String, ?> row : rslt) {
            String owner = row.get("OWNER").toString();
            String packageName = row.get("OBJECT_NAME").toString();
            symbols.getMakeSchemaPackage(owner, packageName);
        }
        if (SqlInjectionGraph.Debug.LOAD_COUNTS.debug) {
            System.out.println("Owner/Packages read: " + rslt.size());
        }
    }

    Symbol loadDbSymbol(SymbolTable symbols, String owner, String packageName, String objectName) throws SQLException {
        if (this.searchedSymbols.put(new TripleString(owner, packageName, objectName), true) != null) {
            return null;
        }
        SymbolTable topScope = symbols.getTopScope();
        Map<String, String> binds = new HashMap<String, String>();
        binds.put("OWNER", owner);
        binds.put("PACKAGE", packageName);
        binds.put("OBJECT", objectName);
        binds = Collections.unmodifiableMap(binds);
        List<Map<String, ?>> rows = this.dbUtil.executeReturnList(SELECT_TYPE_ATTRIBUTES, binds);
        if (rows.size() == 0) {
            rows = this.dbUtil.executeReturnList(SELECT_SINGLE_FUNCTION, binds);
            List<Symbol.FunctionSym> storedFunctions = this.storeFunctions(symbols, rows);
            if (storedFunctions.size() == 0) {
                return null;
            }
            assert (storedFunctions.size() == 1);
            return storedFunctions.get(0);
        }
        assert (rows.size() == 1);
        RowMapper row = new RowMapper(rows.get(0));
        int attributes = row.getInt("ATTRIBUTES");
        if (attributes == 0) {
            rows = this.dbUtil.executeReturnList(SELECT_COLLECTION_TYPE, binds);
            if (rows.size() != 1) {
                throw new SqlInjectionAnalysisFailure(SqlInjectionAnalysisFailure.SqlInjectionFailureTypes.SAF_DB_CORRUPT, "element type for collection ", objectName);
            }
            row = new RowMapper(rows.get(0));
            String elem_type_owner = row.get("ELEM_TYPE_OWNER");
            String elem_type_package = row.get("ELEM_TYPE_PACKAGE");
            String elem_type_name = row.get("ELEM_TYPE_NAME");
            String coll_type = row.get("coll_type");
            Dotted fullyQualifiedElem = new Dotted(elem_type_owner, elem_type_package, elem_type_name);
            SymbolTable.ResolvedSymbol rs = topScope.resolveDotted(fullyQualifiedElem);
            if (rs == null || rs.symbol == null) {
                return null;
            }
            PlsqlType.Collection coll = new PlsqlType.Collection(rs.symbol.getType());
            Symbol collSym = Symbol.createSymbolForType(null, objectName, coll, null, null);
            topScope.defineFullyQualified(new Dotted(owner, packageName, objectName), collSym, null);
            return collSym;
        }
        rows = this.dbUtil.executeReturnList(SELECT_RECORD_FIELDS, binds);
        LinkedHashMap<String, PlsqlType> fields = new LinkedHashMap<String, PlsqlType>();
        int fieldCount = 0;
        for (Map<String, ?> rawRow : rows) {
            ++fieldCount;
            row = new RowMapper(rawRow);
            String attr_name = row.get("ATTR_NAME");
            int attr_no = row.getInt("ATTR_NO");
            String attr_type_owner = row.get("ATTR_TYPE_OWNER");
            String attr_type_package = row.get("ATTR_TYPE_PACKAGE");
            String attr_type_name = row.get("ATTR_TYPE_NAME");
            assert (attr_no == fieldCount);
            PlsqlType type = null;
            if (attr_type_owner == null || attr_type_package == null || attr_type_owner.length() == 0 || attr_type_package.length() == 0) {
                type = new PlsqlType.Scalar(PlsqlType.ScalarType.fromString(attr_type_name));
            } else {
                SymbolTable.ResolvedSymbol rs = topScope.resolveDotted(new Dotted(attr_type_owner, attr_type_package, attr_type_name));
                if (rs != null) {
                    type = rs.symbol.getType();
                }
            }
            if (type == null) {
                throw new SqlInjectionAnalysisFailure(SqlInjectionAnalysisFailure.SqlInjectionFailureTypes.SAF_BAD_PARSE, "Type not understood:" + attr_type_name);
            }
            fields.put(attr_name, type);
        }
        assert (fieldCount == attributes);
        PlsqlType.Record record = new PlsqlType.Record(fields);
        Symbol recordSym = Symbol.createSymbolForType(null, objectName, record, null, null);
        topScope.defineFullyQualified(new Dotted(owner, packageName, objectName), recordSym, null);
        return recordSym;
    }

    int loadPackage(SymbolTable symbols, String owner, String packageName) throws SQLException {
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("OWNER", owner);
        binds.put("PACKAGE", packageName);
        List<Map<String, ?>> rows = this.dbUtil.executeReturnList(SELECT_ALL_PACKAGE_FUNCS, binds);
        int count = this.storeFunctions(symbols, rows).size();
        if (SqlInjectionGraph.Debug.LOAD_COUNTS.debug) {
            System.out.println(owner + "/" + packageName + " read: " + count);
        }
        return count;
    }

    private List<Symbol.FunctionSym> storeFunctions(SymbolTable symbols, List<Map<String, ?>> rows) throws SQLException {
        if (rows.size() == 0) {
            return Collections.emptyList();
        }
        HashSet<Symbol.FunctionSym> storedFunctions = new HashSet<Symbol.FunctionSym>();
        int count = 0;
        String curOwner = null;
        String curPackage = null;
        SymbolTable curSymbolTable = null;
        String curFuncUnique = null;
        String curFuncName = null;
        ArrayList<ParmSpec> curArgs = new ArrayList<ParmSpec>();
        Object prevFunc = "";
        for (Map<String, ?> rawRow : rows) {
            ParmSpec arg;
            RowMapper row = new RowMapper(rawRow);
            ++count;
            String owner = row.get("OWNER");
            String packageName = row.get("PACKAGE_NAME");
            String objectName = row.get("OBJECT_NAME");
            Integer subprogram = row.getInt("SUBPROGRAM_ID");
            String argName = row.get("ARGUMENT_NAME");
            int argPos = row.getInt("POSITION");
            String dataType = row.get("DATA_TYPE");
            String dataLength = row.get("DATA_LENGTH");
            String inOut = row.get("IN_OUT");
            String typeName = row.get("TYPE_NAME");
            String typeSubname = row.get("TYPE_SUBNAME");
            String typeLink = row.get("TYPE_LINK");
            String typeObjectType = row.get("TYPE_OBJECT_TYPE");
            String plsType = row.get("PLS_TYPE");
            Integer charLength = row.getInt("CHAR_LENGTH");
            String charUsed = row.get("CHAR_USED");
            boolean defaulted = row.get("DEFAULTED") == "Y";
            String funcUnique = owner + "." + packageName + "." + objectName + ":" + subprogram;
            Symbol.FunctionSym func = null;
            boolean newFunc = false;
            if (!owner.equals(curOwner) || !packageName.equals(curPackage) || count == 0) {
                newFunc = true;
                if (curFuncName != null) {
                    func = this.storeFunction(curSymbolTable, curFuncName, curArgs);
                }
                curFuncName = objectName;
                curOwner = owner;
                curPackage = packageName;
                curSymbolTable = symbols.getMakeSchemaPackage(owner, packageName);
            } else if (!funcUnique.equals(curFuncUnique)) {
                newFunc = true;
                func = this.storeFunction(curSymbolTable, curFuncName, curArgs);
                curFuncName = objectName;
            }
            if (func != null) {
                storedFunctions.add(func);
            }
            if (newFunc) {
                curFuncUnique = funcUnique;
                curFuncName = objectName;
                curArgs = new ArrayList();
            }
            String param = argPos + ":" + argName + " " + dataType + "(" + dataLength + " " + charUsed + "/" + charLength + ") " + inOut + " " + typeName + "-" + typeSubname + "-" + typeLink + "-" + typeObjectType + "-" + plsType;
            SqlInjectionGraph.ParameterMode mode = SqlInjectionGraph.ParameterMode.parse(inOut);
            if (plsType == null) {
                arg = new ParmSpec(argPos, argName, dataType, mode);
            } else {
                PlsqlType.Scalar type = new PlsqlType.Scalar(PlsqlType.ScalarType.fromString(plsType));
                arg = new ParmSpec(argPos, argName, type, mode, false, defaulted);
            }
            if (SqlInjectionGraph.Debug.DB_FUNCS.debug) {
                if (!funcUnique.equals(prevFunc)) {
                    System.out.println(funcUnique);
                    prevFunc = funcUnique;
                }
                System.out.println("    " + String.valueOf(arg) + " <=== " + param);
            }
            curArgs.add(arg);
        }
        Symbol.FunctionSym func = this.storeFunction(curSymbolTable, curFuncName, curArgs);
        storedFunctions.add(func);
        if (SqlInjectionGraph.Debug.DB_FUNCS.debug) {
            System.out.println("Total rows " + count);
            System.out.flush();
        }
        return new ArrayList<Symbol.FunctionSym>(storedFunctions);
    }

    private Symbol.FunctionSym storeFunction(SymbolTable curSymbolTable, String curFuncName, ArrayList<ParmSpec> curArgs) {
        assert (curFuncName != null);
        Symbol symbol = curSymbolTable.getLocalDeclarationNoDB(curFuncName);
        if (symbol != null && !(symbol instanceof Symbol.FunctionSym)) {
            throw new SqlInjectionAnalysisFailure("Database appears to have overloaded " + String.valueOf(symbol) + " with a function " + curFuncName);
        }
        Symbol.FunctionSym func = (Symbol.FunctionSym)symbol;
        Dotted dotted = curSymbolTable.getDotted();
        Loc loc = new Loc(dotted);
        if (func == null) {
            dotted.add(curFuncName);
            func = new Symbol.FunctionSym(curSymbolTable, curFuncName, curArgs, loc, (Object)loc);
        } else {
            func.addSignature(new FuncFormal(curArgs, loc, loc));
        }
        if (SqlInjectionGraph.Debug.DB_FUNCS.debug) {
            System.out.println("DB: " + String.valueOf(func));
        }
        return func;
    }

    static class TripleString {
        String a;
        String b;
        String c;

        TripleString(String a, String b, String c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.a == null ? 0 : this.a.hashCode());
            result = 31 * result + (this.b == null ? 0 : this.b.hashCode());
            result = 31 * result + (this.c == null ? 0 : this.c.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TripleString other = (TripleString)obj;
            if (this.a == null ? other.a != null : !this.a.equals(other.a)) {
                return false;
            }
            if (this.b == null ? other.b != null : !this.b.equals(other.b)) {
                return false;
            }
            return !(this.c == null ? other.c != null : !this.c.equals(other.c));
        }
    }
}

