/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app.injection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import oracle.dbtools.app.injection.FuncFormal;
import oracle.dbtools.app.injection.Loc;
import oracle.dbtools.app.injection.Symbol;
import oracle.dbtools.app.injection.Usage;
import oracle.dbtools.app.injection.ValueNode;

public class FlowFunc {
    private FuncFormal formal;
    private Loc loc;
    private List<Usage> inUses;
    private List<Usage> outUses;

    FlowFunc(FuncFormal formal, Object label) {
        this.formal = formal;
        this.loc = null;
        this.inUses = new ArrayList<Usage>(formal.getParms().size());
        this.outUses = new ArrayList<Usage>(formal.getParms().size());
        for (Symbol parmSym : formal.getParmSymbols()) {
            this.inUses.add(new Usage(parmSym, this.loc, label));
            this.outUses.add(new Usage(parmSym, this.loc, label));
        }
    }

    FlowFunc(FuncFormal formal, Loc loc, Object newLabel) {
        this(formal, newLabel);
        Usage uLink;
        this.loc = loc;
        Object oldLabel = formal.getBodyLabel();
        if (oldLabel == newLabel) {
            throw new IllegalArgumentException("Would cause infinite loop");
        }
        HashMap<Usage, Usage> remap = new HashMap<Usage, Usage>();
        ListIterator<Usage> iter = this.inUses.listIterator();
        while (iter.hasNext()) {
            uLink = iter.next();
            if (uLink.getLabel() != oldLabel) continue;
            iter.set(this.dup(uLink, remap, oldLabel, newLabel));
        }
        iter = this.outUses.listIterator();
        while (iter.hasNext()) {
            uLink = iter.next();
            if (uLink.getLabel() != oldLabel) continue;
            iter.set(this.dup(uLink, remap, oldLabel, newLabel));
        }
    }

    private Usage dup(Usage u1, Map<Usage, Usage> remap, Object oldLabel, Object newLabel) {
        Usage uLink;
        Usage u2 = remap.get(u1);
        if (u2 == null) {
            u2 = new Usage(u1, newLabel);
            remap.put(u1, u2);
        }
        ListIterator<Usage> iter = u2.getSources().listIterator();
        while (iter.hasNext()) {
            uLink = iter.next();
            if (uLink.getLabel() != oldLabel) continue;
            iter.set(this.dup(uLink, remap, oldLabel, newLabel));
        }
        iter = u2.getFlows().listIterator();
        while (iter.hasNext()) {
            uLink = iter.next();
            if (uLink.getLabel() != oldLabel) continue;
            Usage uLink2 = remap.get(uLink);
            iter.set(this.dup(uLink, remap, oldLabel, newLabel));
        }
        return u2;
    }

    Usage connect(List<ValueNode.ArgNode> argsInParmOrder) {
        if (this.loc == null) {
            throw new IllegalStateException("Attempt to connect generic flowGraph");
        }
        int n = argsInParmOrder.size();
        for (int i = 0; i < n; ++i) {
            ValueNode.ArgNode arg = argsInParmOrder.get(i);
            if (this.formal.getParms().get(i).getMode().isIn()) {
                List<Usage> argUsages = arg.getUsages();
                for (Usage u : argUsages) {
                    this.inUses.get(i).from(u);
                }
            }
            if (!this.formal.getParms().get(i).getMode().isOut()) continue;
            ArrayList<Usage> newUsages = new ArrayList<Usage>();
            newUsages.add(this.outUses.get(i));
            if (arg == null) continue;
            arg.setUsages(newUsages);
        }
        if (this.formal.getResultIdx() < 0) {
            return null;
        }
        return this.outUses.get(this.formal.getResultIdx());
    }

    Usage getInUse(int idx) {
        return this.inUses.get(idx);
    }

    Usage getOutUse(int idx) {
        return this.outUses.get(idx);
    }

    void simplifyGraph() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (Usage u : this.inUses) {
            if (u == null) continue;
            u.string();
        }
        sb.append("][");
        for (Usage u : this.outUses) {
            if (u == null) continue;
            u.string();
        }
        sb.append("]");
        return sb.toString();
    }

    class FlowFuncLink {
        private final int inParm;

        FlowFuncLink(int inParm) {
            this.inParm = inParm;
        }

        List<Usage> getFlows() {
            return Collections.singletonList(FlowFunc.this.inUses.get(this.inParm));
        }

        int getInParm() {
            return this.inParm;
        }
    }
}

