/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import liquibase.diff.DiffResult;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.diff.output.report.DiffToReport;
import liquibase.exception.DatabaseException;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LBOptions;
import org.w3c.dom.Document;

public class LiquibaseStringUtils {
    private static final Pattern LTRIM = Pattern.compile("^\\s+");
    private static final Pattern RTRIM = Pattern.compile("\\s+$");

    public static String base64Decode(String encodedStr) {
        return new String(Base64.getDecoder().decode(encodedStr), StandardCharsets.UTF_8);
    }

    public static String base64Encode(String decodedStr) {
        byte[] decodedByteArr = decodedStr.getBytes(StandardCharsets.UTF_8);
        return Base64.getEncoder().encodeToString(decodedByteArr);
    }

    public static String clobToString(Clob data) throws SQLException, IOException {
        int b;
        StringBuilder sb = new StringBuilder();
        Reader reader = data.getCharacterStream();
        BufferedReader br = new BufferedReader(reader);
        while (-1 != (b = br.read())) {
            sb.append((char)b);
        }
        br.close();
        return sb.toString();
    }

    public static String diffToChangeLog(DiffResult diffResult) throws DatabaseException, ParserConfigurationException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream((OutputStream)out, true, StandardCharsets.UTF_8);
        DiffOutputControl diffOutputControl = new DiffOutputControl();
        diffOutputControl.setIncludeCatalog(LbUtils.getCommand().getParsedCommand().isFlagSet((Id)LBOptions.Options.OUTPUT_DEFAULT_SCHEMA));
        diffOutputControl.setIncludeSchema(LbUtils.getCommand().getParsedCommand().isFlagSet((Id)LBOptions.Options.OUTPUT_DEFAULT_SCHEMA));
        DiffToChangeLog diffToChangeLog = new DiffToChangeLog(diffResult, diffOutputControl);
        diffToChangeLog.print(printStream);
        printStream.close();
        return out.toString(StandardCharsets.UTF_8);
    }

    public static String diffToString(DiffResult diffResult) throws DatabaseException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream((OutputStream)out, true, StandardCharsets.UTF_8);
        DiffToReport diffToReport = new DiffToReport(diffResult, printStream);
        diffToReport.print();
        printStream.close();
        return out.toString(StandardCharsets.UTF_8);
    }

    public static String exceptionToString(Throwable aThrowable) {
        StringBuilder result = new StringBuilder("ERROR: ");
        result.append(aThrowable.toString());
        String NEW_LINE = System.getProperty("line.separator");
        result.append(NEW_LINE);
        return result.toString();
    }

    public static String exceptionToString2(Exception e) {
        return Arrays.toString(e.getStackTrace());
    }

    public static String getDocumentAsString(Document doc) throws TransformerException {
        DOMSource domSource = new DOMSource(doc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(domSource, result);
        return writer.toString();
    }

    public static InputStream getXSLTFromJar(String objectType) {
        return SchemaGenerator.class.getClassLoader().getResourceAsStream(objectType.toLowerCase() + ".xslt");
    }

    public static int nthOccurrence(String str, char c, int n) {
        int i = n;
        if (0 >= i) {
            return -1;
        }
        int pos = str.indexOf(c);
        while (1 < i && -1 != pos) {
            --i;
            pos = str.indexOf(c, pos + 1);
        }
        return pos;
    }

    public static String replaceVal(String parm, String value, String doc) {
        String s = value;
        if (null == s) {
            s = "";
        }
        String workString = doc;
        return workString.replace(parm, s);
    }

    public static List<String> splitString(String stringtoSplit, int length) {
        ArrayList<String> returnStringList = new ArrayList<String>((stringtoSplit.length() + length - 1) / length);
        for (int start = 0; start < stringtoSplit.length(); start += length) {
            returnStringList.add(stringtoSplit.substring(start, Math.min(stringtoSplit.length(), start + length)));
        }
        return returnStringList;
    }

    public static String stripCR(String string) {
        String pattern = "(?m)^\\s*\\r?\\n|\\r?\\n\\s*(?!.*\\r?\\n)";
        String replacement = "";
        return string.replaceAll("(?m)^\\s*\\r?\\n|\\r?\\n\\s*(?!.*\\r?\\n)", "");
    }

    public static String trim(String s) {
        return LiquibaseStringUtils.rtrim(LiquibaseStringUtils.ltrim(s));
    }

    public static String rtrim(String s) {
        return RTRIM.matcher(s).replaceAll("");
    }

    public static String ltrim(String s) {
        return LTRIM.matcher(s).replaceAll("");
    }

    public static String trimEndofSql(String sql) {
        String s = sql;
        while (s.trim().endsWith(";")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }
}

