/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.util;

import java.sql.Connection;
import java.util.LinkedList;
import oracle.dbtools.extension.apex.core.APEXExport;
import oracle.dbtools.extension.apex.help.ApexMessages;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LBOptions;

public class ApexUtils {
    public static String genApexController(LinkedList<? extends APEXExport.RowDetails> files, Connection conn) {
        StringBuilder sb = new StringBuilder();
        sb.append(ApexUtils.genControllerHeader());
        String user = QueryUtils.getUser(conn);
        for (APEXExport.RowDetails rowDetails : files) {
            sb.append(ApexUtils.genControllerSetup(rowDetails.getWorkName(), rowDetails.getAppId(), user, rowDetails.getFileName(), rowDetails.getOverrideSchema(), rowDetails.getOverrideAlias(), rowDetails.getOverrideWorkspace(), rowDetails.getOverrideAppId()));
        }
        sb.append(ApexUtils.genControllerFooter());
        return sb.toString();
    }

    private static String genControllerHeader() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + ApexUtils.commentParamSettings("lb.parameters", Position.SINGLE) + "\n<databaseChangeLog \n        xmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\" \n        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n        xmlns:n0=\"http://www.oracle.com/xml/ns/dbchangelog-ext\" \n        xsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog \n        http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-latest.xsd\">\n";
    }

    protected static String genControllerSetup(String workspace, String appId, String user, String filename, String schema, String alias, String override_workspace, String override_appid) {
        boolean runalways;
        boolean fail;
        StringBuilder setup = new StringBuilder();
        String label = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.LABELS);
        String context = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.CONTEXTS);
        try {
            fail = LbUtils.getCommand().getParsedCommand().isFlagSet((Id)LBOptions.Options.FAIL_ON_ERROR);
        }
        catch (Exception e) {
            fail = false;
        }
        try {
            runalways = LbUtils.getCommand().getParsedCommand().isFlagSet((Id)LBOptions.Options.RUNALWAYS);
        }
        catch (Exception e) {
            runalways = false;
        }
        setup.append("<changeSet id=\"INSTALL_").append(appId).append("\" author=\"").append(user).append("\"  %FAILONERROR% %CONTEXTS% %LABELS% %RUNALWAYS% >\n");
        setup.append("    <n0:runApexScript objectName=\"install\" objectType=\"SCRIPT\" ownerName=\"").append(user).append("\" sourceType=\"STRING\" >\n");
        setup.append("        <n0:source><![CDATA[\n");
        setup.append("declare \n\n");
        setup.append("  -- sqlcl version      = ").append(ApexMessages.getString((String)"SQLclVersion.VERSION")).append(" \n");
        setup.append("  -- override_schema    = ${lb.apex.schema} \n");
        setup.append("  -- override_alias     = ${lb.apex.alias} \n");
        setup.append("  -- override_workspace = ${lb.apex.workspace} \n");
        setup.append("  -- override_app_id    = ${lb.apex.appId} \n\n");
        setup.append("  l_app_id apex_applications.application_id%type := q'[").append(appId).append("]';  \n");
        setup.append("  l_workspace apex_workspaces.workspace%type := q'[").append(workspace).append("]'; \n\n");
        setup.append("  l_override_workspace apex_workspaces.workspace%type := q'[${lb.apex.workspace}]'; \n");
        setup.append("  l_override_schema apex_workspace_schemas.schema%type := q'[${lb.apex.schema}]';  \n");
        setup.append("  l_override_alias apex_applications.alias%type := q'[${lb.apex.alias}]';  \n");
        setup.append("  l_override_app_id apex_applications.application_id%type := q'[${lb.apex.appId}]';  \n");
        setup.append("  l_generate_offset boolean := false;\n");
        setup.append("begin  \n");
        setup.append("  apex_application_install.clear_all(); \n");
        setup.append("  -- set workspace \n ");
        setup.append("  if (l_override_workspace is not null and l_override_workspace != l_workspace) then \n");
        setup.append("      apex_application_install.set_workspace(l_override_workspace);  \n");
        setup.append("  else \n");
        setup.append("      apex_application_install.set_workspace(l_workspace); \n");
        setup.append("  end if; \n");
        setup.append("     commit;  \n");
        setup.append("  -- set app id \n");
        setup.append("  if (l_override_app_id is not null and l_override_app_id != l_app_id) then \n");
        setup.append("      apex_application_install.set_application_id(l_override_app_id);  \n");
        setup.append("      l_generate_offset := true;\n");
        setup.append("  else  \n");
        setup.append("      apex_application_install.set_application_id(l_app_id); \n");
        setup.append("  end if; \n");
        setup.append("  -- ensure supporting objects get installed\n");
        setup.append("   apex_application_install.set_auto_install_sup_obj(p_auto_install_sup_obj => true); \n");
        setup.append("  -- set schema if not same \n");
        setup.append("  if (l_override_schema is not null) then \n");
        setup.append("      apex_application_install.set_schema(l_override_schema);  \n");
        setup.append("  end if; \n");
        setup.append("  -- set alias \n");
        setup.append("  if (l_override_alias is not null ) then \n");
        setup.append("      apex_application_install.set_application_alias(l_override_alias); \n");
        setup.append("      l_generate_offset := true;\n");
        setup.append("  end if;         \n");
        setup.append("  -- generate offset if necessary\n");
        setup.append("  if (l_generate_offset)  then\n");
        setup.append("     apex_application_install.generate_offset();\n");
        setup.append("  end if;\n");
        setup.append("end;  \n");
        setup.append("/\n");
        String cleanFileName = filename;
        if (filename.contains(LbUtils.getCWD())) {
            cleanFileName = filename.replace(LbUtils.getCWD(), "");
        }
        setup.append("@@").append(cleanFileName).append("\n");
        setup.append("        ]]></n0:source>\n");
        setup.append("    </n0:runApexScript>\n");
        setup.append("</changeSet>\n");
        String change = setup.toString();
        change = fail ? LiquibaseStringUtils.replaceVal("%FAILONERROR%", "failOnError=\"true\"", change) : LiquibaseStringUtils.replaceVal("%FAILONERROR%", null, change);
        change = null != context && !context.isEmpty() ? LiquibaseStringUtils.replaceVal("%CONTEXTS%", "context=\"" + context + "\"", change) : LiquibaseStringUtils.replaceVal("%CONTEXTS%", null, change);
        change = null != label && !label.isEmpty() ? LiquibaseStringUtils.replaceVal("%LABELS%", "labels=\"" + label + "\"", change) : LiquibaseStringUtils.replaceVal("%LABELS%", null, change);
        change = runalways ? LiquibaseStringUtils.replaceVal("%RUNALWAYS%", "runAlways=\"true\"", change) : LiquibaseStringUtils.replaceVal("%RUNALWAYS%", null, change);
        return change;
    }

    private static String genControllerFooter() {
        return "</databaseChangeLog> \n";
    }

    public static String commentParamSettings(String parms, Position pos) {
        StringBuilder sb = new StringBuilder();
        if (Position.TOP == pos || Position.SINGLE == pos) {
            sb.append("<!--\n");
        }
        if (Position.BOTTOM == pos || Position.SINGLE == pos) {
            sb.append("-->");
        }
        return sb.toString();
    }

    private static String pad(String word, int newLength) {
        StringBuilder wordBuilder = new StringBuilder(word);
        while (wordBuilder.length() < newLength) {
            wordBuilder.append(" ");
        }
        return wordBuilder.toString();
    }

    public static enum Position {
        TOP,
        BOTTOM,
        SINGLE;

    }
}

