/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.generator.changesets.core;

import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import liquibase.exception.DatabaseException;
import oracle.dbtools.raptor.liquibase.exception.ObjectNotFoundException;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import oracle.dbtools.raptor.liquibase.generator.changesets.core.AbstractChangeSet;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.SetDDLSettings;

public class SqlChangeSet
extends AbstractChangeSet {
    protected static final String SCRIPT = "SCRIPT";
    protected static final String SOURCE_TYPE = "%SOURCE_TYPE%";
    protected static final String SOURCE_TYPE_STRING = "sourceType=\"STRING\"";
    String rawchange = "--liquibase formatted sql \n--changeset %AUTHOR%:%ID% %FAILONERROR% %CONTEXTS% %LABELS% %RUNOPTIONS% \n-- objectName=\"%OBJECT_NAME%\" objectType=\"%OBJECT_TYPE%\" ownerName=\"%OWNER_NAME%\" %SOURCE_TYPE% %REPLACEXISTS% \n%SOURCE%\n\n\n%SXML%";

    @Override
    public String getChange() throws NoSuchAlgorithmException, SQLException {
        String schema = this.getData().getSCHEMA();
        this.rawchange = LiquibaseStringUtils.replaceVal("%ID%", this.getSha1fromString(this.getData().getDDL()), this.rawchange);
        this.rawchange = LiquibaseStringUtils.replaceVal("%AUTHOR%", "(" + schema + ")-Generated", this.rawchange);
        this.rawchange = LiquibaseStringUtils.replaceVal("%OBJECT_NAME%", this.getData().getONAME().replaceAll("\"", ""), this.rawchange);
        this.rawchange = LiquibaseStringUtils.replaceVal("%OBJECT_TYPE%", this.getData().getOTYPE(), this.rawchange);
        if (null != schema) {
            this.rawchange = LiquibaseStringUtils.replaceVal("%OWNER_NAME%", schema, this.rawchange);
        }
        this.rawchange = SCRIPT.equalsIgnoreCase(this.getData().getOTYPE()) && "ORDS".equals(this.getData().getONAME()) ? LiquibaseStringUtils.replaceVal(SOURCE_TYPE, SOURCE_TYPE_STRING, this.rawchange) : (SCRIPT.equalsIgnoreCase(this.getData().getOTYPE()) && "APEX".equals(this.getData().getONAME()) ? LiquibaseStringUtils.replaceVal(SOURCE_TYPE, SOURCE_TYPE_STRING, this.rawchange) : (SCRIPT.equalsIgnoreCase(this.getData().getOTYPE()) ? LiquibaseStringUtils.replaceVal(SOURCE_TYPE, SOURCE_TYPE_STRING, this.rawchange) : LiquibaseStringUtils.replaceVal("%CHANGE_TYPE%", SchemaGenerator.ddlChangeTypes.get(this.getData().getOTYPE().toUpperCase()), this.rawchange)));
        this.rawchange = LiquibaseStringUtils.replaceVal(SOURCE_TYPE, "", this.rawchange);
        if ("TRIGGER".equals(this.getData().getOTYPE())) {
            this.rawchange = this.rawchange.replace("END;\\nALTER TRIGGER", "END;\n/\nALTER TRIGGER");
        }
        this.rawchange = this.getData().isFAIL() ? LiquibaseStringUtils.replaceVal("%FAILONERROR%", "failOnError=\"true\"", this.rawchange) : LiquibaseStringUtils.replaceVal("%FAILONERROR%", "failOnError=\"false\"", this.rawchange);
        this.rawchange = this.getData().isREPLACE() ? LiquibaseStringUtils.replaceVal("%REPLACEXISTS%", "replaceIfExists=\"true\"", this.rawchange) : LiquibaseStringUtils.replaceVal("%REPLACEXISTS%", "replaceIfExists=\"false\"", this.rawchange);
        this.rawchange = null != this.getData().getCONTEXT() && !this.getData().getCONTEXT().isEmpty() ? LiquibaseStringUtils.replaceVal("%CONTEXTS%", "context=\"" + this.getData().getCONTEXT() + "\"", this.rawchange) : LiquibaseStringUtils.replaceVal("%CONTEXTS%", null, this.rawchange);
        this.rawchange = null != this.getData().getLABEL() && !this.getData().getLABEL().isEmpty() ? LiquibaseStringUtils.replaceVal("%LABELS%", "labels=\"" + this.getData().getLABEL() + "\"", this.rawchange) : LiquibaseStringUtils.replaceVal("%LABELS%", null, this.rawchange);
        Object runOptions = this.getData().isRUNONCHANGE() ? "runOnChange=\"true\" " : "runOnChange=\"false\" ";
        runOptions = this.getData().isRUNALWAYS() ? (String)runOptions + "runAlways=\"true\" " : (String)runOptions + "runAlways=\"false\" ";
        if (this.getData().isDISABLETRANS()) {
            runOptions = (String)runOptions + "runInTransaction=\"true\" ";
        }
        this.rawchange = LiquibaseStringUtils.replaceVal("%RUNOPTIONS%", (String)runOptions, this.rawchange);
        if (SchemaGenerator.ddlTypes.contains(this.getData().getOTYPE())) {
            this.rawchange = LiquibaseStringUtils.replaceVal("%SOURCE%", this.getData().getDDL().replaceAll("\\]\\]\\>", "]]]]><![CDATA[>"), this.rawchange);
            this.rawchange = LiquibaseStringUtils.replaceVal("%SXML%", "", this.rawchange);
        } else {
            try {
                String ddl = DbmsMetaUtils.getDdlFromSxml(LbUtils.getLbConnection().getUnderlyingConnection(), this.getData().getDDL(), this.getData().getOTYPE());
                this.rawchange = LiquibaseStringUtils.replaceVal("%SOURCE%", ddl, this.rawchange);
            }
            catch (Exception e) {
                LbUtils.log(this.getClass(), e);
                throw e;
            }
            SetDDLSettings.setDDLParameter((ScriptRunnerContext)LbUtils.getContext(), (String)"STORAGE", (String)"OFF");
            SetDDLSettings.setDDLParameter((ScriptRunnerContext)LbUtils.getContext(), (String)"SEGMENT_ATTRIBUTES", (String)"OFF");
            this.rawchange = LiquibaseStringUtils.replaceVal("%SXML%", "--" + this.getData().getDDL().replace("\n", "").replaceAll(">\\s*<", "><"), this.rawchange);
        }
        this.rawchange = this.rawchange.replaceAll("(\"?)" + schema + "(\"?)(\\.\"?" + this.getData().getONAME() + "\"?)", "$1%USER_NAME%$2$3");
        return this.rawchange;
    }
}

