/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.generator;

import com.google.common.base.Throwables;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.util.Logger;

public class SchemaGeneratorUtils {
    public static void cloneCaptureTable(Connection conn, String name) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        try {
            dbUtil.execute("drop table " + name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            dbUtil.execute("create table " + name + " as select * from DATABASECHANGELOG_EXPORT");
        }
        catch (Exception e) {
            Logger.warn(SchemaGeneratorUtils.class, (String)Throwables.getStackTraceAsString((Throwable)LbUtils.getRoot(e)));
        }
    }

    public static void dropCaptureObjects() {
        try {
            SchemaGeneratorUtils.dropCapturePackage();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            SchemaGeneratorUtils.dropCaptureTable();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void dropCapturePackage() throws SQLException {
        String dropCapturePackage = QueryUtils.getXMLQueries().getQuery("dropCapturePackage", LbUtils.getLbConnection().getUnderlyingConnection()).getSql();
        SchemaGeneratorUtils.doDbWork(dropCapturePackage, LbUtils.getLbConnection().getUnderlyingConnection());
    }

    public static void dropCaptureTable() throws SQLException {
        String dropCaptureTable = QueryUtils.getXMLQueries().getQuery("dropCaptureTable", LbUtils.getLbConnection().getUnderlyingConnection()).getSql();
        SchemaGeneratorUtils.doDbWork(dropCaptureTable, LbUtils.getLbConnection().getUnderlyingConnection());
    }

    private static void doDbWork(String sql, Connection conn) throws SQLException {
        String output;
        ByteArrayOutputStream BaS = new ByteArrayOutputStream();
        BufferedOutputStream BoS = new BufferedOutputStream(BaS);
        ScriptExecutor m_executor = new ScriptExecutor(conn);
        m_executor.setStmt(sql);
        m_executor.setOut(BoS);
        m_executor.run();
        try {
            BoS.flush();
            output = BaS.toString();
        }
        catch (IOException e) {
            output = null;
        }
        ScriptRunnerContext m_scriptRunnerContext = m_executor.getScriptRunnerContext();
        Boolean hasErrors = (Boolean)m_scriptRunnerContext.getProperties().get("sqldev.error");
        String error = (String)m_scriptRunnerContext.getProperties().get("sqldev.last.err.message.forsqlcode");
        if (hasErrors.booleanValue()) {
            LbUtils.getContext().write(output);
            throw new SQLException(error);
        }
    }

    public static void createCaptureObjects() throws SQLException {
        if (SchemaGeneratorUtils.doesCaptureTableExist()) {
            SchemaGeneratorUtils.dropCaptureTable();
        }
        SchemaGeneratorUtils.createCaptureTable();
        if (SchemaGeneratorUtils.doesCapturePackageExist()) {
            LbUtils.setCollation();
            SchemaGeneratorUtils.createCapturePackage();
            LbUtils.clearCollation();
        }
    }

    public static boolean doesCaptureTableExist() {
        DBUtil dbUtil = DBUtil.getInstance((Connection)LbUtils.getLbConnection().getUnderlyingConnection());
        String count = dbUtil.executeReturnOneCol(QueryUtils.getXMLQueries().getQuery("checkLbtable", LbUtils.getLbConnection().getUnderlyingConnection()).getSql());
        return 0 != Integer.parseInt(count);
    }

    public static void createCaptureTable() throws SQLException {
        String createCaptureTable = QueryUtils.getXMLQueries().getQuery("createCaptureTable", LbUtils.getLbConnection().getUnderlyingConnection()).getSql();
        SchemaGeneratorUtils.doDbWork(createCaptureTable, LbUtils.getLbConnection().getUnderlyingConnection());
    }

    public static boolean doesCapturePackageExist() {
        DBUtil dbUtil = DBUtil.getInstance((Connection)LbUtils.getLbConnection().getUnderlyingConnection());
        String count = dbUtil.executeReturnOneCol(QueryUtils.getXMLQueries().getQuery("checkLbPackage", LbUtils.getLbConnection().getUnderlyingConnection()).getSql());
        return 0 == Integer.parseInt(count);
    }

    public static void createCapturePackage() throws SQLException {
        String createPackageSpec = QueryUtils.getXMLQueries().getQuery("createCapturePackageSpec", LbUtils.getLbConnection().getUnderlyingConnection()).getSql();
        String createPackageBody = QueryUtils.getXMLQueries().getQuery("createCapturePackageBody", LbUtils.getLbConnection().getUnderlyingConnection()).getSql();
        SchemaGeneratorUtils.doDbWork(createPackageSpec, LbUtils.getLbConnection().getUnderlyingConnection());
        SchemaGeneratorUtils.doDbWork(createPackageBody, LbUtils.getLbConnection().getUnderlyingConnection());
    }
}

