/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.ext.ora.change;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.CheckSum;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.statement.SqlStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.change.AbstractCommonPlSqlChange;
import oracle.dbtools.raptor.liquibase.ext.ora.change.AbstractOracleChange;
import oracle.dbtools.raptor.liquibase.ext.ora.generator.RunInternalScriptGenerator;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.RunApexScriptStatement;
import oracle.dbtools.util.Logger;

@DatabaseChange(name="runApexScript", description="Run Apex Script", priority=1)
public class RunApexScriptChange
extends AbstractCommonPlSqlChange {
    public RunApexScriptChange() {
        this.setObjectType("SCRIPT");
    }

    public RunApexScriptChange(AbstractOracleChange change) {
        super(change);
        this.setObjectType("SCRIPT");
    }

    public CheckSum generateCheckSum() {
        try {
            RunInternalScriptGenerator generator = new RunInternalScriptGenerator();
            return CheckSum.compute((String)generator.getSqlString(this));
        }
        catch (Exception e) {
            Logger.warn(RunApexScriptChange.class, (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public SqlStatement[] generateStatements(Database database) {
        RunApexScriptStatement stmt = new RunApexScriptStatement(this);
        return new SqlStatement[]{stmt};
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Script executed successfully", this.getObjectName());
    }

    public boolean supportsRollback(Database database) {
        return false;
    }

    protected Change[] createInverses() {
        return null;
    }
}

