/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.ext.ora.change;

import java.text.MessageFormat;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.statement.SqlStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.change.AbstractCommonPlSqlChange;
import oracle.dbtools.raptor.liquibase.ext.ora.change.AbstractOracleChange;
import oracle.dbtools.raptor.liquibase.ext.ora.change.DropPublicSynonymChange;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.CreatePublicSynonymStatement;

@DatabaseChange(name="createOraclePublicSynonym", description="Create oracle Publicsynonym", priority=1)
public class CreatePublicSynonymChange
extends AbstractCommonPlSqlChange {
    public CreatePublicSynonymChange() {
        this.setObjectType("SYNONYM");
    }

    public CreatePublicSynonymChange(AbstractOracleChange change) {
        super(change);
        this.setObjectType("SYNONYM");
    }

    public SqlStatement[] generateStatements(Database database) {
        CreatePublicSynonymStatement stmt = new CreatePublicSynonymStatement(this);
        return new SqlStatement[]{stmt};
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Public Synonym {0} created", this.getObjectName());
    }

    protected Change[] createInverses() {
        DropPublicSynonymChange inverse = new DropPublicSynonymChange(this);
        return new Change[]{inverse};
    }
}

