/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import liquibase.Liquibase;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.output.ObjectChangeFilter;
import liquibase.diff.output.StandardObjectChangeFilter;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ResourceAccessor;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.DatabaseObjectFactory;
import liquibase.util.StringUtil;
import oracle.dbtools.extension.apex.command.MutableCommand;
import oracle.dbtools.extension.apex.core.APEXExport;
import oracle.dbtools.raptor.liquibase.actionlogging.ActionLogTableManager;
import oracle.dbtools.raptor.liquibase.changelog.visitor.OracleChangeExecListener;
import oracle.dbtools.raptor.liquibase.core.ActiveCommand;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import oracle.dbtools.raptor.liquibase.util.ApexUtils;
import oracle.dbtools.raptor.liquibase.util.LbFileUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LBOptions;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;

public class CommandGenerator {
    private CommandGenerator() {
    }

    public static void calculateCheckSumCommand() throws Exception {
        LbUtils.getCommand().runCommand();
        LbUtils.getContext().getOutputStream().flush();
    }

    public static void changeLogSyncCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void changeLogSyncSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    private static void setupOutFileRun() throws Exception {
        String outFile = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.OUTPUT_FILE);
        if (null != outFile && !outFile.isEmpty()) {
            outFile = LbFileUtils.getFileString(LbUtils.getContext(), outFile);
            FileOutputStream writer = new FileOutputStream(outFile);
            LbUtils.getCommand().getCommandScope().setOutput((OutputStream)writer);
            LbUtils.getCommand().runCommand();
            try {
                writer.flush();
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LbUtils.getContext().write(Messages.format("FILE_GENERATED", outFile));
        } else {
            LbUtils.getCommand().runCommand();
        }
    }

    public static void changeLogSyncToTagCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void changeLogSyncToTagSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void clearCheckSumsCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void dataCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void dbDocCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void diffChangelogCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    private static Liquibase getLiquibase() throws LiquibaseException {
        Liquibase liquibase = new Liquibase((String)LbUtils.getCommand().getOptionValue(LBOptions.Options.CHANGELOG_FILE), (ResourceAccessor)LbUtils.getCommand().getSpa(), (DatabaseConnection)LbUtils.getLbConnection());
        liquibase.setChangeExecListener((ChangeExecListener)new OracleChangeExecListener());
        if (LbUtils.getCommand().getOptionValue(LBOptions.Options.LIQUIBASE_SCHEMA_NAME) != null && !"".equals(LbUtils.getCommand().getOptionValue(LBOptions.Options.LIQUIBASE_SCHEMA_NAME))) {
            liquibase.getDatabase().setDefaultSchemaName((String)LbUtils.getCommand().getOptionValue(LBOptions.Options.LIQUIBASE_SCHEMA_NAME));
            liquibase.getDatabase().setDefaultCatalogName((String)LbUtils.getCommand().getOptionValue(LBOptions.Options.LIQUIBASE_SCHEMA_NAME));
        }
        if (LbUtils.getCommand().getOptionValue(LBOptions.Options.DATABASE_CHANGELOG_TABLE_NAME) != null && !"".equals(LbUtils.getCommand().getOptionValue(LBOptions.Options.DATABASE_CHANGELOG_TABLE_NAME))) {
            liquibase.getDatabase().setDatabaseChangeLogTableName((String)LbUtils.getCommand().getOptionValue(LBOptions.Options.DATABASE_CHANGELOG_TABLE_NAME));
            liquibase.getDatabase().setDatabaseChangeLogLockTableName(String.valueOf(LbUtils.getCommand().getOptionValue(LBOptions.Options.DATABASE_CHANGELOG_TABLE_NAME)) + "LOCK");
        }
        if (LbUtils.getCommand().getOptionValue(LBOptions.Options.OUTPUT_DEFAULT_SCHEMA) != null && !"".equals(LbUtils.getCommand().getOptionValue(LBOptions.Options.OUTPUT_DEFAULT_SCHEMA))) {
            liquibase.getDatabase().setOutputDefaultSchema(((Boolean)LbUtils.getCommand().getOptionValue(LBOptions.Options.OUTPUT_DEFAULT_SCHEMA)).booleanValue());
        }
        return liquibase;
    }

    private static Database getTargetDb() throws DatabaseException, SQLException {
        JdbcConnection targetConn = new JdbcConnection(DriverManager.getConnection((String)LbUtils.getCommand().getOptionValue(LBOptions.Options.REFERENCE_URL), (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.REFERENCE_USERNAME), (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.REFERENCE_PASSWORD)));
        return DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)targetConn);
    }

    private static Set<Class<? extends DatabaseObject>> getSnapshotTypesSet(String rawtypes) {
        String[] snapshotTypes = CommandGenerator.splitAndTrim(rawtypes);
        if (snapshotTypes.length == 0 || snapshotTypes[0] == null) {
            return Collections.emptySet();
        }
        return DatabaseObjectFactory.getInstance().parseTypes(StringUtil.join((String[])snapshotTypes, (String)","));
    }

    private static ObjectChangeFilter getObjectChangeFilter() throws LiquibaseException {
        String excludeObjects = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.EXCLUDE_OBJECTS);
        String includeObjects = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.INCLUDE_OBJECTS);
        if (excludeObjects != null && includeObjects != null) {
            throw new LiquibaseException(Messages.getString("LB_BAD_FILTER"));
        }
        if (excludeObjects != null) {
            return new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.EXCLUDE, excludeObjects.toUpperCase());
        }
        if (includeObjects != null) {
            return new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.INCLUDE, includeObjects.toUpperCase());
        }
        return new StandardObjectChangeFilter(null, "");
    }

    private static String[] splitAndTrim(String string) {
        if (string == null || string.isEmpty()) {
            return new String[0];
        }
        String[] result = string.split(",");
        int array_length = result.length;
        for (int i = 0; i < array_length; ++i) {
            result[i] = result[i].trim();
        }
        return result;
    }

    public static void diffCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void dropAllCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void futureRollbackCountSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void futureRollbackSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void futureRollbackTagSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void generateChangelogCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void listLocksCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void markNextChangesetRanCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void markNextChangesetRanSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void releaseLocksCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void rollbackCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void rollbackSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void rollbackCountCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void rollbackCountSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void rollbackToDateCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void rollbackToDateSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void setCommand(ParsedCommand command) throws IOException {
        String name = (String)command.getParameterValue((Id)LBOptions.Options.PARAMETER);
        String value = (String)command.getParameterValue((Id)LBOptions.Options.VALUE);
        List<String> pList = Arrays.asList("ON", "OFF");
        List<String> engines = Arrays.asList("JDBC", "SQLCL");
        List<String> parms = Arrays.asList(LBOptions.parameters);
        if ("RESET".equalsIgnoreCase(name) && "ON".equalsIgnoreCase(value)) {
            LbUtils.resetParameters();
        } else if ("ENGINE".equalsIgnoreCase(name) && engines.contains(value)) {
            LbUtils.setParameter(name.toUpperCase(), value);
        } else if ("ENGINE".equalsIgnoreCase(name) && !engines.contains(value)) {
            LbUtils.getContext().writeln("Invalid value for ENGINE must be JDBC or SQLCL");
        } else if (parms.contains(name) && pList.contains(value)) {
            LbUtils.setParameter(name.toUpperCase(), value);
        } else if (parms.contains(name) && !pList.contains(value)) {
            LbUtils.getContext().writeln("Invalid value for " + name.toUpperCase() + " must be ON or OFF");
        } else {
            LbUtils.getContext().writeln("Invalid parameter was specified");
        }
    }

    public static void showCommand() throws IOException {
        LbUtils.showParameters();
    }

    public static void snapShotCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void snapShotReferenceCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void statusCommand() throws Exception {
        LbUtils.getCommand().addArgumentValue("VERBOSE", (Object)true);
        LbUtils.getCommand().runCommand();
    }

    public static void tagCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void tagExistsCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void unexpectedChangessetsCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void updateCommand() throws Exception {
        ActionLogTableManager tm = new ActionLogTableManager(LbUtils.getCommand().getDb());
        tm.createUpdateLogTable();
        LbUtils.getCommand().runCommand();
    }

    public static void updateSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void updateCountCommand() throws Exception {
        CommandGenerator.updateCommand();
    }

    public static void updateCountSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void updateTestingRollbackCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void updateToTagCommand() throws Exception {
        CommandGenerator.updateCommand();
    }

    public static void updateToTagSqlCommand() throws Exception {
        CommandGenerator.setupOutFileRun();
    }

    public static void validateCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static void historyCommand() throws Exception {
        LbUtils.getCommand().runCommand();
    }

    public static String generateApexObjectCommand(Connection conn) throws Exception {
        LinkedHashMap<String, APEXExport.RowDetails> changes = CommandGenerator.getApexChangeLogs(LbUtils.getCommand(), conn);
        if (null == changes || changes.isEmpty()) {
            LbUtils.getContext().write(Messages.format("NO_APEX", new Object[0]));
            return null;
        }
        LinkedList<String> cKeys = new LinkedList<String>(changes.keySet());
        LinkedList<APEXExport.RowDetails> installFiles = new LinkedList<APEXExport.RowDetails>();
        APEXExport.RowDetails lastRow = changes.get(cKeys.get(0));
        for (Map.Entry<String, APEXExport.RowDetails> entry : changes.entrySet()) {
            String key = entry.getKey();
            APEXExport.RowDetails curRow = entry.getValue();
            if (key.equals("screenoutput.log")) continue;
            File file = Paths.get(key, new String[0]).toFile();
            LbFileUtils.writeFile(LbUtils.getContext(), file.toString(), entry.getValue().getContents());
            if (!Objects.equals(lastRow.getWorkId(), curRow.getWorkId())) {
                installFiles.add(lastRow);
            }
            lastRow = curRow;
        }
        installFiles.add(lastRow);
        return Messages.format("FILE_GENERATED", LbFileUtils.writeApexInstallFile("apex_install.xml", ApexUtils.genApexController(installFiles, conn)));
    }

    private static LinkedHashMap<String, APEXExport.RowDetails> getApexChangeLogs(ActiveCommand command, Connection conn) throws Exception {
        APEXExport apexExport = new APEXExport(new MutableCommand(command.getParsedCommand()), true);
        apexExport.setCtx(LbUtils.getContext());
        apexExport.setConnection(conn);
        apexExport.setOutStream((OutputStream)LbUtils.getContext().getOutputStream());
        apexExport.doCapture();
        return apexExport.getResults();
    }

    public static void generateControlFileCommand() throws Exception {
        Path path = LbFileUtils.getPath(LbUtils.getContext(), (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.OUTPUT_FILE));
        SchemaGenerator.writeMasterLog(path);
        LbUtils.getContext().write(Messages.format("CONTROLLER_CREATED", path.toString()));
    }

    public static String generateDbObjectCommand() throws Exception {
        SchemaGenerator gen = new SchemaGenerator();
        String change = gen.getChangeLog();
        String fileName = (String.valueOf(LbUtils.getCommand().getOptionValue(LBOptions.Options.OBJECT_NAME)) + "_" + String.valueOf(LbUtils.getCommand().getOptionValue(LBOptions.Options.OBJECT_TYPE)) + "." + String.valueOf(LbUtils.getCommand().getOptionValue(LBOptions.Options.CHANGE_TYPE))).toLowerCase();
        return LbFileUtils.writeFile(LbUtils.getContext(), fileName, change);
    }

    public static String generateOrdsModuleCommand() throws Exception {
        SchemaGenerator gen = new SchemaGenerator();
        String change = gen.getOrdsModuleChangeLog();
        if (null == change || change.isEmpty()) {
            return null;
        }
        String module = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.MODULE_NAME);
        String fileName = "ords_rest_module_" + module.toLowerCase() + ".xml";
        return Messages.format("FILE_GENERATED", LbFileUtils.writeFile(LbUtils.getContext(), fileName, change));
    }

    public static String generateOrdsSchemaCommand() throws Exception {
        SchemaGenerator gen = new SchemaGenerator();
        String change = gen.getOrdsSchemaChangeLog();
        if (null == change || change.isEmpty()) {
            return null;
        }
        String fileName = "ords_rest_schema.xml";
        return Messages.format("FILE_GENERATED", LbFileUtils.writeFile(LbUtils.getContext(), "ords_rest_schema.xml", change));
    }

    public static void generateSchemaCommand() throws Exception {
        SchemaGenerator gen = new SchemaGenerator();
        gen.doSchemaExport(true);
    }

    private static class DeploymentHistory {
        public final List<DeploymentDetails> deployments = new ArrayList<DeploymentDetails>();

        private DeploymentHistory() {
        }

        public String toString() {
            return this.deployments.size() + " past deployments";
        }
    }

    private static class DeploymentDetails {
        protected static final List<RanChangeSet> changeSets = new ArrayList<RanChangeSet>();

        private DeploymentDetails() {
        }

        public String getDeploymentId() {
            if (changeSets.isEmpty()) {
                return null;
            }
            return changeSets.get(0).getDeploymentId();
        }

        public void printReport(PrintWriter output) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
            String executionTime = null;
            RanChangeSet firstChangeSet = changeSets.get(0);
            if (changeSets.size() > 1) {
                RanChangeSet last = changeSets.get(changeSets.size() - 1);
                long executionMs = last.getDateExecuted().getTime() - firstChangeSet.getDateExecuted().getTime();
                executionTime = (float)executionMs / 1000.0f + "s";
            }
            StringBuilder message = new StringBuilder("- Database updated at ").append(dateFormat.format(firstChangeSet.getDateExecuted())).append(". Applied ").append(changeSets.size()).append(" changeset(s)");
            if (executionTime != null) {
                message.append(" in ").append(executionTime);
            }
            message.append(", DeploymentId: ").append(firstChangeSet.getDeploymentId());
            output.println(message);
            for (RanChangeSet changeSet : changeSets) {
                output.println("  " + changeSet.toString());
            }
            output.println("");
            changeSets.clear();
        }
    }
}

