/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.auth;

import java.util.EnumSet;
import oracle.cloudstorage.api.IRequestBuilder;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.auth.IAuthKeepAliveStrategy;
import oracle.cloudstorage.api.auth.IAuthReply;
import oracle.cloudstorage.api.auth.IAuthRequestBuilder;
import oracle.cloudstorage.api.auth.IAuthStrategy;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.http.Status;
import oracle.cloudstorage.api.request.processor.ISendable;
import oracle.cloudstorage.api.retry.IRetryStrategy;
import oracle.cloudstorage.api.retry.PrioritizedRetryStrategy;
import oracle.cloudstorage.api.retry.RetryException;
import oracle.cloudstorage.api.retry.RetryState;
import oracle.cloudstorage.text.Marker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReAuthOnResponseStatus
implements IAuthKeepAliveStrategy {
    private static Logger logger = LoggerFactory.getLogger(ReAuthOnResponseStatus.class);
    private IAuthStrategy authStrategy = null;
    private final EnumSet<Status> reAuthOnStati;

    public ReAuthOnResponseStatus(Status reAuthOnStatus, Status ... otherReAuthOnStati) {
        this.reAuthOnStati = EnumSet.of(reAuthOnStatus, otherReAuthOnStati);
    }

    protected boolean reAuthOn(Status status) {
        return this.reAuthOnStati.contains((Object)status);
    }

    @Override
    public IRetryStrategy buildRetry(final IAuthStrategy authStrategy, final IAuthRequestBuilder authRequestBuilder) {
        if (this.authStrategy != null) {
            return null;
        }
        this.authStrategy = authStrategy;
        logger.debug(Marker.auth.marker, "Initializing {}.", (Object)this);
        PrioritizedRetryStrategy retryStrategy = new PrioritizedRetryStrategy(1000){

            @Override
            public RetryState reset() {
                return new RetryState();
            }

            @Override
            public IRetryStrategy.Cue onResponse(IRequestBuilder builder, int rawHttpStatusCode, Throwable throwable, RetryState retryState) throws RetryException, InterruptedException {
                if (builder instanceof IAuthRequestBuilder) {
                    return IRetryStrategy.Cue.none;
                }
                if (retryState.getAttempt() > 0) {
                    logger.debug(Marker.auth.marker, "Multiple auth failures, {} attempts.", (Object)retryState.getAttempt());
                    return IRetryStrategy.Cue.none;
                }
                Status status = Status.fromStatusCode(rawHttpStatusCode);
                if (ReAuthOnResponseStatus.this.reAuthOn(status)) {
                    IAuthReply previousReply = retryState.getAuthReply();
                    logger.debug(Marker.auth.marker, "Re-authenticating due to {} use of {}.", (Object)status, (Object)previousReply);
                    retryState.closeResponseAdapter(false);
                    IAuthReply authReply = authStrategy.authenticate(authRequestBuilder, previousReply);
                    logger.debug(Marker.auth.marker, "Re-authenticated with result: {}", (Object)authReply);
                    if (authReply.getStatus().getFamily() == Status.Family.SUCCESSFUL) {
                        ISendable sendable = builder.getSendable();
                        sendable.getHeaders().put(Header.storageToken.provide(authReply.getStorageToken()));
                    }
                    retryState.incrementAttempt();
                    return IRetryStrategy.Cue.retry;
                }
                logger.debug(Marker.auth.marker, "No re-authentication attempt for {}.", (Object)status);
                return IRetryStrategy.Cue.none;
            }
        };
        return retryStrategy;
    }

    @Override
    public void validate(ISession session) {
        IAuthStrategy sessionAuthStrategy = session.getAuthStrategy();
        if (this.authStrategy != sessionAuthStrategy) {
            throw new IllegalStateException("Instances of " + this.getClass().getSimpleName() + " may not be shared.  " + ISession.class.getSimpleName() + " must have the same authenticator as " + this.getClass().getSimpleName() + ".  Expected " + this.authStrategy + " but " + session + " is using " + sessionAuthStrategy + ".");
        }
        IAuthReply reply = sessionAuthStrategy.getReply();
        if (reply != null) {
            throw new IllegalStateException(this.getClass() + " requires that the first authentication for the given " + ISession.class + " is in progress, but " + session + " has already attemped authentication:\n" + reply);
        }
        if (!sessionAuthStrategy.isAuthenticating()) {
            throw new IllegalStateException(this.getClass() + " requires that the first authentication for the given " + ISession.class + " is in progress, but " + session + " is not being authenticated.");
        }
    }

    public String toString() {
        return ReAuthOnResponseStatus.class.getSimpleName() + ": " + this.reAuthOnStati;
    }
}

