/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api;

import java.security.KeyPair;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import oracle.cloudstorage.api.ISession;
import oracle.cloudstorage.api.auth.IAuthStrategy;
import oracle.cloudstorage.api.cipher.ICipher;
import oracle.cloudstorage.api.request.processor.ISender;
import oracle.cloudstorage.api.retry.IRetryStrategy;

public interface ISessionBuilder {

    public static interface Session {
        public ISession session();
    }

    public static interface Expect
    extends Session {
        public Session enableExpect100Continue(boolean var1);
    }

    public static interface Executor
    extends Expect {
        public Expect executor(ExecutorService var1);
    }

    public static interface CipherKeyPair
    extends Executor {
        public Executor cipherKeys(KeyPair var1);
    }

    public static interface Cipher
    extends CipherKeyPair {
        public CipherKeyPair cipher(ICipher var1);
    }

    public static interface Auth
    extends Cipher {
        public Cipher authenticator(IAuthStrategy var1);
    }

    public static interface Buffer
    extends Auth {
        public Auth buffer(int var1);
    }

    public static interface Chunk
    extends Buffer {
        public Buffer chunk();

        public Buffer chunk(boolean var1);

        public Buffer chunk(int var1);
    }

    public static interface ReadTimeout
    extends Chunk {
        public Chunk read(long var1, TimeUnit var3);
    }

    public static interface ConnectTimeout
    extends ReadTimeout {
        public ReadTimeout connect(long var1, TimeUnit var3);
    }

    public static interface RetryStrategy
    extends ConnectTimeout {
        public ConnectTimeout retry(IRetryStrategy var1);
    }

    public static interface Sender
    extends RetryStrategy {
        public RetryStrategy sender(ISender var1);
    }
}

