/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.dg;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.dbtools.raptor.utils.oerr.Oerr;
import oracle.dbtools.raptor.utils.oerr.OerrException;
import oracle.dbtools.sqlcl.commands.dg.DgConfig;
import oracle.dbtools.sqlcl.commands.dg.DgConfigInst;
import oracle.dbtools.sqlcl.commands.dg.DgConfigMember;
import oracle.dbtools.sqlcl.commands.dg.DgConstants;
import oracle.dbtools.sqlcl.commands.dg.DgDBUtils;
import oracle.dbtools.sqlcl.commands.dg.DgDBVersion;
import oracle.dbtools.sqlcl.commands.dg.DgOpTable;
import oracle.dbtools.sqlcl.commands.dg.DgResult;
import oracle.dbtools.sqlcl.commands.dg.DgResultMessage;
import oracle.dbtools.sqlcl.commands.dg.DgStatus;
import oracle.dbtools.sqlcl.commands.dg.DgUtils;
import oracle.dbtools.sqlcl.commands.dg.DgValue;
import oracle.dbtools.sqlcl.commands.dg.DgXmlObject;
import oracle.dbtools.sqlcl.commands.dg.Messages;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.datasource.impl.OracleDataSource;

public abstract class DgCmdBase {
    protected static final Logger LOGGER = Logger.getLogger(DgCmdBase.class.getName());
    protected ScriptRunnerContext scriptCtx = null;
    protected Connection sqlConn = null;

    public DgCmdBase(ScriptRunnerContext scriptCtx, Connection sqlConn) {
        this.scriptCtx = scriptCtx;
        this.sqlConn = sqlConn;
    }

    protected void printException(Exception ex) {
        LOGGER.log(Level.INFO, ex.getMessage(), ex);
    }

    protected void printOraError(int err) {
        this.printOraError(err, null, null);
    }

    protected void printOraError(int err, String arg1) {
        this.printOraError(err, arg1, null);
    }

    protected void printOraError(int err, String arg1, String arg2) {
        if (arg2 != null) {
            this.scriptCtx.write(String.format(this.getORAMessage(err, Messages.getString("DGCmd.ERROR")) + "\n", arg1, arg2));
        } else if (arg1 != null) {
            this.scriptCtx.write(String.format(this.getORAMessage(err, Messages.getString("DGCmd.ERROR")) + "\n", arg1));
        } else {
            this.scriptCtx.write(this.getORAMessage(err, Messages.getString("DGCmd.ERROR")) + "\n");
        }
    }

    protected void printOraWarn(int err) {
        this.printOraWarn(err, null, null);
    }

    protected void printOraWarn(int err, String arg1, String arg2) {
        if (arg2 != null) {
            this.scriptCtx.write(String.format(this.getORAMessage(err, Messages.getString("DGCmd.WARNING")) + "\n", arg1, arg2));
        } else if (arg1 != null) {
            this.scriptCtx.write(String.format(this.getORAMessage(err, Messages.getString("DGCmd.WARNING")) + "\n", arg1));
        } else {
            this.scriptCtx.write(this.getORAMessage(err, Messages.getString("DGCmd.WARNING")) + "\n");
        }
    }

    protected String getORAMessage(int err, String level) {
        String errMsg = null;
        String prefix = "";
        if (level != null) {
            prefix = String.format("%s: ", level);
        }
        try {
            Matcher m;
            Oerr oerr = new Oerr();
            String errOut = oerr.oerr("ora", String.format("%d", err));
            String[] lines = errOut.split("[\n\r]", 2);
            if (lines.length > 0 && (m = Pattern.compile("[^\"]+\"(.*)\"\\s*$", 32).matcher(lines[0])).matches()) {
                errMsg = DgUtils.trimQuotes(m.group(1));
            }
            if (errMsg == null) {
                LOGGER.warning("Error message parse error: " + errOut);
                errMsg = String.format("ORA-%d", err);
            }
        }
        catch (OerrException oe) {
            if (err == 16897) {
                errMsg = Messages.getString("DGCmd.ORA-16897");
            }
            errMsg = err == 16898 ? Messages.getString("DGCmd.ORA-16898") : String.format("ORA-%d", err);
        }
        return String.format("%sORA-%d: %s", prefix, err, errMsg);
    }

    public void printResultAll(DgResult result, String successMessage) {
        LOGGER.info("messages: " + result.resultMsgList.size());
        for (DgResultMessage rm : result.resultMsgList) {
            this.printResultMsg(rm, successMessage);
        }
    }

    public void printResultOne(DgResult result, String successMessage) {
        this.printResultMsg(result.resultMsgList.get(0), successMessage);
    }

    public void printResultMsg(DgResultMessage rm, String successMessage) {
        if ((rm.severity == 0 || rm.severity == 16502) && successMessage != null) {
            this.scriptCtx.write(successMessage + "\n");
        } else {
            String errMsg = rm.toString();
            if (errMsg != null && errMsg.length() > 0) {
                this.scriptCtx.write(errMsg.trim() + "\n");
            }
        }
    }

    protected boolean checkConnection() {
        if (this.sqlConn == null) {
            this.scriptCtx.write(Messages.getString("DGCmd.CONNERR"));
            return false;
        }
        Properties props = (Properties)this.scriptCtx.getProperty("cli.conn.props");
        String priv = props.getProperty("internal_logon");
        if (!"sysdba".equalsIgnoreCase(priv) && !"sysdg".equalsIgnoreCase(priv)) {
            this.scriptCtx.write(Messages.getString("DGCmd.PRIVERR"));
            LOGGER.info("priv: " + priv);
            return false;
        }
        DgDBVersion dbVersion = this.getDBVersion();
        if (dbVersion == null) {
            this.scriptCtx.write(Messages.getString("DGCmd.VERSIONERR"));
            return false;
        }
        if (dbVersion.lessThan(DgConstants.MIN_COMPATIBLE_VERSION)) {
            LOGGER.info(String.format("DB Version: %d.%d", dbVersion.majorVersion, dbVersion.minorVersion));
            this.scriptCtx.write(Messages.getString("DGCmd.VERSIONERR"));
            return false;
        }
        if (!(this.sqlConn instanceof OracleConnection)) {
            this.scriptCtx.write(Messages.getString("DGCmd.NOTORACLE"));
            return false;
        }
        return true;
    }

    protected void ctxFlush() {
        try {
            this.scriptCtx.getOutputStream().flush();
        }
        catch (IOException e) {
            LOGGER.warning(e.getLocalizedMessage());
        }
    }

    protected DgDBVersion getDBVersion() {
        if (this.sqlConn != null) {
            return DgDBUtils.getVersion(this.sqlConn);
        }
        return null;
    }

    protected DgStatus sendAnalyz(DgConfig dgConfig, String indoc, String context) {
        DgStatus out = new DgStatus();
        String outdoc = DgDBUtils.doControl(this.sqlConn, indoc, context);
        boolean dmonError = false;
        if (outdoc != null) {
            out.severity = 0;
            DgXmlObject obj = DgXmlObject.create(outdoc);
            LOGGER.info("root name: " + obj.getName());
            if (obj instanceof DgResult) {
                DgResult result = (DgResult)obj;
                DgResultMessage rm = result.resultMsgList.get(0);
                out = new DgStatus();
                if (rm.severity == 0 || rm.severity == 16502 || rm.errNum == 16805) {
                    out.dmonError = 0;
                } else {
                    out.dmonError = rm.errNum;
                    this.printFailed();
                }
            } else if (obj instanceof DgOpTable) {
                out = this.handleOpTable(dgConfig, (DgOpTable)obj);
            } else {
                LOGGER.info("Unknown type of outdoc: " + outdoc);
                out.severity = 16501;
            }
        } else {
            out.severity = 16501;
        }
        LOGGER.info(String.format("out: severity=%d, dmonError=%d\n", out.severity, out.dmonError));
        return out;
    }

    protected DgStatus handleOpTable(DgConfig config, DgOpTable optable) {
        DgStatus out = new DgStatus();
        out.dmonError = 0;
        out.severity = 0;
        if (optable == null) {
            return out;
        }
        try {
            for (List<String> tr : optable.trList) {
                String op = tr.get(0);
                int objid = Integer.valueOf(tr.get(1));
                String connstr = tr.get(2);
                Object dbun = null;
                int memID = DgUtils.extractMemberId(objid);
                int instID = DgUtils.extractInstanceId(objid);
                DgConfigMember memberCfg = config.getMember(memID);
                if (memberCfg == null) {
                    LOGGER.warning("member ID mismatch");
                    out.severity = 16501;
                }
                if (op.equalsIgnoreCase("OPENING")) {
                    this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.17009"), memberCfg.name));
                    this.ctxFlush();
                    continue;
                }
                if (op.equalsIgnoreCase("REDIRECT")) {
                    if (memberCfg.dgbcid != null) {
                        this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.16939"), memberCfg.name));
                        this.scriptCtx.write(Messages.getString("DGCmd.16940"));
                        LOGGER.info(String.format("connecting to %d.%d using '%s'", memID, instID, connstr));
                        Connection newConn = this.connect(connstr, null, false);
                        if (newConn != null) {
                            this.scriptCtx.getMap().put(ScriptRunnerContext.SqlplusVariable._CONNECT_IDENTIFIER.toString(), connstr);
                            this.scriptCtx.setCurrentConnection(newConn);
                            this.sqlConn = newConn;
                        } else {
                            this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.CONNERR2"), memberCfg.name, connstr));
                            out.severity = 16501;
                        }
                        out.dmonError = 16523;
                    }
                    this.ctxFlush();
                    continue;
                }
                if (op.equalsIgnoreCase("STARTUP") || op.equalsIgnoreCase("STARTUP MOUNT")) {
                    DgConfigInst inst = memberCfg.getInst(instID);
                    if (inst == null) {
                        LOGGER.warning("instance ID mismatch");
                        out.severity = 16501;
                    }
                    this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.16908"), inst.name, memberCfg.name));
                    this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.16932"), inst.name));
                    this.ctxFlush();
                    boolean open = false;
                    if (op.equalsIgnoreCase("STARTUP")) {
                        open = true;
                    }
                    if (!this.startup(connstr, open)) {
                        out.severity = 16501;
                    }
                    out.dmonError = 16570;
                    this.ctxFlush();
                    continue;
                }
                if (op.equalsIgnoreCase("SHUTDOWN") || op.equalsIgnoreCase("SHUTDOWN ABORT")) {
                    DgConfigInst inst = memberCfg.getInst(instID);
                    this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.16907"), inst.name, memberCfg.name));
                    this.scriptCtx.write(MessageFormat.format(Messages.getString("DGCmd.16914"), inst.name));
                    this.ctxFlush();
                    boolean ret = op.equalsIgnoreCase("SHUTDOWN ABORT") ? this.shutdown(connstr, true) : this.shutdown(connstr, false);
                    if (!ret) {
                        out.severity = 16501;
                    }
                    out.dmonError = 16631;
                    this.ctxFlush();
                    continue;
                }
                LOGGER.warning(String.format("Unknown operation: %s", op));
                out.severity = 16501;
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, ex.getMessage(), ex);
            out.severity = 16501;
        }
        LOGGER.info(String.format("out: severity=%d, dmonError=%d\n", out.severity, out.dmonError));
        return out;
    }

    protected void printFailed() {
        this.scriptCtx.write(Messages.getString("DGCmd.FAILED"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean startup(String sciConnStr, boolean open) {
        boolean bl;
        Connection dgConn2;
        Connection dgConn1;
        Statement stmt;
        block44: {
            block45: {
                block47: {
                    block46: {
                        stmt = null;
                        String sql_mount = "alter database mount";
                        String sql_open = "alter database open";
                        int ret = -1;
                        boolean started = false;
                        int TIMEOUT = 60;
                        dgConn1 = null;
                        dgConn2 = null;
                        Instant t0 = Instant.now();
                        int interval = 1;
                        while (!started) {
                            if (dgConn1 != null) {
                                try {
                                    dgConn1.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if ((dgConn1 = this.connectSCI(sciConnStr, true)) != null) {
                                try {
                                    LOGGER.info("starting up the instance ...");
                                    OracleConnection oConn = (OracleConnection)dgConn1;
                                    oConn.startup(OracleConnection.DatabaseStartupMode.NO_RESTRICTION);
                                    this.scriptCtx.write(Messages.getString("DGCmd.703"));
                                    this.ctxFlush();
                                    started = true;
                                }
                                catch (Exception ex) {
                                    this.printException(ex);
                                }
                            }
                            if (started) continue;
                            Duration timeElapsed = Duration.between(t0, Instant.now());
                            if (timeElapsed.getSeconds() < 60L) {
                                TimeUnit.SECONDS.sleep(interval);
                                if (interval < 6) {
                                    ++interval;
                                }
                                LOGGER.info("retrying connecting ...");
                                continue;
                            }
                            LOGGER.info("Timeout");
                            break;
                        }
                        if (!started) break block45;
                        dgConn2 = this.connectSCI(sciConnStr, false);
                        if (dgConn2 == null) break block46;
                        LOGGER.info("mounting the instance ...");
                        stmt = dgConn2.createStatement();
                        ret = stmt.executeUpdate("alter database mount");
                        if (ret >= 0) {
                            this.scriptCtx.write(Messages.getString("DGCmd.705"));
                            this.ctxFlush();
                            if (open && (ret = stmt.executeUpdate("alter database open")) >= 0) {
                                this.scriptCtx.write(Messages.getString("DGCmd.706"));
                            }
                        }
                        break block47;
                    }
                    this.scriptCtx.write(Messages.getString("DGCmd.ERR_MOUNT"));
                }
                this.ctxFlush();
                boolean bl2 = true;
                if (dgConn1 != null) {
                    try {
                        dgConn1.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (dgConn2 != null) {
                    try {
                        dgConn2.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                DgDBUtils.cleanup(stmt, null);
                return bl2;
            }
            this.scriptCtx.write(Messages.getString("DGCmd.ERR_STARTUP"));
            bl = false;
            if (dgConn1 == null) break block44;
            try {
                dgConn1.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (dgConn2 != null) {
            try {
                dgConn2.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DgDBUtils.cleanup(stmt, null);
        return bl;
        catch (SQLException ex) {
            this.scriptCtx.write(ex.getMessage());
            return false;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (Exception ex2) {
                LOGGER.log(Level.INFO, ex2.getMessage(), ex2);
                return false;
            }
        }
        finally {
            if (dgConn1 != null) {
                try {
                    dgConn1.close();
                }
                catch (Exception ex) {}
            }
            if (dgConn2 != null) {
                try {
                    dgConn2.close();
                }
                catch (Exception ex) {}
            }
            DgDBUtils.cleanup(stmt, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shutdown(String connStr, boolean abort) {
        Connection dgConn = null;
        try {
            dgConn = this.connectSCI(connStr, true);
            if (dgConn != null) {
                LOGGER.info("shutting down instance ...");
                OracleConnection oConn = (OracleConnection)dgConn;
                if (abort) {
                    oConn.shutdown(OracleConnection.DatabaseShutdownMode.ABORT);
                } else {
                    DBUtil db = DBUtil.getInstance((Connection)dgConn);
                    oConn.shutdown(OracleConnection.DatabaseShutdownMode.IMMEDIATE);
                    db.execute("alter database close normal");
                    this.scriptCtx.write(Messages.getString("DGCmd.708"));
                    this.ctxFlush();
                    db.execute("alter database dismount");
                    this.scriptCtx.write(Messages.getString("DGCmd.707"));
                    this.ctxFlush();
                    oConn.shutdown(OracleConnection.DatabaseShutdownMode.FINAL);
                }
                this.scriptCtx.write(Messages.getString("DGCmd.704"));
                this.ctxFlush();
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException ex) {
            this.scriptCtx.write(ex.getMessage());
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, ex.getMessage(), ex);
        }
        finally {
            if (dgConn != null) {
                try {
                    dgConn.close();
                }
                catch (Exception ex) {}
            }
        }
        return false;
    }

    private String getPassword() {
        Properties props = (Properties)this.scriptCtx.getProperty("cli.conn.props");
        return props.getProperty("password");
    }

    private Connection connectSCI(String connStr, boolean prelim) throws SQLException {
        return this.connect(connStr, "SYSDBA", prelim);
    }

    private Connection connect(String connStr, String role, boolean prelim) throws SQLException {
        Object url = "jdbc:oracle:thin:@";
        String connectData = null;
        ArrayList myTNSEntries = TNSHelper.getTNSEntries();
        if (myTNSEntries != null) {
            for (TCPTNSEntry entry : myTNSEntries) {
                if (!entry.getName().equalsIgnoreCase(connStr)) continue;
                connectData = entry.getSpecUrl();
                break;
            }
        }
        url = connectData != null ? (String)url + connectData : (String)url + connStr;
        Properties props = (Properties)this.scriptCtx.getProperty("cli.conn.props");
        if (role != null) {
            props.setProperty("internal_logon", role);
        }
        if (prelim) {
            props.setProperty("prelim_auth", "true");
        } else {
            props.setProperty("prelim_auth", "false");
        }
        LOGGER.info("connStr:        " + connStr);
        LOGGER.info("url:            " + (String)url);
        LOGGER.info("user:           " + props.getProperty("user"));
        LOGGER.info("password:       " + props.getProperty("password"));
        LOGGER.info("internal_logon: " + props.getProperty("internal_logon"));
        LOGGER.info("prelim_auth:    " + props.getProperty("prelim_auth"));
        try {
            OracleDataSource datasource = new OracleDataSource();
            datasource.setURL((String)url);
            datasource.setConnectionProperties(props);
            return datasource.getConnection();
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, ex.getMessage(), ex);
            return null;
        }
    }

    protected String getMonitorProperty(Connection conn, int objectID, String property) {
        String indoc = String.format("<DO_MONITOR version=\"%s\"><PROPERTY name=\"%s\" object_id=\"%d\"/></DO_MONITOR>", "23.1.0.0.0", property, objectID);
        return DgDBUtils.doControl(conn, indoc, null);
    }

    protected String getMonitorPropValueStr(Connection conn, int objectID, String property) {
        DgXmlObject out;
        String outdoc = this.getMonitorProperty(conn, objectID, property);
        LOGGER.info("outdoc: " + outdoc);
        if (outdoc != null && (out = DgXmlObject.create(outdoc)) instanceof DgValue) {
            return ((DgValue)out).value;
        }
        return null;
    }
}

