/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extract.models;

import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.common.ddl.DDLFormat;
import oracle.dbtools.common.ddl.DDLTypes;
import oracle.dbtools.common.utils.BasicDBObject;
import oracle.dbtools.common.utils.DBURLUtil;
import oracle.dbtools.datatools.BaseDataFormat;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.extract.ExtractReconciler;
import oracle.dbtools.extract.ExtractResources;
import oracle.dbtools.extract.models.ExtractConnectionAccess;
import oracle.dbtools.extract.models.ExtractConnectionAccessCatalog;
import oracle.dbtools.extract.models.ExtractDataFormat;
import oracle.dbtools.extract.models.ExtractObject;
import oracle.dbtools.extract.models.ExtractScript;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.util.Logger;

public class ExtractListModel {
    public static final int TYPE_ALL_OBJECTS = 0;
    public static final int TYPE_CREATE = 1;
    public static final int TYPE_CREATE_PRE_DATA = 2;
    public static final int TYPE_CREATE_POST_DATA = 3;
    public static final int TYPE_DROP = 4;
    public static final int TYPE_TRUNCATE = 5;
    public static final int TYPE_ENABLE_CONSTRAINTS = 6;
    public static final int TYPE_DISABLE_CONSTRAINTS = 7;
    public static final int TYPE_DATA = 8;
    public static final int TYPE_PRE_SCRIPT = 9;
    public static final int TYPE_POST_SCRIPT = 10;
    public static final int TYPE_OBJECT_SCRIPT = 11;
    public static final int TYPE_SPATIAL_META_ALL = 12;
    public static final int TYPE_SPATIAL_META_NEW = 13;
    public static final int TYPE_SPATIAL_META_ALL_CONS = 14;
    public static final int TYPE_SPATIAL_META_NEW_CONS = 15;
    public static final String TYPE_OBJECT_NAME = ExtractResources.getString("TYPE_OBJECT_NAME");
    public static final String TYPE_CREATE_NAME = ExtractResources.getString("TYPE_CREATE_NAME");
    public static final String TYPE_CREATE_PRE_DATA_NAME = ExtractResources.getString("TYPE_CREATE_PRE_DATA_NAME");
    public static final String TYPE_CREATE_POST_DATA_NAME = ExtractResources.getString("TYPE_CREATE_POST_DATA_NAME");
    public static final String TYPE_DROP_NAME = ExtractResources.getString("TYPE_DROP_NAME");
    public static final String TYPE_TRUNCATE_NAME = ExtractResources.getString("TYPE_TRUNCATE_NAME");
    public static final String TYPE_ENABLE_CONSTRAINTS_NAME = ExtractResources.getString("TYPE_ENABLE_CONSTRAINTS_NAME");
    public static final String TYPE_DISABLE_CONSTRAINTS_NAME = ExtractResources.getString("TYPE_DISABLE_CONSTRAINTS_NAME");
    public static final String TYPE_DATA_NAME = ExtractResources.getString("TYPE_DATA_NAME");
    public static final String TYPE_PRE_SCRIPT_NAME = ExtractResources.getString("TYPE_PRE_SCRIPT_NAME");
    public static final String TYPE_POST_SCRIPT_NAME = ExtractResources.getString("TYPE_POST_SCRIPT_NAME");
    public static final String TYPE_OBJECT_SCRIPT_NAME = ExtractResources.getString("TYPE_OBJECT_SCRIPT_NAME");
    public static final String TYPE_SPATIAL_META_ALL_NAME = ExtractResources.getString("TYPE_SPATIAL_META_ALL_NAME");
    public static final String TYPE_SPATIAL_META_NEW_NAME = ExtractResources.getString("TYPE_SPATIAL_META_NEW_NAME");
    public static final String TYPE_SPATIAL_META_ALL_CONS_NAME = ExtractResources.getString("TYPE_SPATIAL_META_ALL_CONS_NAME");
    public static final String TYPE_SPATIAL_META_NEW_CONS_NAME = ExtractResources.getString("TYPE_SPATIAL_META_NEW_CONS_NAME");
    public static final String[] LIST_TYPE_NAMES = new String[]{TYPE_OBJECT_NAME, TYPE_CREATE_NAME, TYPE_CREATE_PRE_DATA_NAME, TYPE_CREATE_POST_DATA_NAME, TYPE_DROP_NAME, TYPE_TRUNCATE_NAME, TYPE_ENABLE_CONSTRAINTS_NAME, TYPE_DISABLE_CONSTRAINTS_NAME, TYPE_DATA_NAME, TYPE_PRE_SCRIPT_NAME, TYPE_POST_SCRIPT_NAME, TYPE_OBJECT_SCRIPT_NAME, TYPE_SPATIAL_META_ALL_NAME, TYPE_SPATIAL_META_NEW_NAME, TYPE_SPATIAL_META_ALL_CONS_NAME, TYPE_SPATIAL_META_NEW_CONS_NAME};
    public static final int OPT_EXTRACT_METADATA = 100;
    public static final int OPT_EXTRACT_DATA = 101;
    public static final int OPT_DATA_OBJECT = 102;
    public static final int OPT_EXISTS_SOURCE = 103;
    public static final int OPT_EXISTS_DEST = 104;
    public static final int OPT_EXISTS_SOURCE_ONLY = 105;
    public static final int OPT_EXISTS_DEST_ONLY = 106;
    public static final int OPT_PRESELECTED = 107;
    public static final int OPT_SELECTED_META = 108;
    public static final int OPT_SELECTED_DATA = 109;
    public static final int OPT_BEFORE_CREATE_SCRIPT = 110;
    public static final int OPT_AFTER_CREATE_SCRIPT = 111;
    public static final int OPT_BEFORE_LOAD_SCRIPT = 112;
    public static final int OPT_AFTER_LOAD_SCRIPT = 113;
    public static final int OPT_INITIAL_SCRIPT = 114;
    public static final int OPT_FINAL_SCRIPT = 115;
    public static final String KEY_EXTRACT_LIST_MODEL = "EXTRACT_LIST_MODEL";
    private static final int DBO = 0;
    private static final int QUERY = 1;
    private int _dataObjectType;
    private DDLTypes _ddlTypes;
    private DDLFormat _ddlFormat;
    private ExtractDataFormat _dataFormat;
    private List<ExtractObject> _EOList = new ArrayList<ExtractObject>();
    private List<ExtractObject> _destEOList = new ArrayList<ExtractObject>();
    private boolean _isDDLEnabled = false;
    private boolean _isDataEnabled = false;
    private String _sourceConnName = "";
    private String _destConnName = "";
    private Connection _sourceConn;
    private Connection _destConn;
    private String _sourceConnUser;
    private String _destConnUser;
    private List<String> _schemaList = new ArrayList<String>();
    private String[] _tablespaces;
    private boolean _isSourceConnOracle = true;
    private boolean _isSourceConnTimesTen = false;
    private boolean _isDestConnOracle = true;
    private boolean _isDestConnTimesTen = false;
    private boolean _isAllowLobs = true;
    private boolean _isAllowVirtual = true;
    private boolean _isPreSelected = false;
    private boolean _isPreSelectedDataExtractable = false;
    private boolean _isDestList = false;
    private boolean _isSelectedData = false;
    private boolean _isSelectedMetaData = false;
    private ExtractReconciler.ReconcileType _reconcileType = ExtractReconciler.ReconcileType.TYPES_AND_OBJECTS;
    private String _globalWhere = "";
    private HashMap<String, Object> _extendedProperties = new HashMap();
    private ExtractReconciler _listReconciler = new ExtractReconciler(this);
    public static final String MDSYS = "MDSYS";
    public static final String NON_USER_META = "SDO_GEOM_METADATA_TABLE";
    public static final String NON_USER_SDO_GEOM_META = "MDSYS.SDO_GEOM_METADATA_TABLE";
    public static final String USER_SDO_GEOM_META = "MDSYS.USER_SDO_GEOM_METADATA";
    final String USER_SOURCE_COLS = "TABLE_NAME, COLUMN_NAME, DIMINFO, SRID";
    final String NON_USER_SOURCE_COLS = "OWNER, TABLE_NAME, COLUMN_NAME, DIMINFO, SRID";
    final String USER_DEST_COLS = "TABLE_NAME, COLUMN_NAME, DIMINFO, SRID";
    final String NON_USER_DEST_COLS = "SDO_OWNER, SDO_TABLE_NAME, SDO_COLUMN_NAME, SDO_DIMINFO, SDO_SRID";
    final String OWNER_COL = "OWNER";
    final String NON_USER_OWNER_COL = "SDO_OWNER";
    final String TABLE_NAME_COL = "TABLE_NAME";
    final String NON_USER_TABLE_NAME_COL = "SDO_TABLE_NAME";
    final String TABLE = "TABLE";
    final String AND = " AND ";
    final String EQ = " = ";
    final String DOT = ".";
    final String IN = " IN(";
    final String SQ = "'";
    final String CLOSEP = ")";
    final String OPENP = "(";

    public ExtractListModel() {
        this._dataObjectType = 0;
    }

    public ExtractListModel(Object table, String connName) {
        this._dataObjectType = 1;
        this.setSourceConnectionProperties(connName);
        this._EOList.add(new ExtractObject(table, this));
    }

    public ExtractListModel(BasicDBObject DBObject) {
        this.initForDBObjects(DBObject);
    }

    public ExtractListModel(List<BasicDBObject> DBObjectList) {
        this.initForDBObjects(DBObjectList);
    }

    public ExtractListModel(BasicDBObject[] dbos) {
        this.initForDBObjects(dbos);
    }

    public void setReconcileType(ExtractReconciler.ReconcileType type) {
        this._reconcileType = type;
    }

    public ExtractReconciler.ReconcileType getReconcileType() {
        return this._reconcileType;
    }

    public String getSourceConnName() {
        return this._sourceConnName;
    }

    public void setSourceConnName(String value) {
        this.setSourceConnectionProperties(value);
    }

    public Connection getSourceConn() {
        if (this._sourceConnName != null && this._sourceConn == null) {
            try {
                this._sourceConn = ConnectionResolver.getConnection((String)this._sourceConnName);
            }
            catch (Exception e) {
                Logger.warn(this.getClass(), (Throwable)e);
            }
        }
        return this._sourceConn;
    }

    public String getSourceConnUser() {
        if (this._sourceConnUser.length() == 0) {
            this._sourceConnUser = this.getConnectionUser(this._sourceConnName);
        }
        return this._sourceConnUser;
    }

    public String getDestConnName() {
        return this._destConnName;
    }

    public void setDestConnName(String value) {
        this._destConnName = value;
        this.setDestConnectionProperties(value);
    }

    public Connection getDestConn() {
        return this._destConn;
    }

    public String getDestConnUser() {
        if (this._destConnUser.length() == 0 && this._destConnName != null && this._destConnName.length() != 0) {
            this._destConnUser = this.getConnectionUser(this._destConnName);
        }
        return this._destConnUser;
    }

    public boolean isDestList() {
        return this._isDestList;
    }

    public void isDestList(boolean value) {
        this._isDestList = value;
    }

    public List<ExtractObject> getDestExtractObjects() {
        return this._destEOList;
    }

    public void setDestExtractObjects(List<ExtractObject> eoList) {
        this._destEOList = eoList;
        this._isDestList = true;
    }

    public String[] getSchemas() {
        return this._schemaList.toArray(new String[this._schemaList.size()]);
    }

    public void setSchemas(String[] schemas) {
        this._schemaList.clear();
        for (String schema : schemas) {
            this._schemaList.add(schema);
        }
    }

    public void setSchemas() {
        this._schemaList.clear();
        for (ExtractObject EO : this._EOList) {
            int index;
            if (!EO.isDataObject() || (index = this._schemaList.indexOf(EO.getDBObject().getSchemaName())) != -1) continue;
            this._schemaList.add(EO.getDBObject().getSchemaName());
        }
    }

    public String[] getTablespaces() {
        return this._tablespaces;
    }

    public void setTablespaces(String[] tablespaces) {
        this._tablespaces = tablespaces;
    }

    public DDLTypes getDDLTypes() {
        if (this._ddlTypes == null) {
            this._ddlTypes = new DDLTypes();
        }
        return this._ddlTypes;
    }

    public void setDDLTypes(DDLTypes ddlTypes) {
        this._ddlTypes = ddlTypes;
    }

    public void isDDLEnabled(boolean enable) {
        this._isDDLEnabled = enable;
        if (this._isDDLEnabled && this._ddlFormat == null) {
            this._ddlFormat = new DDLFormat();
            this._ddlFormat.isExtractEnabled(true);
        }
    }

    public boolean isDDLEnabled() {
        return this._isDDLEnabled;
    }

    public void isDataEnabled(boolean enable) {
        this._isDataEnabled = enable;
        if (this._isDataEnabled && this._dataFormat == null) {
            this._dataFormat = new ExtractDataFormat(BaseDataFormat.EXPORT_WIZARD, BaseDataFormat.INSERT);
            this._dataFormat.isExportEnabled(enable);
        }
    }

    public boolean isDataEnabled() {
        return this._isDataEnabled;
    }

    public DDLFormat getDDLFormat() {
        if (this._isDDLEnabled && this._ddlFormat == null) {
            this.isDDLEnabled(true);
        }
        return this._ddlFormat;
    }

    public void setDDLFormat(DDLFormat ddlFormat) {
        this._ddlFormat = ddlFormat;
        this._isDDLEnabled = this._ddlFormat.isExtractEnabled();
    }

    public ExtractDataFormat getDataFormat() {
        if (this._isDataEnabled && this._dataFormat == null) {
            this.isDataEnabled(true);
        }
        return this._dataFormat;
    }

    public void setDataFormat(ExtractDataFormat dataFormat) {
        this._dataFormat = dataFormat;
        this._isDataEnabled = this._dataFormat.isExportEnabled();
        this._isAllowLobs = this._dataFormat.allowsLobs();
    }

    public ExtractReconciler getReconciler() {
        return this._listReconciler;
    }

    public void startProcess() {
        this._listReconciler.reconcileTypesAndObjects(103);
    }

    public void startProcess(IRaptorTaskProgressUpdater raptorTaskProgressUpdater) throws ExecutionException {
        this._listReconciler.reconcileTypesAndObjects(103, raptorTaskProgressUpdater);
    }

    public void startProcessReconcileObjects() {
        try {
            this.startProcessReconcileObjects(null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void startProcessReconcileObjects(IRaptorTaskProgressUpdater raptorTaskProgressUpdater) throws ExecutionException {
        this._listReconciler.reconcileObjects(103, raptorTaskProgressUpdater);
    }

    public void startProcessReconcileObjects(int optRestrict, IRaptorTaskProgressUpdater raptorTaskProgressUpdater) throws ExecutionException {
        this._listReconciler.reconcileObjects(103, optRestrict, raptorTaskProgressUpdater);
    }

    public void reconcileDestFromSource() {
        try {
            this._listReconciler.reconcileDestFromSource();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void reconcileDestFromSource(IRaptorTaskProgressUpdater raptorTaskProgressUpdater) throws ExecutionException {
        this._listReconciler.reconcileDestFromSource(raptorTaskProgressUpdater);
    }

    public void reconcileDestListFromSource() {
        try {
            this._listReconciler.reconcileDestListFromSource();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void reconcileDestListFromSource(IRaptorTaskProgressUpdater raptorTaskProgressUpdater) throws ExecutionException {
        this._listReconciler.reconcileDestListFromSource(raptorTaskProgressUpdater);
    }

    public void reconcileDestFull() {
        this._listReconciler.reconcileTypesAndObjects(104);
    }

    public void expandFolders(int listType, int[] eoOpts, IRaptorTaskProgressUpdater raptorTaskProgressUpdater) throws ExecutionException {
        this._listReconciler.expandFolders(listType, eoOpts, raptorTaskProgressUpdater);
    }

    public static String getListTypeName(int listType) {
        if (listType < LIST_TYPE_NAMES.length) {
            return LIST_TYPE_NAMES[listType];
        }
        return "";
    }

    public List<ExtractObject> getList(int listType) {
        ArrayList<ExtractObject> eoList = null;
        switch (listType) {
            case 0: {
                return this._EOList;
            }
            case 1: {
                return this.getCreateProcessList(listType, new int[]{100});
            }
            case 2: {
                return this.getCreateProcessList(listType, new int[]{100});
            }
            case 3: {
                return this.getCreateProcessList(listType, new int[]{100});
            }
            case 4: {
                return this.getCreateProcessList(listType, new int[]{100});
            }
            case 5: {
                return this.getCreateProcessList(5, new int[]{101});
            }
            case 7: {
                return this.getCreateProcessList(7, new int[]{101});
            }
            case 6: {
                return this.getCreateProcessList(6, new int[]{101});
            }
            case 8: {
                return this.getList(0, new int[]{101});
            }
            case 9: 
            case 10: {
                eoList = new ArrayList<ExtractObject>();
                int type = listType == 9 ? 2 : 3;
                for (ExtractObject EO : this._EOList) {
                    if (EO.getType() != type) continue;
                    eoList.add(EO);
                }
                return eoList;
            }
            case 11: {
                eoList = new ArrayList();
                for (ExtractObject EO : this._EOList) {
                    if (!EO.isIncludeScripts()) continue;
                    eoList.add(EO);
                }
                return eoList;
            }
            case 12: {
                return this.getSpatialMetaList(true, true);
            }
            case 13: {
                return this.getSpatialMetaList(false, true);
            }
            case 14: {
                return this.getSpatialMetaList(true, false);
            }
            case 15: {
                return this.getSpatialMetaList(false, false);
            }
        }
        return new ArrayList<ExtractObject>();
    }

    public List<ExtractObject> getList(int listType, int[] options) {
        List<ExtractObject> baseEOList = this.getList(listType);
        List<ExtractObject> list = ExtractListModel.getList(baseEOList, options);
        return list;
    }

    public static List<ExtractObject> getList(List<ExtractObject> eoList, int[] options) {
        ArrayList<ExtractObject> list = new ArrayList<ExtractObject>();
        for (ExtractObject EO : eoList) {
            block14: for (int option : options) {
                switch (option) {
                    case 100: {
                        if (!EO.isExtractMetaData() || list.contains(EO)) continue block14;
                        list.add(EO);
                        continue block14;
                    }
                    case 101: {
                        if (!EO.isExtractData() || list.contains(EO)) continue block14;
                        list.add(EO);
                        continue block14;
                    }
                    case 102: {
                        if (!EO.isDataObject() || list.contains(EO)) continue block14;
                        list.add(EO);
                        continue block14;
                    }
                    case 103: {
                        if (!EO.isExistsSource() || list.contains(EO)) continue block14;
                        list.add(EO);
                        continue block14;
                    }
                    case 104: {
                        if (!EO.isExistsDest() || list.contains(EO)) continue block14;
                        list.add(EO);
                        continue block14;
                    }
                    case 105: {
                        if (!EO.isExistsSource() || EO.isExistsDest() || list.contains(EO)) continue block14;
                        list.add(EO);
                        continue block14;
                    }
                    case 106: {
                        if (!EO.isExistsDest() || EO.isExistsSource() || list.contains(EO)) continue block14;
                        list.add(EO);
                        continue block14;
                    }
                    case 107: {
                        if (!EO.isPreSelected() || list.contains(EO)) continue block14;
                        list.add(EO);
                        continue block14;
                    }
                    case 108: {
                        if (!EO.isSelectedMetaData() || list.contains(EO)) continue block14;
                        list.add(EO);
                        continue block14;
                    }
                    case 109: {
                        if (!EO.isSelectedData() || list.contains(EO)) continue block14;
                        list.add(EO);
                        continue block14;
                    }
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: {
                        ExtractScript ES = EO.getScript(option);
                        if (ES == null || list.contains(EO)) continue block14;
                        list.add(EO);
                    }
                }
            }
        }
        return list;
    }

    public List<ExtractObject> getList(int listType, int[] options, String objectType) {
        List<ExtractObject> baseEOList = this.getList(listType, options);
        ArrayList<ExtractObject> list = new ArrayList<ExtractObject>();
        for (ExtractObject EO : baseEOList) {
            if (!EO.getDBObject().getObjectType().equals(objectType)) continue;
            list.add(EO);
        }
        return ExtractListModel.getList(list, options);
    }

    public List<ExtractObject> getListForType(List<ExtractObject> objectList, String type) {
        ArrayList<ExtractObject> list = new ArrayList<ExtractObject>();
        if (objectList == null || objectList.size() < 1) {
            return list;
        }
        for (ExtractObject eo : objectList) {
            if (eo.getType() == 0) {
                String t = eo.getDBObject().getObjectType();
                if (t == null || !t.equals(type)) continue;
                list.add(eo);
                continue;
            }
            if (eo.getType() != 4 || !type.equals("TABLE")) continue;
            list.add(eo);
        }
        return list;
    }

    public List<URL> getListURLs(int listType) {
        return this.getListURL(this.getList(listType));
    }

    public List<URL> getListURLs(int listType, int[] options) {
        return this.getListURL(this.getList(listType, options));
    }

    public List<URL> getURLListForType(ArrayList<URL> objectList, String type) {
        ArrayList<URL> list = new ArrayList<URL>();
        for (URL u : objectList) {
            if (u == null || !DBURLUtil.getParsedURL((URL)u).getObjectType().equals(type)) continue;
            list.add(u);
        }
        return list;
    }

    public ArrayList<ExtractObject> getSpatialMetaList(boolean isReplace, boolean isMaintain) {
        DDLTypes ddlTypes = this.getDDLTypes();
        if (!this.isDDLEnabled() || !ddlTypes.getTable()) {
            new ArrayList();
        }
        List<ExtractObject> tableEOs = this.getListForType(this.getList(0, new int[]{100}), "TABLE");
        ExtractConnectionAccessCatalog connAccessCatalog = new ExtractConnectionAccessCatalog(tableEOs, true);
        ArrayList<ExtractObject> spatialMetaEOs = new ArrayList<ExtractObject>();
        String sep = "";
        String toSchema = "";
        String connUser = "";
        String sourceTable = "";
        for (Connection conn : connAccessCatalog.getConnections()) {
            StringBuffer in = null;
            for (ExtractConnectionAccess connAccess : connAccessCatalog.getExtractConnectionAccessCatalog()) {
                in = new StringBuffer();
                sep = "";
                if (connAccess.getConnection() != conn || !connAccess.isSchemaSpatial()) continue;
                toSchema = connAccess.getSchemaName();
                connUser = connAccess.getConnectionUser();
                String dbName = connAccess.getConnectionName();
                sourceTable = connAccess.isConnOwner() ? USER_SDO_GEOM_META : NON_USER_SDO_GEOM_META;
                BasicDBObject o = BasicDBObject.builder().connName(dbName).schema(isMaintain ? connAccess.getSchemaName() : this.getDestConnUser()).objectType("TABLE").objectName(sourceTable).build();
                ExtractObject spatialEO = new ExtractObject(o, this);
                for (ExtractObject eo : tableEOs) {
                    if (!isReplace && eo.isExistsDest() || eo.getSourceConn() != conn || !eo.getDBObject().getSchemaName().equals(connAccess.getSchemaName())) continue;
                    in.append(sep + "'" + eo.getDBObject().getObjectName() + "'");
                    sep = ", ";
                }
                if (in.length() <= 0) continue;
                spatialEO.setProperty("KEY_SPATIAL_SOURCE_TABLE", sourceTable);
                spatialEO.setProperty("KEY_SPATIAL_SOURCE_SCHEMA", toSchema);
                spatialEO.setProperty("SPATIAL_SOURCE_SCHEMA_WHERE", " AND OWNER = '" + toSchema + "'");
                if (connAccess.isConnOwner()) {
                    spatialEO.setProperty("KEY_SPATIAL_IS_SOURCE_CONN_OWNER", true);
                } else {
                    spatialEO.setProperty("KEY_SPATIAL_IS_SOURCE_CONN_OWNER", false);
                    spatialEO.setColumns("OWNER, TABLE_NAME, COLUMN_NAME, DIMINFO, SRID");
                }
                if (!isMaintain) {
                    toSchema = this._destConnUser;
                }
                spatialEO.getColumns();
                if (toSchema.equals(this.getDestConnUser())) {
                    spatialEO.setProperty("KEY_SPATIAL_IS_DEST_CONN_OWNER", true);
                    spatialEO.setProperty("KEY_SPATIAL_DEST_TABLE", USER_SDO_GEOM_META);
                    spatialEO.setProperty("KEY_SPATIAL_DEST_SCHEMA", "");
                    spatialEO.setProperty("SPATIAL_DEST_DELETE", "delete from MDSYS.USER_SDO_GEOM_METADATA where TABLE_NAME IN(" + in.toString() + ")");
                    spatialEO.setProperty("SPATIAL_DEST_INSERT", " insert into MDSYS.USER_SDO_GEOM_METADATA (TABLE_NAME, COLUMN_NAME, DIMINFO, SRID) ");
                    spatialEO.setColumns("TABLE_NAME, COLUMN_NAME, DIMINFO, SRID");
                } else {
                    spatialEO.setProperty("KEY_SPATIAL_IS_DEST_CONN_OWNER", false);
                    spatialEO.setProperty("KEY_SPATIAL_DEST_TABLE", NON_USER_SDO_GEOM_META);
                    spatialEO.setProperty("KEY_SPATIAL_DEST_SCHEMA", toSchema);
                    spatialEO.setProperty("SPATIAL_DEST_DELETE", "delete from MDSYS.SDO_GEOM_METADATA_TABLE where SDO_TABLE_NAME IN(" + in.toString() + ") AND SDO_OWNER = '" + toSchema + "'");
                    spatialEO.setProperty("SPATIAL_DEST_INSERT", " insert into MDSYS.SDO_GEOM_METADATA_TABLE (SDO_OWNER, SDO_TABLE_NAME, SDO_COLUMN_NAME, SDO_DIMINFO, SDO_SRID) ");
                    spatialEO.setColumns("OWNER, TABLE_NAME, COLUMN_NAME, DIMINFO, SRID");
                }
                spatialEO.setWhere("TABLE_NAME IN(" + in.toString() + ")");
                spatialMetaEOs.add(spatialEO);
            }
        }
        return spatialMetaEOs;
    }

    public boolean isExistsForType(ArrayList<URL> objectList, String type) {
        for (URL u : objectList) {
            if (u == null || !DBURLUtil.getParsedURL((URL)u).getObjectType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public void setSelectedExtractObjects(List<ExtractObject> eoList) {
        this._EOList = eoList;
    }

    public void setSelectExtractData(List<ExtractObject> eoList) {
        this.clearSelectExtractData();
        if (eoList == null) {
            return;
        }
        for (ExtractObject eo : eoList) {
            URL url = eo.getUrl();
            ExtractObject EO = this.getOrAddExtractObject(url);
            EO.isExistsSource(true);
            EO.isDataObject(true);
            EO.isSelectedData(true);
            EO.isExtractData(true);
            this._isSelectedData = true;
        }
        this.cleanupExtractObjects();
    }

    public void clearSelectExtractData() {
        for (ExtractObject EO : this._EOList) {
            EO.isSelectedData(false);
            EO.isExtractData(false);
        }
        this._isSelectedData = false;
    }

    public void setSelectExtractMetaData(List<URL> urlList) {
        this.clearSelectExtractMetaData();
        if (urlList == null) {
            return;
        }
        for (URL url : urlList) {
            ExtractObject EO = this.getOrAddExtractObject(url);
            EO.isExistsSource(true);
            EO.isSelectedMetaData(true);
            EO.isExtractMetaData(true);
            this._isSelectedMetaData = true;
        }
        this.cleanupExtractObjects();
    }

    public void clearSelectExtractMetaData() {
        for (ExtractObject EO : this._EOList) {
            EO.isSelectedMetaData(false);
            EO.isExtractMetaData(false);
        }
        this._isSelectedMetaData = false;
    }

    public void setSelectExtractBoth(List<URL> urlList) {
        this.clearSelectExtractBoth();
        if (urlList == null) {
            return;
        }
        for (URL url : urlList) {
            ExtractObject EO = this.getOrAddExtractObject(url);
            EO.isExistsSource(true);
            EO.isSelectedMetaData(true);
            EO.isExtractMetaData(true);
            this._isSelectedMetaData = true;
            if (!ExtractListModel.isDataObject(EO.getDBObject())) continue;
            EO.isSelectedData(true);
            EO.isExtractData(true);
            this._isSelectedData = true;
        }
        this.cleanupExtractObjects();
    }

    public void setSelectExtractBoth(ExtractObject EO) {
        if (EO == null) {
            return;
        }
        EO.isExistsSource(true);
        EO.isSelectedMetaData(true);
        EO.isExtractMetaData(true);
        this._isSelectedMetaData = true;
        if (ExtractListModel.isDataObject(EO.getDBObject())) {
            EO.isSelectedData(true);
            EO.isExtractData(true);
            this._isSelectedData = true;
        }
    }

    public void clearSelectExtractBoth() {
        for (ExtractObject EO : this._EOList) {
            EO.isSelectedMetaData(false);
            EO.isSelectedData(false);
            EO.isExtractData(false);
            EO.isExtractMetaData(false);
            this._isSelectedData = false;
            this._isSelectedMetaData = false;
        }
    }

    private void cleanupExtractObjects() {
        ExtractObject EO = null;
        for (int i = this._EOList.size() - 1; i >= 0; --i) {
            EO = this._EOList.get(i);
            if (EO.isSelectedMetaData() || !(!EO.isSelectedData() & !EO.isPreSelected())) continue;
            this._EOList.remove(EO);
        }
    }

    public ExtractObject getExtractObject(URL url) {
        for (ExtractObject EO : this._EOList) {
            if (!url.equals(EO.getUrl())) continue;
            return EO;
        }
        return null;
    }

    public ExtractObject getExtractObject(int type) {
        for (ExtractObject EO : this._EOList) {
            if (EO.getType() != type) continue;
            return EO;
        }
        return null;
    }

    public ExtractObject getExtractObject(List<ExtractObject> eoList, String schema, String type, String name) {
        for (ExtractObject EO : eoList) {
            BasicDBObject dbo = EO.getDBObject();
            if (!schema.equals(dbo.getSchemaName()) || !type.equals(dbo.getObjectType()) || !name.equals(dbo.getObjectName())) continue;
            return EO;
        }
        return null;
    }

    public ExtractObject getExtractObject(List<ExtractObject> eoList, String type, String name) {
        for (ExtractObject EO : eoList) {
            BasicDBObject dbo = EO.getDBObject();
            if (!type.equals(dbo.getObjectType()) || !name.equals(dbo.getObjectName())) continue;
            return EO;
        }
        return null;
    }

    public ExtractObject getExtractObject(BasicDBObject dbo) {
        URL url = dbo.getURL();
        for (ExtractObject EO : this._EOList) {
            if (!url.equals(EO.getUrl())) continue;
            return EO;
        }
        return null;
    }

    public ExtractObject getFirstDataObject() {
        for (ExtractObject EO : this._EOList) {
            if (!EO.isDataObject() && EO.getType() != 1 && !EO.isTypeDataFile()) continue;
            return EO;
        }
        return null;
    }

    public ExtractObject getFirstExtractObject() {
        Iterator<ExtractObject> iterator = this._EOList.iterator();
        if (iterator.hasNext()) {
            ExtractObject EO = iterator.next();
            return EO;
        }
        return null;
    }

    public BasicDBObject getDBObject(URL u) {
        if (this._EOList != null) {
            for (ExtractObject EO : this._EOList) {
                BasicDBObject dbo = EO.getDBObject();
                if (dbo == null || !dbo.getURL().equals(u)) continue;
                return dbo;
            }
        }
        return null;
    }

    public String getGlobalWhere() {
        return this._globalWhere;
    }

    public void setGlobalWhere(String value) {
        int whereIdx = value.trim().toLowerCase().indexOf("where");
        this._globalWhere = whereIdx != 0 ? value : value.substring(whereIdx + 6);
    }

    public Object getPropertyValue(String propertyKey) {
        return this._extendedProperties.get(propertyKey);
    }

    public void setProperty(String propertyKey, Object propertyValue) {
        this._extendedProperties.put(propertyKey, propertyValue);
    }

    public Set<String> getPropertyKeySet() {
        return this._extendedProperties.keySet();
    }

    public void finish() {
    }

    public boolean isTypeDBO() {
        return this._dataObjectType == 0;
    }

    public boolean isTypeQuery() {
        return this._dataObjectType == 1;
    }

    public boolean isAllowLobs() {
        return this._isAllowLobs;
    }

    public void isAllowLobs(boolean value) {
        if (!this._isAllowLobs == value) {
            for (ExtractObject EO : this._EOList) {
                EO.isDataPrepared(false);
            }
        }
        this._isAllowLobs = value;
    }

    public void isAllowVirtual(boolean value) {
        if (!this._isAllowVirtual == value) {
            for (ExtractObject EO : this._EOList) {
                EO.isDataPrepared(false);
            }
        }
        this._isAllowVirtual = value;
    }

    public boolean isPreSelected() {
        return this._isPreSelected;
    }

    public boolean isPreSelectedDataExtractable() {
        return this._isPreSelectedDataExtractable;
    }

    public boolean isSelectedMetaData() {
        return this._isSelectedMetaData;
    }

    public boolean isSelectedData() {
        return this._isSelectedData;
    }

    public boolean isSourceConnOracle() {
        return this._isSourceConnOracle;
    }

    public boolean isSourceConnTimesTen() {
        return this._isSourceConnTimesTen;
    }

    private void setSourceConnectionProperties(String connName) {
        this._sourceConnName = connName;
        this._sourceConnUser = "";
        try {
            this._isSourceConnOracle = ConnectionResolver.isOracle((Connection)ConnectionResolver.getConnection((String)connName));
            this._isSourceConnTimesTen = ConnectionResolver.isTimesTen((Connection)ConnectionResolver.getConnection((String)connName));
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), (Throwable)e);
        }
    }

    public String getConnectionUser(String connName) {
        try {
            return ExtractConnectionAccess.getConnUser(ConnectionResolver.getConnection((String)connName));
        }
        catch (Exception e) {
            Logger.warn(ExtractListModel.class, (Throwable)e);
            return "";
        }
    }

    private void setDestConnectionProperties(String connName) {
        this._destConnName = connName;
        this._destConnUser = "";
        try {
            this._destConn = ConnectionResolver.getConnection((String)connName);
        }
        catch (Exception e) {
            Logger.warn(this.getClass(), (Throwable)e);
        }
        this._destConnUser = "";
        this._isDestConnOracle = ConnectionResolver.isOracle((Connection)this._destConn);
        this._isDestConnTimesTen = ConnectionResolver.isTimesTen((Connection)this._destConn);
    }

    public List<ExtractObject> getCreateProcessList(int listType, int[] opt) {
        return this.getCreateProcessList(this.getList(0, opt), listType);
    }

    public List<ExtractObject> getCreateProcessList(List<ExtractObject> eoList, int listType) {
        ArrayList<ExtractObject> rtnList = new ArrayList<ExtractObject>();
        List<String> types = this._ddlTypes.getTypes(listType);
        for (String key : types) {
            ArrayList typeObjects = (ArrayList)this.getListForType(eoList, key);
            for (ExtractObject eo : typeObjects) {
                rtnList.add(eo);
            }
        }
        return rtnList;
    }

    private List<URL> getListURL(List<ExtractObject> EOList) {
        ArrayList<URL> dataList = new ArrayList<URL>();
        if (EOList != null && !EOList.isEmpty()) {
            for (ExtractObject EO : EOList) {
                BasicDBObject DBO = EO.getDBObject();
                URL u = DBO.getURL();
                dataList.add(u);
            }
        }
        return dataList;
    }

    private void initForDBObjects(BasicDBObject dbo) {
        this.initForDBObjects();
        this.setSourceConnectionProperties(dbo.getConnectionName());
        this.addExtractObjectPreSelected(dbo);
    }

    private void initForDBObjects(BasicDBObject[] dbos) {
        this.initForDBObjects();
        this.setSourceConnectionProperties(dbos[0].getConnectionName());
        for (BasicDBObject dbo : dbos) {
            this.addExtractObjectPreSelected(dbo);
        }
    }

    private void initForDBObjects(List<BasicDBObject> DBObjectList) {
        this.initForDBObjects();
        this.setSourceConnectionProperties(DBObjectList.get(0).getConnectionName());
        for (BasicDBObject dbo : DBObjectList) {
            this.addExtractObjectPreSelected(dbo);
        }
    }

    private void initForDBObjects() {
        this._dataObjectType = 0;
        this._isPreSelected = true;
    }

    public ExtractObject getOrAddExtractObject(BasicDBObject dbo, int[] options) {
        ExtractObject EO = this.getOrAddExtractObject(dbo);
        block7: for (int option : options) {
            switch (option) {
                case 100: {
                    EO.isExtractMetaData(true);
                    continue block7;
                }
                case 101: {
                    EO.isExtractData(true);
                    continue block7;
                }
                case 102: {
                    EO.isDataObject(true);
                    continue block7;
                }
                case 103: {
                    EO.isExistsSource(true);
                    continue block7;
                }
                case 104: {
                    EO.isExistsDest(true);
                }
            }
        }
        return EO;
    }

    private void addExtractObjectPreSelected(BasicDBObject dbo) {
        ExtractObject EO = this.getOrAddExtractObject(dbo);
        if (ExtractListModel.isDataObject(dbo)) {
            this._isPreSelectedDataExtractable = true;
            this._isSelectedData = true;
            EO.isDataObject(true);
            EO.isExtractData(true);
            EO.isSelectedData(true);
        }
        EO.isExistsSource(true);
        EO.isPreSelected(true);
        EO.isExtractMetaData(true);
        EO.isSelectedMetaData(true);
        this._isSelectedMetaData = true;
    }

    public ExtractObject getOrAddExtractObject(BasicDBObject dbo) {
        URL url = dbo.getURL();
        ExtractObject EO = this.getExtractObject(url);
        if (EO == null) {
            EO = this.addExtractObject(dbo);
        }
        return EO;
    }

    public ExtractObject getOrAddExtractObject(URL url) {
        ExtractObject EO = this.getExtractObject(url);
        if (EO == null) {
            EO = this.addExtractObject(url);
        }
        return EO;
    }

    public ExtractObject getOrAddExtractObject(int type) {
        ExtractObject EO = this.getExtractObject(type);
        if (EO == null) {
            EO = this.addExtractObject(type);
        }
        return EO;
    }

    private ExtractObject addExtractObject(BasicDBObject dbo) {
        ExtractObject EO = new ExtractObject(dbo, this);
        this._EOList.add(EO);
        return EO;
    }

    private ExtractObject addExtractObject(URL url) {
        ExtractObject EO = new ExtractObject(url, this);
        this._EOList.add(EO);
        return EO;
    }

    private ExtractObject addExtractObject(int type) {
        ExtractObject EO = new ExtractObject(type, this);
        this._EOList.add(EO);
        return EO;
    }

    public boolean removeExtractObject(ExtractObject eo) {
        return this._EOList.remove(eo);
    }

    public static boolean isDataObject(BasicDBObject dbo) {
        if (dbo == null) {
            return false;
        }
        return "TABLE".equals(dbo.getObjectType()) || "VIEW".equals(dbo.getObjectType()) || "MATERIALIZED VIEW".equals(dbo.getObjectType());
    }

    public static boolean isDataFolder(BasicDBObject dbo) {
        if (dbo == null) {
            return false;
        }
        String type = dbo.getObjectFolderType();
        return type.equals("TABLE") || type.equals("VIEW") || type.equals("MATERIALIZED VIEW");
    }

    public boolean isDestConnOracle() {
        return this._isDestConnOracle;
    }

    public boolean isDestConnTimesTen() {
        return this._isDestConnTimesTen;
    }
}

