/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasetools.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.databasetools.model.DatabaseToolsConnectionSummary;
import com.oracle.bmc.databasetools.model.DatabaseToolsKeyStoreGenericJdbcSummary;
import com.oracle.bmc.databasetools.model.DatabaseToolsUserPasswordSummary;
import com.oracle.bmc.databasetools.model.LifecycleState;
import com.oracle.bmc.databasetools.model.ResourceLock;
import com.oracle.bmc.databasetools.model.RuntimeSupport;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class DatabaseToolsConnectionGenericJdbcSummary
extends DatabaseToolsConnectionSummary {
    @JsonProperty(value="url")
    private final String url;
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="userPassword")
    private final DatabaseToolsUserPasswordSummary userPassword;
    @JsonProperty(value="advancedProperties")
    private final Map<String, String> advancedProperties;
    @JsonProperty(value="keyStores")
    private final List<DatabaseToolsKeyStoreGenericJdbcSummary> keyStores;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DatabaseToolsConnectionGenericJdbcSummary(String id, String displayName, String compartmentId, LifecycleState lifecycleState, String lifecycleDetails, Date timeCreated, Date timeUpdated, Map<String, Map<String, Object>> definedTags, Map<String, String> freeformTags, Map<String, Map<String, Object>> systemTags, List<ResourceLock> locks, RuntimeSupport runtimeSupport, String url, String userName, DatabaseToolsUserPasswordSummary userPassword, Map<String, String> advancedProperties, List<DatabaseToolsKeyStoreGenericJdbcSummary> keyStores) {
        super(id, displayName, compartmentId, lifecycleState, lifecycleDetails, timeCreated, timeUpdated, definedTags, freeformTags, systemTags, locks, runtimeSupport);
        this.url = url;
        this.userName = userName;
        this.userPassword = userPassword;
        this.advancedProperties = advancedProperties;
        this.keyStores = keyStores;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public DatabaseToolsUserPasswordSummary getUserPassword() {
        return this.userPassword;
    }

    public Map<String, String> getAdvancedProperties() {
        return this.advancedProperties;
    }

    public List<DatabaseToolsKeyStoreGenericJdbcSummary> getKeyStores() {
        return this.keyStores;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatabaseToolsConnectionGenericJdbcSummary(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", url=").append(String.valueOf(this.url));
        sb.append(", userName=").append(String.valueOf(this.userName));
        sb.append(", userPassword=").append(String.valueOf((Object)this.userPassword));
        sb.append(", advancedProperties=").append(String.valueOf(this.advancedProperties));
        sb.append(", keyStores=").append(String.valueOf(this.keyStores));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatabaseToolsConnectionGenericJdbcSummary)) {
            return false;
        }
        DatabaseToolsConnectionGenericJdbcSummary other = (DatabaseToolsConnectionGenericJdbcSummary)((Object)o);
        return Objects.equals(this.url, other.url) && Objects.equals(this.userName, other.userName) && Objects.equals((Object)this.userPassword, (Object)other.userPassword) && Objects.equals(this.advancedProperties, other.advancedProperties) && Objects.equals(this.keyStores, other.keyStores) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.url == null ? 43 : this.url.hashCode());
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.userPassword == null ? 43 : this.userPassword.hashCode());
        result = result * 59 + (this.advancedProperties == null ? 43 : this.advancedProperties.hashCode());
        result = result * 59 + (this.keyStores == null ? 43 : this.keyStores.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="locks")
        private List<ResourceLock> locks;
        @JsonProperty(value="runtimeSupport")
        private RuntimeSupport runtimeSupport;
        @JsonProperty(value="url")
        private String url;
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="userPassword")
        private DatabaseToolsUserPasswordSummary userPassword;
        @JsonProperty(value="advancedProperties")
        private Map<String, String> advancedProperties;
        @JsonProperty(value="keyStores")
        private List<DatabaseToolsKeyStoreGenericJdbcSummary> keyStores;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder locks(List<ResourceLock> locks) {
            this.locks = locks;
            this.__explicitlySet__.add("locks");
            return this;
        }

        public Builder runtimeSupport(RuntimeSupport runtimeSupport) {
            this.runtimeSupport = runtimeSupport;
            this.__explicitlySet__.add("runtimeSupport");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.__explicitlySet__.add("url");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder userPassword(DatabaseToolsUserPasswordSummary userPassword) {
            this.userPassword = userPassword;
            this.__explicitlySet__.add("userPassword");
            return this;
        }

        public Builder advancedProperties(Map<String, String> advancedProperties) {
            this.advancedProperties = advancedProperties;
            this.__explicitlySet__.add("advancedProperties");
            return this;
        }

        public Builder keyStores(List<DatabaseToolsKeyStoreGenericJdbcSummary> keyStores) {
            this.keyStores = keyStores;
            this.__explicitlySet__.add("keyStores");
            return this;
        }

        public DatabaseToolsConnectionGenericJdbcSummary build() {
            DatabaseToolsConnectionGenericJdbcSummary model = new DatabaseToolsConnectionGenericJdbcSummary(this.id, this.displayName, this.compartmentId, this.lifecycleState, this.lifecycleDetails, this.timeCreated, this.timeUpdated, this.definedTags, this.freeformTags, this.systemTags, this.locks, this.runtimeSupport, this.url, this.userName, this.userPassword, this.advancedProperties, this.keyStores);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatabaseToolsConnectionGenericJdbcSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("locks")) {
                this.locks(model.getLocks());
            }
            if (model.wasPropertyExplicitlySet("runtimeSupport")) {
                this.runtimeSupport(model.getRuntimeSupport());
            }
            if (model.wasPropertyExplicitlySet("url")) {
                this.url(model.getUrl());
            }
            if (model.wasPropertyExplicitlySet("userName")) {
                this.userName(model.getUserName());
            }
            if (model.wasPropertyExplicitlySet("userPassword")) {
                this.userPassword(model.getUserPassword());
            }
            if (model.wasPropertyExplicitlySet("advancedProperties")) {
                this.advancedProperties(model.getAdvancedProperties());
            }
            if (model.wasPropertyExplicitlySet("keyStores")) {
                this.keyStores(model.getKeyStores());
            }
            return this;
        }
    }
}

