/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import oracle.xml.jdwp.LineTable;
import oracle.xml.jdwp.XSLJDWPBreakpointEvent;
import oracle.xml.jdwp.XSLJDWPClassMatchEventRequest;
import oracle.xml.jdwp.XSLJDWPClassPrepareEvent;
import oracle.xml.jdwp.XSLJDWPDebugger;
import oracle.xml.jdwp.XSLJDWPEvent;
import oracle.xml.jdwp.XSLJDWPEventRequest;
import oracle.xml.jdwp.XSLJDWPEventRequestGroup;
import oracle.xml.jdwp.XSLJDWPEventRequestManager;
import oracle.xml.jdwp.XSLJDWPEventValue;
import oracle.xml.jdwp.XSLJDWPEventValue4ContextNode;
import oracle.xml.jdwp.XSLJDWPEvents;
import oracle.xml.jdwp.XSLJDWPLocation;
import oracle.xml.jdwp.XSLJDWPLocationOnlyEventRequest;
import oracle.xml.jdwp.XSLJDWPMethod;
import oracle.xml.jdwp.XSLJDWPMethodEntryEvent;
import oracle.xml.jdwp.XSLJDWPMethodExitEvent;
import oracle.xml.jdwp.XSLJDWPSingleStepEvent;
import oracle.xml.jdwp.XSLJDWPStepEventRequest;
import oracle.xml.jdwp.XSLJDWPUtil;
import oracle.xml.jdwp.XSLJDWPVMDeathEvent;
import oracle.xml.jdwp.XSLJDWPVMStartEvent;
import oracle.xml.jdwp.XSLJDWPVirtualMachine;
import oracle.xml.util.NSName;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.XSLStylesheet;

public class XSLJDWPEventManager {
    private static final int IS_CALL_TEMPLATE = 1;
    private static final int IS_APPLY_TEMPLATES = 2;
    private static final int IS_NONE_TEMPLATE = 3;
    private static final int IS_APPLY_IMPORTS = 4;
    private XSLJDWPEvents events;
    private XSLJDWPLocation currentlocation;
    private boolean reportnextsinglestepevent = false;
    private int currentRequestID;
    private LinkedList haltpoints = new LinkedList();
    private long methodendpoint = -1L;
    private boolean removeframe = false;
    private XSLJDWPEventValue ev;
    private boolean hitxmlbk = false;

    public XSLJDWPEventManager(XSLStylesheet xSLStylesheet) {
        this.events = new XSLJDWPEvents(xSLStylesheet);
    }

    synchronized void addSourceNode(XSLJDWPEventValue4ContextNode xSLJDWPEventValue4ContextNode) {
        XSLJDWPLocation xSLJDWPLocation = this.calculateSourceNodeLocation(xSLJDWPEventValue4ContextNode);
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue4ContextNode.getXSLStylesheet();
        int n = xSLJDWPLocation.getClassID();
        if (!xSLStylesheet.getJDWPVirtualMachine().getXMLSourceClassIDs().contains(new Integer(n))) {
            return;
        }
        XSLJDWPEvent xSLJDWPEvent = this.reportBreakpointEvent(xSLJDWPEventValue4ContextNode, xSLJDWPLocation);
        if (xSLJDWPEvent != null) {
            this.events.add(xSLJDWPEvent);
            this.events.setCompositeDone();
            this.addFrame(xSLJDWPEventValue4ContextNode, xSLJDWPLocation);
            this.events.add();
            xSLStylesheet.suspendDebugger(true);
            this.hitxmlbk = true;
            while (xSLStylesheet.waitMode()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.events.reset();
            this.reportSingleStepEvent(this.ev);
        }
    }

    synchronized void addEventValue(XSLJDWPEventValue xSLJDWPEventValue) {
        boolean bl;
        XSLJDWPLocation xSLJDWPLocation;
        this.ev = xSLJDWPEventValue;
        this.currentlocation = xSLJDWPLocation = this.calculateGeneralLocation(xSLJDWPEventValue);
        XSLJDWPEvent xSLJDWPEvent = this.reportEvent(xSLJDWPEventValue);
        if (xSLJDWPEvent != null) {
            this.events.add(xSLJDWPEvent);
        }
        if (xSLJDWPEvent != null && (xSLJDWPEvent.getEventKind() == 90 || xSLJDWPEvent.getEventKind() == 99 || xSLJDWPEvent.getEventKind() == 6 || xSLJDWPEvent.getEventKind() == 7)) {
            this.events.add();
            return;
        }
        xSLJDWPEvent = this.reportClassPrepareEvent(xSLJDWPEventValue);
        if (xSLJDWPEvent != null) {
            this.events.add(xSLJDWPEvent);
            this.events.add();
            this.halt(xSLJDWPEventValue, xSLJDWPLocation);
            this.events.reset();
        }
        if ((xSLJDWPEvent = this.reportBreakpointEvent(xSLJDWPEventValue, xSLJDWPLocation)) != null) {
            this.events.add(xSLJDWPEvent);
        }
        if (this.reportnextsinglestepevent && ((bl = this.isStartCodeIndex(xSLJDWPEventValue, xSLJDWPLocation)) || this.hitxmlbk)) {
            xSLJDWPEvent = new XSLJDWPSingleStepEvent(this.currentRequestID, xSLJDWPLocation);
            this.events.add(xSLJDWPEvent);
            this.reportnextsinglestepevent = false;
            this.hitxmlbk = false;
        }
        this.events.setCompositeDone();
        this.events.add();
        this.halt(xSLJDWPEventValue, xSLJDWPLocation);
        if (this.removeframe) {
            this.removeFrame(xSLJDWPEventValue, xSLJDWPLocation);
        }
        this.events.reset();
        this.reportSingleStepEvent(xSLJDWPEventValue);
        if (xSLJDWPEventValue.getCodeIndex() == this.methodendpoint) {
            this.reportnextsinglestepevent = true;
            this.methodendpoint = -1L;
        }
    }

    private void removeFrame(XSLJDWPEventValue xSLJDWPEventValue, XSLJDWPLocation xSLJDWPLocation) {
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue.getXSLStylesheet();
        if (xSLStylesheet.getFrames().size() > 0) {
            xSLStylesheet.getFrames().removeLast();
        }
        if (xSLStylesheet.getFrameValues().size() > 0) {
            xSLStylesheet.getFrameValues().removeLast();
        }
        if (xSLStylesheet.getFrameParams().size() > 0) {
            xSLStylesheet.getFrameParams().removeLast();
        }
        XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "Frame removed :" + xSLJDWPLocation.getClassID() + ":" + xSLJDWPLocation.getMethodID() + ":" + xSLJDWPLocation.getIndex());
    }

    private void addFrame(XSLJDWPEventValue4ContextNode xSLJDWPEventValue4ContextNode, XSLJDWPLocation xSLJDWPLocation) {
        XSLJDWPLocation xSLJDWPLocation2;
        int n;
        int n2;
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue4ContextNode.getXSLStylesheet();
        XSLJDWPVirtualMachine xSLJDWPVirtualMachine = xSLStylesheet.getJDWPVirtualMachine();
        Vector vector = xSLJDWPVirtualMachine.getXMLSourceClassIDs();
        LinkedList linkedList = xSLStylesheet.getFrames();
        int n3 = -1;
        for (n3 = linkedList.size() - 1; n3 >= 0 && (n2 = vector.indexOf(new Integer(n = (xSLJDWPLocation2 = (XSLJDWPLocation)linkedList.get(n3)).getClassID()))) == -1; --n3) {
        }
        if (n3 != -1) {
            this.remove3frames(xSLStylesheet, n3);
        }
        this.add3frames(xSLStylesheet, xSLJDWPLocation);
    }

    private void remove3frames(XSLStylesheet xSLStylesheet, int n) {
        xSLStylesheet.getFrames().remove(n);
        xSLStylesheet.getFrameValues().remove(n);
        xSLStylesheet.getFrameParams().remove(n);
    }

    private void add3frames(XSLStylesheet xSLStylesheet, XSLJDWPLocation xSLJDWPLocation) {
        xSLStylesheet.getFrames().add(xSLJDWPLocation);
        xSLStylesheet.getFrameValues().add(new LinkedList());
        xSLStylesheet.getFrameParams().add(new Integer(1));
    }

    private void addFrame(XSLJDWPEventValue xSLJDWPEventValue, XSLJDWPLocation xSLJDWPLocation, byte by) {
        if (xSLJDWPLocation.getClassID() <= 0 || xSLJDWPLocation.getMethodID() <= 0) {
            return;
        }
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue.getXSLStylesheet();
        LinkedList linkedList = xSLStylesheet.getFrames();
        switch (by) {
            case 10: {
                this.add3frames(xSLStylesheet, xSLJDWPLocation);
                break;
            }
            case 40: {
                if (linkedList.getLast() == null) {
                    linkedList.set(linkedList.size() - 1, xSLJDWPLocation);
                    break;
                }
                this.add3frames(xSLStylesheet, xSLJDWPLocation);
                break;
            }
        }
        int n = xSLStylesheet.getFrameValues().size() - 1;
        XPathSequence xPathSequence = new XPathSequence(xSLJDWPEventValue.getXSLTContext());
        try {
            XPathSequence.setStringValue(xPathSequence, xSLJDWPEventValue.getName());
        }
        catch (XQException xQException) {
            // empty catch block
        }
        LinkedList linkedList2 = (LinkedList)xSLStylesheet.getFrameValues().get(n);
        linkedList2.add(0, xPathSequence);
        XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "Frame added :" + xSLJDWPLocation.getClassID() + ":" + xSLJDWPLocation.getMethodID() + ":" + xSLJDWPLocation.getIndex());
    }

    private void updateFrameLocation(XSLStylesheet xSLStylesheet) {
        if (xSLStylesheet == null || xSLStylesheet.getFrames() == null || xSLStylesheet.getFrames().size() == 0) {
            return;
        }
        if (this.currentlocation == null || this.currentlocation.getClassID() <= 0 || this.currentlocation.getMethodID() <= 0 || this.currentlocation.getIndex() <= 0L || this.currentlocation.getLine() <= 0) {
            return;
        }
        XSLJDWPVirtualMachine xSLJDWPVirtualMachine = xSLStylesheet.getJDWPVirtualMachine();
        Vector vector = xSLJDWPVirtualMachine.getXMLSourceClassIDs();
        int n = this.currentlocation.getClassID();
        int n2 = vector.indexOf(new Integer(n));
        LinkedList linkedList = xSLStylesheet.getFrames();
        if (n2 != -1) {
            XSLJDWPLocation xSLJDWPLocation;
            int n3;
            int n4;
            int n5 = -1;
            for (n5 = linkedList.size() - 1; n5 >= 0 && (n4 = vector.indexOf(new Integer(n3 = (xSLJDWPLocation = (XSLJDWPLocation)linkedList.get(n5)).getClassID()))) == -1; --n5) {
            }
            if (n5 != -1) {
                this.remove3frames(xSLStylesheet, n5);
            }
            this.add3frames(xSLStylesheet, this.currentlocation);
        } else {
            XSLJDWPLocation xSLJDWPLocation;
            int n6 = -1;
            for (n6 = linkedList.size() - 1; !(n6 < 0 || (xSLJDWPLocation = (XSLJDWPLocation)linkedList.get(n6)) != null && this.inSameLine(xSLJDWPLocation, this.currentlocation)); --n6) {
            }
            if (n6 != -1) {
                for (int i = linkedList.size() - 1; i >= 0; --i) {
                    int n7;
                    int n8;
                    XSLJDWPLocation xSLJDWPLocation2 = (XSLJDWPLocation)linkedList.get(i);
                    if (xSLJDWPLocation2 == null || (n8 = vector.indexOf(new Integer(n7 = xSLJDWPLocation2.getClassID()))) == -1) continue;
                    this.remove3frames(xSLStylesheet, i);
                    break;
                }
                linkedList.set(n6, this.currentlocation);
            } else {
                xSLJDWPLocation = (XSLJDWPLocation)xSLStylesheet.getFrames().getLast();
                if (xSLJDWPLocation != null) {
                    xSLJDWPLocation.setClassID(this.currentlocation.getClassID());
                    xSLJDWPLocation.setMethodID(this.currentlocation.getMethodID());
                    xSLJDWPLocation.setIndex(this.currentlocation.getIndex());
                    xSLJDWPLocation.setLine(this.currentlocation.getLine());
                }
            }
        }
    }

    private boolean inSameLine(XSLJDWPLocation xSLJDWPLocation, XSLJDWPLocation xSLJDWPLocation2) {
        if (xSLJDWPLocation.getClassID() != xSLJDWPLocation2.getClassID()) {
            return false;
        }
        if (xSLJDWPLocation.getMethodID() != xSLJDWPLocation2.getMethodID()) {
            return false;
        }
        return xSLJDWPLocation.getLine() == xSLJDWPLocation2.getLine();
    }

    private boolean isStartCodeIndex(XSLJDWPEventValue xSLJDWPEventValue, XSLJDWPLocation xSLJDWPLocation) {
        int n;
        int n2 = xSLJDWPLocation.getClassID();
        if (n2 < 1) {
            return false;
        }
        int n3 = xSLJDWPLocation.getMethodID();
        if (n3 < 0) {
            return false;
        }
        long l = xSLJDWPEventValue.getCodeIndex();
        if (l < 1L) {
            return false;
        }
        LineTable lineTable = xSLJDWPEventValue.getXSLStylesheet().getJDWPMethod().getLineTable(n2, n3);
        long[] lArray = lineTable.getLineCodeIndex();
        for (n = 0; n < lineTable.getLines() && lArray[n] < l; ++n) {
        }
        return n < lineTable.getLines() && lArray[n] == l;
    }

    private XSLJDWPLocation calculateGeneralLocation(XSLJDWPEventValue xSLJDWPEventValue) {
        int n = this.getClassID(xSLJDWPEventValue);
        XSLJDWPMethod xSLJDWPMethod = xSLJDWPEventValue.getXSLStylesheet().getJDWPMethod();
        long l = xSLJDWPEventValue.getCodeIndex();
        int n2 = this.getMethodIDFromLineTable(n, l, xSLJDWPMethod);
        XSLJDWPLocation xSLJDWPLocation = new XSLJDWPLocation(1, n, n2, l);
        xSLJDWPLocation.setLine(xSLJDWPEventValue.getLineNumber());
        return xSLJDWPLocation;
    }

    private XSLJDWPLocation calculateSourceNodeLocation(XSLJDWPEventValue4ContextNode xSLJDWPEventValue4ContextNode) {
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue4ContextNode.getXSLStylesheet();
        String string = xSLJDWPEventValue4ContextNode.getBaseURL();
        int n = xSLStylesheet.getJDWPVirtualMachine().getClassID(string);
        long l = xSLJDWPEventValue4ContextNode.getLineNumber();
        int n2 = 1;
        return new XSLJDWPLocation(1, n, n2, l);
    }

    private void halt(XSLJDWPEventValue xSLJDWPEventValue, XSLJDWPLocation xSLJDWPLocation) {
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue.getXSLStylesheet();
        int n = this.events.getEvents();
        if (n == 0) {
            Object object;
            int n2;
            int n3 = this.haltpoints.size();
            if (n3 == 0) {
                return;
            }
            long l = xSLJDWPEventValue.getCodeIndex();
            for (n2 = 0; n2 < n3 && (Long)(object = (Long)this.haltpoints.get(n2)) != l; ++n2) {
            }
            if (n2 < n3) {
                this.haltpoints.remove(n2);
                object = new XSLJDWPSingleStepEvent(this.currentRequestID, xSLJDWPLocation);
                this.events.add((XSLJDWPEvent)object);
                this.events.add();
                this.halt(xSLJDWPEventValue, xSLJDWPLocation);
                this.events.reset();
                this.reportSingleStepEvent(xSLJDWPEventValue);
            }
        } else if (n == 1) {
            XSLJDWPEvent xSLJDWPEvent = this.events.getEvent(0);
            byte by = xSLJDWPEvent.getEventKind();
            switch (by) {
                case 8: {
                    XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "Class Prepare Event");
                    xSLStylesheet.suspendDebugger(true);
                    break;
                }
                case 1: {
                    XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "Single Step Event");
                    xSLStylesheet.suspendDebugger(true);
                    break;
                }
                case 2: {
                    XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "Breakpoint Event");
                    xSLStylesheet.suspendDebugger(true);
                    break;
                }
                case 40: {
                    xSLStylesheet.suspendDebugger(true);
                    XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "Method Entry Event");
                    break;
                }
                case 41: {
                    xSLStylesheet.suspendDebugger(true);
                    XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "Method Exit Event");
                    break;
                }
            }
        } else {
            xSLStylesheet.suspendDebugger(true);
            XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "Group Events");
        }
        XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "stopped & waiting ...");
        while (xSLStylesheet.waitMode()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void addHaltPoint(long l) {
        Long l2 = new Long(l);
        if (this.haltpoints.contains(l2)) {
            return;
        }
        this.haltpoints.add(l2);
    }

    private XSLJDWPEvent reportSingleStepEvent(XSLJDWPEventValue xSLJDWPEventValue) {
        long l = xSLJDWPEventValue.getCodeIndex();
        if (l == 0L) {
            return null;
        }
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue.getXSLStylesheet();
        ArrayList<NSName> arrayList = xSLStylesheet.getUserDefinedFunctions();
        XSLJDWPDebugger xSLJDWPDebugger = xSLStylesheet.getJDWPDebugger();
        int n = this.getClassID(xSLJDWPEventValue);
        XSLJDWPMethod xSLJDWPMethod = xSLStylesheet.getJDWPMethod();
        int n2 = this.getMethodIDFromLineTable(n, l, xSLJDWPMethod);
        XSLJDWPEventRequestManager xSLJDWPEventRequestManager = xSLJDWPDebugger.getEventRequestManager();
        int n3 = xSLJDWPEventRequestManager.size();
        for (int i = 0; i < n3; ++i) {
            XSLJDWPEventRequestGroup xSLJDWPEventRequestGroup = (XSLJDWPEventRequestGroup)xSLJDWPEventRequestManager.get(i);
            if (xSLJDWPEventRequestGroup.getEventKind() != 1) continue;
            XSLJDWPEventRequest[] xSLJDWPEventRequestArray = xSLJDWPEventRequestGroup.getXSLJDWPEventRequests();
            int n4 = xSLJDWPEventRequestGroup.getModifiers();
            for (int j = 0; j < n4; ++j) {
                XSLJDWPEventRequest xSLJDWPEventRequest = xSLJDWPEventRequestArray[j];
                if (xSLJDWPEventRequest == null || xSLJDWPEventRequest.getModKind() != 10) continue;
                Object var18_17 = null;
                int n5 = ((XSLJDWPStepEventRequest)xSLJDWPEventRequest).getDepth();
                if (n5 == 2) {
                    this.reportnextsinglestepevent = false;
                    this.methodendpoint = this.calculateEndOfMethodLocation(n, n2, xSLJDWPMethod);
                } else {
                    String string = xSLJDWPEventValue.getConcatedAttrs();
                    int n6 = this.getStatementType(xSLJDWPEventValue);
                    if (this.isUserDefinedFunction(arrayList, string)) {
                        n6 = 1;
                    }
                    block0 : switch (n6) {
                        case 2: 
                        case 3: {
                            this.reportnextsinglestepevent = true;
                            break;
                        }
                        case 1: 
                        case 4: {
                            switch (n5) {
                                case 0: {
                                    this.reportnextsinglestepevent = true;
                                    break block0;
                                }
                                case 1: {
                                    this.calculateStepOverLocation(n, n2, l, xSLJDWPMethod);
                                }
                            }
                        }
                    }
                }
                this.currentRequestID = xSLJDWPEventRequestGroup.getRequestID();
                xSLJDWPEventRequestManager.remove(xSLJDWPEventRequestGroup);
                return null;
            }
        }
        return null;
    }

    private boolean isUserDefinedFunction(ArrayList<NSName> arrayList, String string) {
        if (arrayList == null || string == null) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            int n2;
            NSName nSName = arrayList.get(i);
            String string2 = nSName.getPrefix();
            String string3 = nSName.getLocalName();
            if (string2 != null && string2.length() > 0) {
                string3 = string2 + ":" + string3;
            }
            if ((n2 = string.indexOf(string3)) == -1 || n2 != 0 && string.charAt(n2 - 1) != ' ' || string.charAt(n = n2 + string3.length()) != '(') continue;
            return true;
        }
        return false;
    }

    private long calculateEndOfMethodLocation(int n, int n2, XSLJDWPMethod xSLJDWPMethod) {
        LineTable lineTable = xSLJDWPMethod.getLineTable(n, n2);
        if (lineTable == null) {
            this.methodendpoint = -1L;
            this.reportnextsinglestepevent = true;
            return this.methodendpoint;
        }
        long[] lArray = lineTable.getLineCodeIndex();
        return lArray[lineTable.getLines() - 1];
    }

    private void calculateStepOverLocation(int n, int n2, long l, XSLJDWPMethod xSLJDWPMethod) {
        LineTable lineTable = xSLJDWPMethod.getLineTable(n, n2);
        long[] lArray = lineTable.getLineCodeIndex();
        int n3 = 0;
        while (lArray[n3] != l) {
            ++n3;
        }
        if (n3 + 1 < lArray.length) {
            this.addHaltPoint(lArray[n3 + 1]);
        } else {
            this.reportnextsinglestepevent = true;
        }
    }

    private int getStatementType(XSLJDWPEventValue xSLJDWPEventValue) {
        String string = xSLJDWPEventValue.getInstructionName().intern();
        if (string == "xsl:apply-templates") {
            return 2;
        }
        if (string == "xsl:apply-imports") {
            return 4;
        }
        if (string == "xsl:call-template") {
            return 1;
        }
        return 3;
    }

    private int getMethodIDFromLineTable(int n, long l, XSLJDWPMethod xSLJDWPMethod) {
        int n2 = 2;
        LineTable lineTable = xSLJDWPMethod.getLineTable(n, n2);
        while (lineTable != null) {
            long l2 = lineTable.getStart();
            long l3 = lineTable.getEnd();
            if (l >= l2 && l <= l3) {
                return n2;
            }
            lineTable = xSLJDWPMethod.getLineTable(n, ++n2);
        }
        return 1;
    }

    private XSLJDWPEvent reportClassPrepareEvent(XSLJDWPEventValue xSLJDWPEventValue) {
        XSLJDWPClassPrepareEvent xSLJDWPClassPrepareEvent = null;
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue.getXSLStylesheet();
        XSLJDWPDebugger xSLJDWPDebugger = xSLStylesheet.getJDWPDebugger();
        if (xSLJDWPDebugger == null) {
            return null;
        }
        XSLJDWPEventRequestManager xSLJDWPEventRequestManager = xSLJDWPDebugger.getEventRequestManager();
        int n = xSLJDWPEventRequestManager.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            XSLJDWPEventRequestGroup xSLJDWPEventRequestGroup = (XSLJDWPEventRequestGroup)xSLJDWPEventRequestManager.get(i);
            if (xSLJDWPEventRequestGroup.getEventKind() != 8 || (n2 = xSLJDWPEventRequestGroup.getModifiers()) == 0) continue;
            XSLJDWPEventRequest[] xSLJDWPEventRequestArray = xSLJDWPEventRequestGroup.getXSLJDWPEventRequests();
            for (int j = 0; j < n2; ++j) {
                XSLJDWPEventRequest xSLJDWPEventRequest = xSLJDWPEventRequestArray[j];
                if (xSLJDWPEventRequest == null || xSLJDWPEventRequest.getModKind() != 5) continue;
                String string = null;
                String string2 = null;
                Hashtable hashtable = xSLStylesheet.getJDWPVirtualMachine().getAllClassesByID();
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    try {
                        Integer n3 = (Integer)enumeration.nextElement();
                        string2 = (String)hashtable.get(n3);
                        URL uRL = new URL(string2);
                        string = XSLJDWPUtil.getClassName(uRL);
                    }
                    catch (Exception exception) {
                        string = "";
                    }
                    if (!string.equals(((XSLJDWPClassMatchEventRequest)xSLJDWPEventRequest).getClassPattern())) continue;
                    this.events.setSuspendPolicy(xSLJDWPEventRequestGroup.getSuspendPolicy());
                    int n4 = xSLJDWPEventRequestGroup.getRequestID();
                    xSLJDWPClassPrepareEvent = new XSLJDWPClassPrepareEvent(xSLStylesheet, n4, string, string2);
                    xSLJDWPEventRequestManager.remove(xSLJDWPEventRequestGroup);
                    return xSLJDWPClassPrepareEvent;
                }
            }
        }
        return xSLJDWPClassPrepareEvent;
    }

    private XSLJDWPEvent reportBreakpointEvent(XSLJDWPEventValue4ContextNode xSLJDWPEventValue4ContextNode, XSLJDWPLocation xSLJDWPLocation) {
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue4ContextNode.getXSLStylesheet();
        XSLJDWPDebugger xSLJDWPDebugger = xSLStylesheet.getJDWPDebugger();
        XSLJDWPEventRequestManager xSLJDWPEventRequestManager = xSLJDWPDebugger.getEventRequestManager();
        int n = xSLJDWPEventRequestManager.size();
        for (int i = 0; i < n; ++i) {
            XSLJDWPEventRequestGroup xSLJDWPEventRequestGroup = (XSLJDWPEventRequestGroup)xSLJDWPEventRequestManager.get(i);
            if (xSLJDWPEventRequestGroup.getEventKind() != 2) continue;
            XSLJDWPEventRequest[] xSLJDWPEventRequestArray = xSLJDWPEventRequestGroup.getXSLJDWPEventRequests();
            int n2 = xSLJDWPEventRequestGroup.getModifiers();
            for (int j = 0; j < n2; ++j) {
                XSLJDWPLocation xSLJDWPLocation2;
                XSLJDWPEventRequest xSLJDWPEventRequest = xSLJDWPEventRequestArray[j];
                if (xSLJDWPEventRequest.getModKind() != 7 || !this.compare(xSLJDWPLocation2 = ((XSLJDWPLocationOnlyEventRequest)xSLJDWPEventRequest).getLocation(), xSLJDWPLocation)) continue;
                this.events.setSuspendPolicy(xSLJDWPEventRequestGroup.getSuspendPolicy());
                XSLJDWPBreakpointEvent xSLJDWPBreakpointEvent = new XSLJDWPBreakpointEvent(xSLJDWPLocation2);
                xSLJDWPBreakpointEvent.setThreadID(1);
                xSLJDWPBreakpointEvent.setRequestID(xSLJDWPEventRequestGroup.getRequestID());
                XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "XML Source Breakpoint hit!");
                return xSLJDWPBreakpointEvent;
            }
        }
        return null;
    }

    private XSLJDWPEvent reportBreakpointEvent(XSLJDWPEventValue xSLJDWPEventValue, XSLJDWPLocation xSLJDWPLocation) {
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue.getXSLStylesheet();
        XSLJDWPDebugger xSLJDWPDebugger = xSLStylesheet.getJDWPDebugger();
        XSLJDWPEventRequestManager xSLJDWPEventRequestManager = xSLJDWPDebugger.getEventRequestManager();
        int n = xSLJDWPEventRequestManager.size();
        for (int i = 0; i < n; ++i) {
            XSLJDWPEventRequestGroup xSLJDWPEventRequestGroup = (XSLJDWPEventRequestGroup)xSLJDWPEventRequestManager.get(i);
            if (xSLJDWPEventRequestGroup.getEventKind() != 2) continue;
            XSLJDWPEventRequest[] xSLJDWPEventRequestArray = xSLJDWPEventRequestGroup.getXSLJDWPEventRequests();
            int n2 = xSLJDWPEventRequestGroup.getModifiers();
            for (int j = 0; j < n2; ++j) {
                XSLJDWPLocation xSLJDWPLocation2;
                XSLJDWPEventRequest xSLJDWPEventRequest = xSLJDWPEventRequestArray[j];
                if (xSLJDWPEventRequest.getModKind() != 7 || !this.compare(xSLJDWPLocation2 = ((XSLJDWPLocationOnlyEventRequest)xSLJDWPEventRequest).getLocation(), xSLJDWPLocation)) continue;
                this.haltpoints.clear();
                this.methodendpoint = -1L;
                this.events.setSuspendPolicy(xSLJDWPEventRequestGroup.getSuspendPolicy());
                XSLJDWPBreakpointEvent xSLJDWPBreakpointEvent = new XSLJDWPBreakpointEvent(xSLJDWPLocation2);
                xSLJDWPBreakpointEvent.setThreadID(1);
                xSLJDWPBreakpointEvent.setRequestID(xSLJDWPEventRequestGroup.getRequestID());
                XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "Breakpoint hit!");
                return xSLJDWPBreakpointEvent;
            }
        }
        return null;
    }

    private XSLJDWPEvent reportEvent(XSLJDWPEventValue xSLJDWPEventValue) {
        XSLJDWPEvent xSLJDWPEvent = null;
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue.getXSLStylesheet();
        this.removeframe = false;
        switch (xSLJDWPEventValue.getEventKind()) {
            case 90: {
                xSLJDWPEvent = new XSLJDWPVMStartEvent();
                this.events.setSuspendPolicy((byte)2);
                break;
            }
            case 99: {
                xSLJDWPEvent = new XSLJDWPVMDeathEvent();
                this.events.setSuspendPolicy((byte)0);
                break;
            }
            case 6: {
                xSLJDWPEvent = xSLJDWPEventValue.getEvent();
                this.events.setSuspendPolicy(xSLJDWPEventValue.getSuspendPolicy());
                break;
            }
            case 7: {
                xSLJDWPEvent = xSLJDWPEventValue.getEvent();
                this.events.setSuspendPolicy(xSLJDWPEventValue.getSuspendPolicy());
                break;
            }
            case 2: {
                break;
            }
            case 10: {
                XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "CLASS_LOAD Event can be fired");
                XSLJDWPLocation xSLJDWPLocation = this.calculateGeneralLocation(xSLJDWPEventValue);
                this.addFrame(xSLJDWPEventValue, xSLJDWPLocation, (byte)10);
                break;
            }
            case 9: {
                XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "CLASS_UNLOAD Event can be fired");
                XSLJDWPLocation xSLJDWPLocation = this.calculateGeneralLocation(xSLJDWPEventValue);
                this.removeframe = true;
                break;
            }
            case 40: {
                XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "METHOD_ENTRY Event can be fired");
                XSLJDWPLocation xSLJDWPLocation = this.calculateGeneralLocation(xSLJDWPEventValue);
                this.addFrame(xSLJDWPEventValue, xSLJDWPLocation, (byte)40);
                xSLJDWPEvent = this.reportMethodEntryExitEvent(xSLJDWPEventValue, xSLJDWPLocation, true);
                break;
            }
            case 41: {
                XSLJDWPUtil.printTrace(xSLStylesheet.getXSLDebugProp(), "METHOD_EXIT Event can be fired");
                XSLJDWPLocation xSLJDWPLocation = this.calculateGeneralLocation(xSLJDWPEventValue);
                this.removeframe = true;
                xSLJDWPEvent = this.reportMethodEntryExitEvent(xSLJDWPEventValue, xSLJDWPLocation, false);
                break;
            }
        }
        this.updateFrameLocation(xSLStylesheet);
        return xSLJDWPEvent;
    }

    private int getClassID(XSLJDWPEventValue xSLJDWPEventValue) {
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue.getXSLStylesheet();
        String string = xSLJDWPEventValue.getBaseURL();
        if (string == null) {
            return 0;
        }
        int n = xSLStylesheet.getJDWPVirtualMachine().getClassID(string);
        return n;
    }

    private XSLJDWPEvent reportMethodEntryExitEvent(XSLJDWPEventValue xSLJDWPEventValue, XSLJDWPLocation xSLJDWPLocation, boolean bl) {
        XSLStylesheet xSLStylesheet = xSLJDWPEventValue.getXSLStylesheet();
        XSLJDWPDebugger xSLJDWPDebugger = xSLStylesheet.getJDWPDebugger();
        XSLJDWPEventRequestManager xSLJDWPEventRequestManager = xSLJDWPDebugger.getEventRequestManager();
        int n = xSLJDWPEventRequestManager.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            XSLJDWPEventRequestGroup xSLJDWPEventRequestGroup = (XSLJDWPEventRequestGroup)xSLJDWPEventRequestManager.get(i);
            if (bl && xSLJDWPEventRequestGroup.getEventKind() != 40 || !bl && xSLJDWPEventRequestGroup.getEventKind() != 41) continue;
            XSLJDWPEventRequest[] xSLJDWPEventRequestArray = xSLJDWPEventRequestGroup.getXSLJDWPEventRequests();
            int n3 = xSLJDWPEventRequestGroup.getModifiers();
            for (n2 = 0; n2 < n3; ++n2) {
                XSLJDWPEventRequest xSLJDWPEventRequest = xSLJDWPEventRequestArray[n2];
                if (xSLJDWPEventRequest == null || xSLJDWPEventRequest.getModKind() != 5) continue;
                String string = null;
                String string2 = null;
                Hashtable hashtable = xSLStylesheet.getJDWPVirtualMachine().getAllClassesByID();
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    try {
                        Integer n4 = (Integer)enumeration.nextElement();
                        string2 = (String)hashtable.get(n4);
                        URL uRL = new URL(string2);
                        string = XSLJDWPUtil.getClassName(uRL);
                    }
                    catch (Exception exception) {
                        string = "";
                    }
                    if (!string.equals(((XSLJDWPClassMatchEventRequest)xSLJDWPEventRequest).getClassPattern())) continue;
                    this.events.setSuspendPolicy(xSLJDWPEventRequestGroup.getSuspendPolicy());
                    int n5 = xSLJDWPEventRequestGroup.getRequestID();
                    XSLJDWPEvent xSLJDWPEvent = bl ? new XSLJDWPMethodEntryEvent(n5, 1, xSLJDWPLocation) : new XSLJDWPMethodExitEvent(n5, 1, xSLJDWPLocation);
                    xSLJDWPEventRequestManager.remove(xSLJDWPEventRequestGroup);
                    return xSLJDWPEvent;
                }
            }
            if (n2 != n3) continue;
            this.events.setSuspendPolicy(xSLJDWPEventRequestGroup.getSuspendPolicy());
            int n6 = xSLJDWPEventRequestGroup.getRequestID();
            XSLJDWPEvent xSLJDWPEvent = bl ? new XSLJDWPMethodEntryEvent(n6, 1, xSLJDWPLocation) : new XSLJDWPMethodExitEvent(n6, 1, xSLJDWPLocation);
            return xSLJDWPEvent;
        }
        return null;
    }

    private boolean compare(XSLJDWPLocation xSLJDWPLocation, XSLJDWPLocation xSLJDWPLocation2) {
        if (xSLJDWPLocation2.getClassID() != xSLJDWPLocation.getClassID()) {
            return false;
        }
        if (xSLJDWPLocation2.getMethodID() != xSLJDWPLocation.getMethodID()) {
            return false;
        }
        return xSLJDWPLocation2.getIndex() == xSLJDWPLocation.getIndex();
    }
}

