/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.text.serialization;

import com.oracle.premigration.reports.text.TextReportContext;
import com.oracle.premigration.reports.text.TextReportSection;
import com.oracle.premigration.reports.text.TextReportSectionName;
import com.oracle.premigration.reports.text.serialization.TextReportField;
import com.oracle.premigration.reports.text.serialization.TextReportNotesTable;
import com.oracle.premigration.reports.text.serialization.TextReportResultDescriptionTable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import lombok.NonNull;

public class TextReportLegend
extends TextReportField {
    private final Map<TextReportSectionName, TextReportField> reportDescriptionTables = new EnumMap<TextReportSectionName, TextReportField>(TextReportSectionName.class);

    public TextReportLegend(@NonNull TextReportContext reportContext, @NonNull Field field, @NonNull Object owningObject) {
        super(reportContext, field, owningObject);
        if (reportContext == null) {
            throw new NullPointerException("reportContext is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (owningObject == null) {
            throw new NullPointerException("owningObject is marked non-null but is null");
        }
        this.reportDescriptionTables.put(TextReportSectionName.RESULT_LEGEND, new TextReportResultDescriptionTable(reportContext, field, owningObject));
        this.reportDescriptionTables.put(TextReportSectionName.REPORT_NOTES, new TextReportNotesTable(reportContext, field, owningObject));
    }

    @Override
    public void printText(TextReportSection section) {
        Collection<TextReportSectionName> orderedSectionNames = TextReportSectionName.getOrderForPart(TextReportSectionName.Part.REPORT_LEGEND);
        for (TextReportSectionName sectionName : orderedSectionNames) {
            TextReportField reportSection = this.reportDescriptionTables.get((Object)sectionName);
            if (reportSection == null) continue;
            this.reportContext.getPrintWriter().print(sectionName.getSectionHeader(this.reportContext));
            reportSection.printText(section);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextReportLegend)) {
            return false;
        }
        TextReportLegend other = (TextReportLegend)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<TextReportSectionName, TextReportField> this$reportDescriptionTables = this.reportDescriptionTables;
        Map<TextReportSectionName, TextReportField> other$reportDescriptionTables = other.reportDescriptionTables;
        return !(this$reportDescriptionTables == null ? other$reportDescriptionTables != null : !((Object)this$reportDescriptionTables).equals(other$reportDescriptionTables));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextReportLegend;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<TextReportSectionName, TextReportField> $reportDescriptionTables = this.reportDescriptionTables;
        result = result * 59 + ($reportDescriptionTables == null ? 43 : ((Object)$reportDescriptionTables).hashCode());
        return result;
    }
}

