/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.text.serialization;

import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.json.CpatJsonIgnoreIfNull;
import com.oracle.premigration.reports.text.TextProperty;
import com.oracle.premigration.reports.text.TextReportContext;
import com.oracle.premigration.reports.text.TextReportSection;
import com.oracle.premigration.reports.text.TextReportSectionName;
import com.oracle.premigration.reports.text.TextValueHint;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import lombok.NonNull;

public abstract class TextReportField {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(TextReportField.class.getName());
    protected TextReportContext reportContext;
    protected Field field;
    protected Object value;

    protected TextReportField(@NonNull TextReportContext reportContext, @NonNull Field field, @NonNull Object owningObject) {
        if (reportContext == null) {
            throw new NullPointerException("reportContext is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (owningObject == null) {
            throw new NullPointerException("owningObject is marked non-null but is null");
        }
        this.reportContext = reportContext;
        this.field = field;
        this.value = TextReportField.getValue(field, owningObject);
    }

    public abstract void printText(TextReportSection var1);

    public TextValueHint getValueHint() {
        return TextReportField.getTextValueHint(this.field);
    }

    public TextReportSectionName getSectionName() {
        return this.field.getAnnotation(TextProperty.class).section();
    }

    public String getLabelKey() {
        String labelKey = this.field.getAnnotation(TextProperty.class).labelKey();
        return labelKey.isEmpty() ? this.field.getName() : labelKey;
    }

    public static Object getValue(Field field, Object owningObject) {
        try {
            field.setAccessible(true);
            return field.get(owningObject);
        }
        catch (IllegalAccessException e) {
            log.severe("Field not accessible", e);
            throw new IllegalArgumentException("Field not accessible", e);
        }
    }

    public static TextValueHint getTextValueHint(Field field) {
        return field.getAnnotation(TextProperty.class).valueHint();
    }

    public TextReportContext getReportContext() {
        return this.reportContext;
    }

    public Field getField() {
        return this.field;
    }

    public Object getValue() {
        return this.value;
    }

    public void setReportContext(TextReportContext reportContext) {
        this.reportContext = reportContext;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextReportField)) {
            return false;
        }
        TextReportField other = (TextReportField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TextReportContext this$reportContext = this.getReportContext();
        TextReportContext other$reportContext = other.getReportContext();
        if (this$reportContext == null ? other$reportContext != null : !((Object)this$reportContext).equals(other$reportContext)) {
            return false;
        }
        Field this$field = this.getField();
        Field other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TextReportField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TextReportContext $reportContext = this.getReportContext();
        result = result * 59 + ($reportContext == null ? 43 : ((Object)$reportContext).hashCode());
        Field $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "TextReportField(reportContext=" + this.getReportContext() + ", field=" + this.getField() + ", value=" + this.getValue() + ")";
    }

    public static class TextReportFieldFactory {
        private TextReportFieldFactory() {
        }

        public static TextReportField createTextReportField(TextReportContext reportContext, Field field, Object owningObject) {
            if (field.isAnnotationPresent(TextProperty.class) && !TextReportFieldFactory.ignoreFieldWhenNull(field, owningObject)) {
                Class<? extends TextReportField> serializationClass = field.getAnnotation(TextProperty.class).serializationClass();
                try {
                    Constructor<? extends TextReportField> constructor = serializationClass.getConstructor(TextReportContext.class, Field.class, Object.class);
                    return constructor.newInstance(reportContext, field, owningObject);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    log.severe("Error instantiating TextReportField: " + serializationClass.getName(), e);
                    return null;
                }
            }
            return null;
        }

        private static boolean ignoreFieldWhenNull(Field field, Object owningObject) {
            if (field.isAnnotationPresent(CpatJsonIgnoreIfNull.class)) {
                Object value = TextReportField.getValue(field, owningObject);
                return value == null;
            }
            return false;
        }
    }
}

