/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.text.serialization;

import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.text.serialization.TextReportDisplayElement;
import java.util.ArrayList;
import java.util.List;

class TextReportColumn {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(TextReportColumn.class.getName());
    private final String headerText;
    private final List<TextReportDisplayElement> values = new ArrayList<TextReportDisplayElement>();
    private int widestValue;
    private int width;
    private boolean last;

    public TextReportColumn(String headerText) {
        this.headerText = headerText;
        this.widestValue = headerText.length();
        this.last = false;
    }

    boolean hasDataRemaining(int rowIndex) {
        return this.values.get(rowIndex).hasDataRemaining();
    }

    void addDisplayElement(TextReportDisplayElement displayElement) {
        if (displayElement.getValue().length() > this.widestValue) {
            this.widestValue = displayElement.getValue().length();
        }
        this.values.add(displayElement);
    }

    String getHeader() {
        if (this.last) {
            return this.headerText;
        }
        return Utilities.padRight(this.headerText, this.width + 1);
    }

    String getHeaderDecoration() {
        String decoration = Utilities.repeatCharacter(this.width, '-');
        if (this.last) {
            return decoration;
        }
        return decoration + " ";
    }

    public String getHeaderText() {
        return this.headerText;
    }

    public List<TextReportDisplayElement> getValues() {
        return this.values;
    }

    public int getWidestValue() {
        return this.widestValue;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isLast() {
        return this.last;
    }

    public void setWidestValue(int widestValue) {
        this.widestValue = widestValue;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextReportColumn)) {
            return false;
        }
        TextReportColumn other = (TextReportColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWidestValue() != other.getWidestValue()) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.isLast() != other.isLast()) {
            return false;
        }
        String this$headerText = this.getHeaderText();
        String other$headerText = other.getHeaderText();
        if (this$headerText == null ? other$headerText != null : !this$headerText.equals(other$headerText)) {
            return false;
        }
        List<TextReportDisplayElement> this$values = this.getValues();
        List<TextReportDisplayElement> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TextReportColumn;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWidestValue();
        result = result * 59 + this.getWidth();
        result = result * 59 + (this.isLast() ? 79 : 97);
        String $headerText = this.getHeaderText();
        result = result * 59 + ($headerText == null ? 43 : $headerText.hashCode());
        List<TextReportDisplayElement> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    public String toString() {
        return "TextReportColumn(headerText=" + this.getHeaderText() + ", values=" + this.getValues() + ", widestValue=" + this.getWidestValue() + ", width=" + this.getWidth() + ", last=" + this.isLast() + ")";
    }
}

