/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.helpers;

import com.oracle.premigration.commons.enums.Version;
import com.oracle.premigration.commons.io.StdUtil;
import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.exceptions.PremigrationException;
import com.oracle.premigration.helpers.Utilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;

public class AppVersion {
    private static final Properties buildProperties;
    private static final Language lang;

    private AppVersion() {
    }

    public static String getVersionString() throws PremigrationException {
        try {
            String version = buildProperties.getProperty("build.version");
            if (version == null) {
                throw new NullPointerException("version is null");
            }
            return version;
        }
        catch (Exception e) {
            throw new PremigrationException("Error fetching version string", e);
        }
    }

    public static int compareAppVersion(String inputVersion) {
        try {
            String currentVersion = AppVersion.getVersionString().replace("-", ".");
            inputVersion = inputVersion.replace("-", ".");
            List<Integer> curVerList = Version.toList(currentVersion);
            List<Integer> inputVerList = Version.toList(inputVersion);
            int compareResult = Version.compare(curVerList, inputVerList);
            if (compareResult == 0) {
                return 0;
            }
            if (compareResult < 0) {
                return 1;
            }
            return 2;
        }
        catch (PremigrationException | RuntimeException e) {
            StdUtil.errPrintln(Utilities.getErrorText("ERROR4000", e, new String[0]));
            return CheckResult.FATAL.getExitCode();
        }
    }

    public static void printVersionInfo(PrintStream printStream) throws PremigrationException {
        String version = AppVersion.getVersionString();
        String versionMsg = lang.txt("APP_VERSION_MSG", version, buildProperties.getProperty("build.type"));
        printStream.println(versionMsg);
        printStream.println(lang.txt("APP_BUILD_DATE_MSG", buildProperties.getProperty("build.date")));
        printStream.println(lang.txt("APP_BUILD_HASH_MSG", buildProperties.getProperty("build.hash")));
    }

    public static int checkForUpdates() {
        try {
            JsonObject cpatJsonDoc = AppVersion.getLatestAvailableVersionObject();
            String latestVersion = cpatJsonDoc.getString("latestVersion");
            String currentVersion = AppVersion.getVersionString();
            if (AppVersion.compareAppVersion(latestVersion) == 1) {
                StdUtil.println(lang.txt("APP_UPDATE_AVAILABLE", currentVersion, latestVersion));
                String mosNoteURL = cpatJsonDoc.getString("mosNoteURL");
                StdUtil.println(lang.txt("APP_GET_UPDATE_INFO_FROM", mosNoteURL));
                return 1;
            }
            StdUtil.println(lang.txt("APP_NO_UPDATE_AVAILABLE", currentVersion));
            return 0;
        }
        catch (PremigrationException | IOException e) {
            StdUtil.println(Utilities.getErrorText("ERROR4001", e, new String[0]));
            return CheckResult.FATAL.getExitCode();
        }
    }

    private static JsonObject getLatestAvailableVersionObject() throws IOException {
        boolean lrgRun;
        try {
            lrgRun = Boolean.parseBoolean(System.getProperty("cpat.lrg", "false"));
        }
        catch (Exception e) {
            lrgRun = false;
        }
        String cpatURL = lrgRun ? "http://localhost:8675/cpat.json" : "https://www.oracle.com/a/tech/docs/cpat.json";
        String jsonFromURL = AppVersion.fetchJSONDoc(cpatURL);
        try (JsonReader jsonReader = Json.createReader(new StringReader(jsonFromURL));){
            JsonObject jsonObject = jsonReader.readObject();
            return jsonObject;
        }
    }

    private static String fetchJSONDoc(String cpatURL) throws IOException {
        int TIMEOUT_MILLISECONDS = 60000;
        URLConnection conn = new URL(cpatURL).openConnection();
        if (conn.getConnectTimeout() < 1 || conn.getConnectTimeout() == Integer.MAX_VALUE) {
            conn.setConnectTimeout(60000);
        }
        if (conn.getReadTimeout() < 1 || conn.getReadTimeout() == Integer.MAX_VALUE) {
            conn.setReadTimeout(60000);
        }
        InputStream is = conn.getInputStream();
        BufferedReader rd = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        String jsonText = AppVersion.readAll(rd);
        is.close();
        return jsonText;
    }

    private static String readAll(Reader rd) throws IOException {
        int cp;
        StringBuilder sb = new StringBuilder();
        while ((cp = rd.read()) != -1) {
            sb.append((char)cp);
        }
        return sb.toString();
    }

    public static int getAppAgeInDays() {
        boolean dateTest;
        try {
            dateTest = Boolean.parseBoolean(System.getProperty("cpat.date", "false"));
        }
        catch (Exception e) {
            dateTest = false;
        }
        if (dateTest) {
            return 90;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
        Object dateOfLastBuild = buildProperties.get("build.date");
        Date currentDate = new Date();
        try {
            Date dateBuildProject = formatter.parse((String)dateOfLastBuild);
            long currentDayInMs = currentDate.getTime();
            long buildDayInMs = dateBuildProject.getTime();
            return (int)TimeUnit.DAYS.convert(currentDayInMs - buildDayInMs, TimeUnit.MILLISECONDS);
        }
        catch (ParseException e) {
            return 0;
        }
    }

    public static Date getAppVersionDate() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
        Object dateOfLastBuild = buildProperties.get("build.date");
        try {
            return formatter.parse((String)dateOfLastBuild);
        }
        catch (ParseException e) {
            return null;
        }
    }

    static {
        lang = Language.getInstance();
        buildProperties = new Properties();
        try (InputStream is = AppVersion.class.getResourceAsStream("/build_info.properties");){
            buildProperties.load(is);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

