/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.fixups;

import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.fixups.Fixup;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.text.TextValueHint;
import com.oracle.premigration.reports.text.serialization.TextReportDisplayElement;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public final class FixupFileHelper
implements Closeable {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(FixupFileHelper.class.getName());
    private static final Language lang = Language.getInstance();
    private final Check check;
    private final Fixup fixup;
    private final PrintWriter printWriter;

    public FixupFileHelper(Check check, Fixup fixup) throws IOException {
        this.check = check;
        this.fixup = fixup;
        this.printWriter = this.createPrintWriter();
        this.writeStandardProlog();
    }

    private PrintWriter createPrintWriter() throws IOException {
        File fixupFile = this.fixup.getFile();
        log.info("Creating '" + this.fixup.getFixupName() + "' fixup for " + this.check.getName() + ": " + fixupFile.getPath());
        File parentFile = fixupFile.getParentFile();
        if (parentFile != null && (parentFile.exists() || parentFile.mkdirs())) {
            return new PrintWriter(fixupFile);
        }
        throw new IOException("Unable to create PrintWriter for " + fixupFile.getCanonicalPath());
    }

    public void writeStaticFixupText() {
        String fixupText = Utilities.getStaticFixupText(this.check.getName().toUpperCase());
        this.printWriter.println(fixupText);
    }

    public void writeFixupText(List<String> fixupText) {
        this.writeFixupText(fixupText, 0);
    }

    public void writeFixupText(List<String> fixupText, int spacing) {
        if (fixupText == null) {
            return;
        }
        String spacingChars = Utilities.repeatCharacter(spacing, '\n');
        for (String aLine : fixupText) {
            this.printWriter.println(aLine + spacingChars);
        }
    }

    public void writeNotes() {
        if (!this.fixup.getNotes().isEmpty()) {
            this.printWriter.println("-- " + lang.txt("CHECK_FIXUP_NOTES"));
            for (String note : this.fixup.getNotes()) {
                TextReportDisplayElement fixupComments = new TextReportDisplayElement(note, TextValueHint.NATURAL_LANGUAGE);
                while (fixupComments.hasDataRemaining()) {
                    this.printWriter.println("--    " + fixupComments.getSomeText(74));
                }
                this.printWriter.println("--");
            }
        }
    }

    private void writeStandardProlog() {
        this.printWriter.println("-- " + this.fixup.getFixupName());
        this.printWriter.println("--");
        this.printWriter.println("-- " + lang.txt("CHECK_NAME_LABEL") + " " + this.check.getName());
        this.printWriter.println("-- " + lang.txt("CHECK_RESULT_LABEL") + " " + (Object)((Object)this.check.getResult()));
        this.printWriter.println("--");
        this.printWriter.println("-- " + lang.txt("CHECK_FIXUP_EXECUTION_CONTEXT"));
        this.printWriter.println("--    " + lang.txt("CHECK_FIXUP_LOCUS_PREFIX") + " " + (Object)((Object)this.fixup.getFixupLocus()));
        if (Boolean.TRUE.equals(this.fixup.getRunAtCDBLevel())) {
            this.printWriter.println("--    " + lang.txt("CHECK_FIXUP_CDB_CONTEXT"));
        }
        if (Boolean.TRUE.equals(this.fixup.getRestartRequired())) {
            this.printWriter.println("--    " + lang.txt("CHECK_FIXUP_RESTART_REQUIRED_YES"));
        } else {
            this.printWriter.println("--    " + lang.txt("CHECK_FIXUP_RESTART_REQUIRED_NO"));
        }
        this.printWriter.println("--");
        this.printWriter.println("-- " + lang.txt("CHECK_4_ACTION_LABEL"));
        TextReportDisplayElement fixupComments = new TextReportDisplayElement(this.check.getAction(), TextValueHint.NATURAL_LANGUAGE);
        while (fixupComments.hasDataRemaining()) {
            this.printWriter.println("--    " + fixupComments.getSomeText(74));
        }
        this.printWriter.println();
    }

    private void writeStandardEpilog() {
        this.printWriter.println();
        this.printWriter.println("-- end of " + this.fixup.getFixupName());
    }

    @Override
    public void close() throws IOException {
        if (this.printWriter != null) {
            this.writeStandardEpilog();
            this.printWriter.close();
            log.info("Completed generation of '" + this.fixup.getFixupName() + "'");
        }
    }

    public Check getCheck() {
        return this.check;
    }

    public Fixup getFixup() {
        return this.fixup;
    }

    public PrintWriter getPrintWriter() {
        return this.printWriter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixupFileHelper)) {
            return false;
        }
        FixupFileHelper other = (FixupFileHelper)o;
        Check this$check = this.getCheck();
        Check other$check = other.getCheck();
        if (this$check == null ? other$check != null : !this$check.equals(other$check)) {
            return false;
        }
        Fixup this$fixup = this.getFixup();
        Fixup other$fixup = other.getFixup();
        if (this$fixup == null ? other$fixup != null : !((Object)this$fixup).equals(other$fixup)) {
            return false;
        }
        PrintWriter this$printWriter = this.getPrintWriter();
        PrintWriter other$printWriter = other.getPrintWriter();
        return !(this$printWriter == null ? other$printWriter != null : !this$printWriter.equals(other$printWriter));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Check $check = this.getCheck();
        result = result * 59 + ($check == null ? 43 : $check.hashCode());
        Fixup $fixup = this.getFixup();
        result = result * 59 + ($fixup == null ? 43 : ((Object)$fixup).hashCode());
        PrintWriter $printWriter = this.getPrintWriter();
        result = result * 59 + ($printWriter == null ? 43 : $printWriter.hashCode());
        return result;
    }

    public String toString() {
        return "FixupFileHelper(check=" + this.getCheck() + ", fixup=" + this.getFixup() + ", printWriter=" + this.getPrintWriter() + ")";
    }
}

